/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import vib.InterpolatedImage;

public class Bilateral_Filter
implements PlugInFilter {
    ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Bilateral Parameters");
        genericDialog.addNumericField("spatial radius", 3.0, 0);
        genericDialog.addNumericField("range radius", 50.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        InterpolatedImage interpolatedImage = new InterpolatedImage(this.image);
        InterpolatedImage interpolatedImage2 = interpolatedImage.cloneDimensionsOnly();
        double d = genericDialog.getNextNumber();
        double d2 = genericDialog.getNextNumber();
        float[] fArray = Bilateral_Filter.makeKernel(d);
        float[] fArray2 = Bilateral_Filter.makeKernel(d2);
        interpolatedImage2.image.setTitle(interpolatedImage.image.getTitle() + "-" + d + "-" + d2);
        InterpolatedImage.Iterator iterator = interpolatedImage2.iterator(true);
        InterpolatedImage interpolatedImage3 = interpolatedImage;
        float[] fArray3 = fArray;
        int n = fArray.length / 2;
        float[] fArray4 = fArray2;
        int n2 = fArray2.length / 2;
        while (iterator.next() != null) {
            int n3 = interpolatedImage3.getNoInterpol(iterator.i, iterator.j, iterator.k);
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < fArray3.length; ++i) {
                for (int j = 0; j < fArray3.length; ++j) {
                    int n4 = interpolatedImage3.getNoInterpol(iterator.i + j - n, iterator.j + i - n, iterator.k);
                    if (Math.abs(n4 - n3) > n2) continue;
                    float f3 = fArray3[j] * fArray3[i] * fArray4[n4 - n3 + n2];
                    f += (float)n4 * f3;
                    f2 += f3;
                }
            }
            interpolatedImage2.set(iterator.i, iterator.j, iterator.k, (int)(f / f2));
        }
        interpolatedImage2.image.show();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public static float[] makeKernel(double d) {
        float[] fArray;
        block4: {
            int n;
            float f;
            int n2;
            block3: {
                n2 = (int)(d += 1.0) * 2 - 1;
                fArray = new float[n2];
                f = 0.0f;
                for (n = 0; n < n2; ++n) {
                    double d2 = ((double)(n + 1) - d) / (d * 2.0) / 0.2;
                    fArray[n] = (float)Math.exp(-0.5 * d2 * d2);
                    f = (float)((double)f + d2);
                }
                if (!((double)f <= 0.0)) break block3;
                for (n = 0; n < n2; ++n) {
                    fArray[n] = 1.0f / (float)n2;
                }
                break block4;
            }
            if ((double)f == 1.0) break block4;
            n = 0;
            while (n < n2) {
                int n3 = n++;
                fArray[n3] = fArray[n3] / f;
            }
        }
        return fArray;
    }
}

