/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class Biorad_Reader
extends ImagePlus
implements PlugIn {
    private final int NOTE_SIZE = 96;
    private BufferedInputStream f;
    private String directory;
    private String fileName;
    private String notes = "";
    private int lutOffset = -1;

    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Open Biorad...", string);
        this.directory = openDialog.getDirectory();
        this.fileName = openDialog.getFileName();
        if (this.fileName == null) {
            return;
        }
        IJ.showStatus((String)("Opening: " + this.directory + this.fileName));
        FileInfo fileInfo = null;
        try {
            fileInfo = this.getHeaderInfo();
        }
        catch (Exception exception) {
            IJ.showStatus((String)"");
            IJ.showMessage((String)"BioradReader", (String)("" + exception));
            return;
        }
        if (fileInfo != null) {
            Object object;
            int n;
            if (this.fileName.toLowerCase().endsWith(".gz") && IJ.getVersion().compareTo("1.38s") < 0) {
                IJ.error((String)"ImageJ 1.38s or later required to open gzipped Biorad PIC files");
                return;
            }
            FileOpener fileOpener = new FileOpener(fileInfo);
            ImagePlus imagePlus = fileOpener.open(false);
            if (IJ.debugMode) {
                IJ.log((String)("imp=" + imagePlus));
            }
            if (imagePlus == null) {
                return;
            }
            this.setStack(this.fileName, imagePlus.getStack());
            this.setFileInfo(fileInfo);
            if (IJ.debugMode) {
                IJ.log((String)("FileInfo=" + fileInfo));
            }
            try {
                n = 1;
                switch (fileInfo.fileType) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 2;
                    }
                }
                object = this.getBioRadCalibration(fileInfo.width, fileInfo.height, fileInfo.nImages, n);
                this.setCalibration((Calibration)object);
            }
            catch (Exception exception) {
                IJ.showStatus((String)"");
                String string2 = exception.getMessage();
                if (exception == null) {
                    string2 = "" + exception;
                }
                if (string2.indexOf("EOF") == -1) {
                    IJ.showMessage((String)"BioradReader", (String)string2);
                }
                return;
            }
            n = 0;
            if (this.lutOffset != -1) {
                try {
                    n = this.getLut(fileInfo) ? 1 : 0;
                }
                catch (Exception exception) {
                    IJ.showStatus((String)"");
                    IJ.showMessage((String)"BioradReader", (String)("Can't read LUT from file because " + exception));
                    n = 0;
                }
            }
            if (n != 0) {
                object = new IndexColorModel(8, 256, fileInfo.reds, fileInfo.greens, fileInfo.blues);
                this.getProcessor().setColorModel((ColorModel)object);
                this.getStack().setColorModel((ColorModel)object);
            }
            if (!this.notes.equals("")) {
                this.setProperty("Info", this.notes);
            }
            if (IJ.debugMode) {
                IJ.log((String)("arg=|" + string + "|"));
            }
            if (string.equals("")) {
                this.show();
            }
        }
        if (IJ.debugMode) {
            IJ.log((String)"done");
        }
    }

    int getByte() throws IOException {
        int n = this.f.read();
        if (n == -1) {
            throw new IOException("unexpected EOF");
        }
        return n;
    }

    int getShort() throws IOException {
        int n = this.getByte();
        int n2 = this.getByte();
        return (n2 << 8) + n;
    }

    int getInt() throws IOException {
        int n = this.getShort();
        int n2 = this.getShort();
        return (n2 << 16) + n;
    }

    void openFile() throws IOException {
        this.f = this.fileName.toLowerCase().endsWith(".pic.gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.directory + this.fileName))) : new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
    }

    FileInfo getHeaderInfo() throws IOException {
        this.openFile();
        int n = this.getShort();
        int n2 = this.getShort();
        int n3 = this.getShort();
        this.f.skip(8L);
        int n4 = this.getShort();
        this.f.skip(38L);
        int n5 = this.getShort();
        this.f.close();
        String string = "This does not seem to be a Biorad Pic File";
        if (n5 != 12345) {
            throw new IOException(string);
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.fileFormat = 1;
        fileInfo.fileName = this.fileName;
        fileInfo.directory = this.directory;
        fileInfo.width = n;
        fileInfo.height = n2;
        fileInfo.nImages = n3;
        fileInfo.offset = 76;
        switch (n4) {
            case 1: {
                fileInfo.fileType = 0;
                break;
            }
            case 0: {
                fileInfo.fileType = 2;
                fileInfo.intelByteOrder = true;
            }
        }
        if (IJ.debugMode) {
            IJ.log((String)("fileType (0,2)=" + fileInfo.fileType));
        }
        return fileInfo;
    }

    Calibration getBioRadCalibration(int n, int n2, int n3, int n4) throws IOException {
        int n5;
        Calibration calibration = new Calibration();
        String string = new String();
        byte[] byArray = new byte[80];
        byte[] byArray2 = new byte[80];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = false;
        int n6 = 76 + n2 * n * n3 * n4;
        this.openFile();
        this.f.skip(n6);
        if (IJ.debugMode) {
            IJ.log((String)"getBioRadCalibration");
        }
        do {
            this.f.skip(2L);
            n5 = this.getInt();
            this.f.skip(4L);
            int n7 = this.getShort();
            this.f.skip(4L);
            this.f.read(byArray2);
            for (int i = 0; i < 80; ++i) {
                int n8 = byArray2[i];
                byArray[i] = n8 >= 32 && n8 <= 126 ? n8 : 32;
            }
            String string2 = new String(byArray);
            this.notes = this.notes + string2 + "\n";
            if (n7 != 1) {
                string = this.getField(string2, 1);
                if (string.indexOf("AXIS_2") >= 0) {
                    double d4;
                    calibration.pixelWidth = d4 = this.s2d(this.getField(string2, 4));
                    calibration.setUnit(this.getField(string2, 5));
                } else if (string.indexOf("AXIS_3") >= 0) {
                    double d5;
                    calibration.pixelHeight = d5 = this.s2d(this.getField(string2, 4));
                    calibration.setUnit(this.getField(string2, 5));
                } else if (string.indexOf("AXIS_4") >= 0) {
                    calibration.pixelDepth = d = this.s2d(this.getField(string2, 4));
                    if (this.getField(string2, 5).indexOf("Seconds") >= 0) {
                        bl = true;
                    }
                } else if (string.indexOf("INFO_FRAME_RATE") >= 0) {
                    d2 = this.s2d(this.getField(string2, 3));
                    calibration.frameInterval = d3 = 1.0 / d2;
                }
            }
            if (IJ.debugMode) {
                IJ.log((String)("Offset =" + n6));
            }
            n6 += 96;
        } while (n5 != 0 & this.f.available() >= 96);
        if (IJ.debugMode) {
            IJ.log((String)"lut?");
        }
        this.lutOffset = n6;
        if (bl) {
            calibration.pixelDepth = d3;
        }
        this.f.close();
        if (IJ.debugMode) {
            IJ.log((String)("BioRadCal" + calibration));
        }
        return calibration;
    }

    boolean getLut(FileInfo fileInfo) throws IOException {
        this.openFile();
        this.f.skip(this.lutOffset);
        fileInfo.reds = new byte[256];
        fileInfo.greens = new byte[256];
        fileInfo.blues = new byte[256];
        boolean bl = false;
        if (this.f.available() >= 768) {
            bl = true;
            this.f.read(fileInfo.reds);
            this.f.read(fileInfo.greens);
            this.f.read(fileInfo.blues);
        }
        this.f.close();
        return bl;
    }

    String getField(String string, int n) {
        int n2 = 32;
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            n3 = string.indexOf(n2, n3 + 1);
        }
        int n4 = string.indexOf(n2, n3 + 1);
        if (n3 >= 0 && n4 >= 0) {
            return string.substring(n3, n4);
        }
        return "";
    }

    double s2d(String string) {
        return Tools.parseDouble((String)string);
    }
}

