/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.ImageWriter;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Biorad_Writer
implements PlugIn {
    private static final String plugInName = "Biorad Writer";
    private static final String noImages = "Biorad Writer...\nNo images are open.";
    private static final String supportedTypes = "Biorad Writer...Supported types:\n\n16-bit Greyscale integer: INT\n(16-bit Greyscale unsigned integer) : UNINT\n8-bit Greyscale : BYTE\n8-bit Colour LUT (converted to greyscale): BYTE\n";

    public void run(String string) {
        SaveDialog saveDialog;
        String string2;
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.showMessage((String)noImages);
            return;
        }
        if (Biorad_Writer.imgType(imagePlus.getFileInfo().fileType) < 0) {
            IJ.showMessage((String)supportedTypes);
            return;
        }
        String string3 = string;
        if (string == null || string.equals("")) {
            string3 = imagePlus.getTitle();
        }
        if ((string2 = (saveDialog = new SaveDialog("Biorad Writer...", string3, ".PIC")).getFileName()) == null) {
            return;
        }
        String string4 = saveDialog.getDirectory();
        this.save(imagePlus, string4, string2);
    }

    public void save(ImagePlus imagePlus, String string, String string2) {
        int n;
        if (imagePlus == null) {
            IJ.showMessage((String)noImages);
            return;
        }
        FileInfo fileInfo = imagePlus.getFileInfo();
        fileInfo.fileType = n = Biorad_Writer.imgType(fileInfo.fileType);
        if (n < 0) {
            IJ.showMessage((String)supportedTypes);
            return;
        }
        fileInfo.fileName = string2;
        fileInfo.directory = string;
        fileInfo.intelByteOrder = true;
        Calibration calibration = imagePlus.getCalibration();
        fileInfo.pixelWidth = calibration.pixelWidth;
        fileInfo.pixelHeight = calibration.pixelHeight;
        fileInfo.pixelDepth = calibration.pixelDepth;
        fileInfo.unit = calibration.getUnits();
        if (fileInfo.unit.equals("\u00b5m") || fileInfo.unit.equals("um")) {
            fileInfo.unit = "microns";
        }
        if (IJ.debugMode) {
            IJ.log((String)("FileInfo: " + fileInfo));
        }
        try {
            this.writeImage(fileInfo, calibration);
        }
        catch (IOException iOException) {
            IJ.error((String)("An error occured writing the file.\n \n" + iOException));
            IJ.showStatus((String)"");
        }
    }

    void writeImage(FileInfo fileInfo, Calibration calibration) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(fileInfo.directory, fileInfo.fileName));
        this.writeHeader(fileInfo, fileOutputStream);
        ImageWriter imageWriter = new ImageWriter(fileInfo);
        imageWriter.write((OutputStream)fileOutputStream);
        this.writeFooter(fileInfo, fileOutputStream);
        fileOutputStream.close();
        IJ.showStatus((String)("Saved " + fileInfo.fileName));
    }

    public static int imgType(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return -1;
    }

    void writeDimensions(FileInfo fileInfo, OutputStream outputStream) throws IOException {
        this.writeShort(outputStream, (short)fileInfo.width);
        this.writeShort(outputStream, (short)fileInfo.height);
        this.writeShort(outputStream, (short)fileInfo.nImages);
    }

    void writeHeader(FileInfo fileInfo, OutputStream outputStream) throws IOException {
        String string;
        this.writeDimensions(fileInfo, outputStream);
        this.writeShort(outputStream, (short)0);
        this.writeShort(outputStream, (short)255);
        this.writeInt(outputStream, 1);
        if (fileInfo.fileType == 0) {
            this.writeShort(outputStream, (short)1);
        } else {
            this.writeShort(outputStream, (short)0);
        }
        this.writeShort(outputStream, (short)0);
        int n = fileInfo.fileName.length();
        if (n <= 31) {
            int n2 = 32 - n;
            String string2 = "";
            for (int i = 0; i < n2; ++i) {
                string2 = string2 + "\u0000";
            }
            string = new String(fileInfo.fileName + string2);
        } else {
            string = new String(fileInfo.fileName.substring(0, 31) + "\u0000");
        }
        outputStream.write(string.getBytes());
        this.writeShort(outputStream, (short)0);
        this.writeShort(outputStream, (short)7);
        this.writeShort(outputStream, (short)12345);
        this.writeShort(outputStream, (short)0);
        this.writeShort(outputStream, (short)255);
        this.writeShort(outputStream, (short)7);
        this.writeShort(outputStream, (short)0);
        this.writeShort(outputStream, (short)0);
        this.writeFloat(outputStream, 0.0f);
        this.writeShort(outputStream, (short)0);
        this.writeShort(outputStream, (short)0);
        this.writeShort(outputStream, (short)0);
    }

    void writeFooter(FileInfo fileInfo, OutputStream outputStream) throws IOException {
        outputStream.write(this.formNote("AXIS_2 001 0.000000e+00 " + IJ.d2s((double)fileInfo.pixelWidth, (int)8) + " " + fileInfo.unit, 1, 20));
        outputStream.write(this.formNote("AXIS_3 001 0.000000e+00 " + IJ.d2s((double)fileInfo.pixelHeight, (int)8) + " " + fileInfo.unit, 1, 20));
        if (fileInfo.nImages > 1) {
            outputStream.write(this.formNote("AXIS_4 001 0.000000e+00 " + IJ.d2s((double)fileInfo.pixelDepth, (int)8) + " " + fileInfo.unit, 1, 20));
            outputStream.write(this.formNote("AXIS_9 001 0.000000e+00 1.000000e+00 RGB channel", 0, 20));
        } else {
            outputStream.write(this.formNote("AXIS_4 011 0.000000e+00 1.000000e+00 RGB channel", 0, 20));
        }
    }

    byte[] formNote(String string, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeShort(byteArrayOutputStream, (short)-1);
        this.writeInt(byteArrayOutputStream, n);
        this.writeInt(byteArrayOutputStream, 0);
        this.writeShort(byteArrayOutputStream, (short)n2);
        this.writeInt(byteArrayOutputStream, 0);
        if (string.length() < 80) {
            String string2 = "                                                                                ";
            string = string + string2.substring(string.length());
        }
        byteArrayOutputStream.write(string.getBytes("ISO-8859-1"));
        return byteArrayOutputStream.toByteArray();
    }

    void writeShort(OutputStream outputStream, short s) throws IOException {
        byte by = (byte)(s & 0xFF);
        byte by2 = (byte)(s >> 8 & 0xFF);
        outputStream.write(by);
        outputStream.write(by2);
    }

    void writeInt(OutputStream outputStream, int n) throws IOException {
        byte by = (byte)(n & 0xFF);
        byte by2 = (byte)(n >> 8 & 0xFF);
        byte by3 = (byte)(n >> 16 & 0xFF);
        byte by4 = (byte)(n >> 24 & 0xFF);
        outputStream.write(by);
        outputStream.write(by2);
        outputStream.write(by3);
        outputStream.write(by4);
    }

    void writeFloat(OutputStream outputStream, float f) throws IOException {
        this.writeInt(outputStream, Float.floatToIntBits(f));
    }
}

