/*
 * Decompiled with CFR 0.152.
 */
import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class CropEditor_
implements PlugInFilter {
    ImagePlus image;
    ImageStack stack;
    int w;
    int h;
    int d;
    boolean verbose = false;

    private static int getPixel(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public void run(ImageProcessor imageProcessor) {
        byte[] byArray;
        int n;
        this.stack = this.image.getStack();
        this.d = this.stack == null ? 1 : this.stack.getSize();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        GenericDialog genericDialog = new GenericDialog("Parameters");
        genericDialog.addNumericField("xStart", 0.0, 0);
        genericDialog.addNumericField("xEnd", (double)(this.w - 1), 0);
        genericDialog.addNumericField("yStart", 0.0, 0);
        genericDialog.addNumericField("yEnd", (double)(this.h - 1), 0);
        genericDialog.addNumericField("zStart", 0.0, 0);
        genericDialog.addNumericField("zEnd", (double)(this.d - 1), 0);
        genericDialog.addNumericField("fillValue", 0.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n2 = (int)genericDialog.getNextNumber();
        int n3 = (int)genericDialog.getNextNumber() + 1;
        int n4 = (int)genericDialog.getNextNumber();
        int n5 = (int)genericDialog.getNextNumber() + 1;
        int n6 = (int)genericDialog.getNextNumber();
        int n7 = (int)genericDialog.getNextNumber() + 1;
        byte by = (byte)genericDialog.getNextNumber();
        if (n2 >= n3 || n4 >= n5 || n6 >= n7) {
            IJ.error((String)"Invalid dimensions");
            return;
        }
        int n8 = n3 - n2;
        int n9 = n5 - n4;
        int n10 = n7 - n6;
        ImageStack imageStack = new ImageStack(n8, n9);
        byte[] byArray2 = null;
        if (by != 0) {
            byArray2 = new byte[n8 * n9];
            for (n = 0; n < n8 * n9; ++n) {
                byArray2[n] = by;
            }
        }
        for (n = n6; n < 0; ++n) {
            byArray = new byte[n8 * n9];
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray, 0, n8 * n9);
            }
            imageStack.addSlice(null, (Object)byArray);
        }
        for (n = 0; n < n7 && n < this.d; ++n) {
            byArray = (byte[])this.stack.getProcessor(n + 1).getPixels();
            byte[] byArray3 = new byte[n8 * n9];
            if (this.w == n8 && this.h == n9) {
                System.arraycopy(byArray, 0, byArray3, 0, n8 * n9);
            } else {
                int n11;
                if (byArray2 != null) {
                    System.arraycopy(byArray2, 0, byArray3, 0, n8 * n9);
                }
                int n12 = n11 = n4 < 0 ? -n4 : 0;
                while (n11 < n9 && n11 + n4 < this.h) {
                    int n13;
                    int n14 = n13 = n2 < 0 ? -n2 : 0;
                    while (n13 < n8 && n13 + n2 < this.w) {
                        byArray3[n13 + n8 * n11] = byArray[n13 + n2 + this.w * (n11 + n4)];
                        ++n13;
                    }
                    ++n11;
                }
            }
            imageStack.addSlice(null, (Object)byArray3);
        }
        for (n = this.d; n < n7; ++n) {
            byArray = new byte[n8 * n9];
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray, 0, n8 * n9);
            }
            imageStack.addSlice(null, (Object)byArray);
        }
        ImagePlus imagePlus = new ImagePlus(this.image.getTitle() + " cropped", imageStack);
        if (AmiraParameters.isAmiraMesh(this.image)) {
            new AmiraParameters(this.image).setParameters(imagePlus);
        }
        if (IJ.getInstance() != null) {
            imagePlus.show();
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 131;
    }
}

