/*
 * Decompiled with CFR 0.152.
 */
import delaunay.DelaunayTriangulation;
import delaunay.Pnt;
import delaunay.Simplex;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.TreeMap;

public class Delaunay_Voronoi
implements PlugIn {
    public final int DELAUNAY = 1;
    public final int VORONOI = 2;
    int mode = 1;
    boolean showMeanDistance = false;
    final boolean drawZoom = IJ.getVersion().compareTo("1.37n") >= 0;

    public void run(String string) {
        Object object;
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            return;
        }
        GenericDialog genericDialog = new GenericDialog("Delaunay/Voronoi parameters");
        genericDialog.addChoice("mode", new String[]{"Delaunay", "Voronoi"}, "Delaunay");
        genericDialog.addCheckbox("interactive", !Interpreter.isBatchMode());
        genericDialog.addCheckbox("make Delaunay ROI", false);
        genericDialog.addCheckbox("showMeanDistance", false);
        ResultsTable resultsTable = Analyzer.getResultsTable();
        genericDialog.addCheckbox("inferSelectionFromParticles", imagePlus.getRoi() == null && resultsTable != null && resultsTable.getColumnIndex("XM") != -1);
        genericDialog.addCheckbox("export into Results", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.mode = genericDialog.getNextChoiceIndex() + 1;
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        this.showMeanDistance = genericDialog.getNextBoolean();
        boolean bl3 = genericDialog.getNextBoolean();
        boolean bl4 = genericDialog.getNextBoolean();
        if (bl3) {
            object = imagePlus.getCalibration();
            int n = resultsTable.getColumnIndex("XM");
            int n2 = resultsTable.getColumnIndex("YM");
            if (n < 0 || n2 < 0) {
                IJ.error((String)"You did not select Center of Mass in Analyze>Set Measurements...\nSelect it and try again.");
                return;
            }
            float[] fArray = resultsTable.getColumn(n);
            if (fArray == null || fArray.length == 0) {
                IJ.error((String)"No results found!");
                return;
            }
            float[] fArray2 = resultsTable.getColumn(n2);
            int[] nArray = new int[fArray.length];
            int[] nArray2 = new int[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                nArray[i] = (int)Math.round((double)fArray[i] / ((Calibration)object).pixelWidth - ((Calibration)object).xOrigin);
                nArray2[i] = (int)Math.round((double)fArray2[i] / ((Calibration)object).pixelHeight - ((Calibration)object).yOrigin);
            }
            imagePlus.setRoi((Roi)new PointRoi(nArray, nArray2, fArray.length));
        }
        object = new CustomCanvas(imagePlus);
        if (bl4) {
            this.exportResults(((CustomCanvas)object).delaunay, ((CustomCanvas)object).inf, resultsTable);
        }
        if (bl2) {
            imagePlus.setRoi(this.getRoi(((CustomCanvas)object).delaunay, ((CustomCanvas)object).inf));
            imagePlus.updateAndDraw();
            return;
        }
        if (!bl) {
            ((CustomCanvas)object).drawOverlay(null);
            imagePlus.updateAndDraw();
            return;
        }
        if (imagePlus.getStackSize() > 1) {
            new StackWindow(imagePlus, (ImageCanvas)object).addKeyListener((KeyListener)object);
        } else {
            new ImageWindow(imagePlus, (ImageCanvas)object).addKeyListener((KeyListener)object);
        }
        Roi roi = imagePlus.getRoi();
        if (roi != null) {
            roi.setImage(imagePlus);
        }
    }

    void exportResults(DelaunayTriangulation delaunayTriangulation, double d, ResultsTable resultsTable) {
        if (delaunayTriangulation == null) {
            return;
        }
        if (this.mode != 1) {
            IJ.error((String)"Operation only supported for Delaunay");
            return;
        }
        if (resultsTable.getLastColumn() >= 0) {
            if (!IJ.showMessageWithCancel((String)"Clear Results?", (String)"May I clear the results table?")) {
                return;
            }
            resultsTable.reset();
        }
        resultsTable.setHeading(0, "x1");
        resultsTable.setHeading(1, "y1");
        resultsTable.setHeading(2, "x2");
        resultsTable.setHeading(3, "y2");
        TreeMap treeMap = new TreeMap();
        Iterator iterator = delaunayTriangulation.iterator();
        while (iterator.hasNext()) {
            Simplex simplex = (Simplex)iterator.next();
            if (this.mode == 1) {
                Iterator iterator2 = simplex.iterator();
                Pnt pnt = (Pnt)iterator2.next();
                Pnt pnt2 = (Pnt)iterator2.next();
                Pnt pnt3 = (Pnt)iterator2.next();
                if (Math.abs(pnt.coord(0)) >= d || Math.abs(pnt2.coord(0)) >= d || Math.abs(pnt3.coord(0)) >= d) continue;
                this.addOneResult(treeMap, pnt, pnt2, resultsTable);
                this.addOneResult(treeMap, pnt, pnt3, resultsTable);
                this.addOneResult(treeMap, pnt2, pnt3, resultsTable);
                continue;
            }
            IJ.error((String)"TODO");
            return;
        }
        resultsTable.show("Results");
    }

    private void addOneResult(TreeMap treeMap, Pnt pnt, Pnt pnt2, ResultsTable resultsTable) {
        PntPair pntPair = new PntPair(pnt, pnt2);
        if (treeMap.containsKey(pntPair)) {
            return;
        }
        resultsTable.incrementCounter();
        resultsTable.addValue(0, pntPair.a.coord(0));
        resultsTable.addValue(1, pntPair.a.coord(1));
        resultsTable.addValue(2, pntPair.b.coord(0));
        resultsTable.addValue(3, pntPair.b.coord(1));
        treeMap.put(pntPair, null);
    }

    Roi getRoi(DelaunayTriangulation delaunayTriangulation, double d) {
        if (delaunayTriangulation == null) {
            return null;
        }
        if (this.mode != 1) {
            IJ.error((String)"Operation only supported for Delaunay");
            return null;
        }
        int n = 0;
        GeneralPath generalPath = new GeneralPath(0);
        Polygon polygon = null;
        Iterator iterator = delaunayTriangulation.iterator();
        while (iterator.hasNext()) {
            Simplex simplex = (Simplex)iterator.next();
            if (this.mode == 1) {
                Iterator iterator2 = simplex.iterator();
                Pnt pnt = (Pnt)iterator2.next();
                Pnt pnt2 = (Pnt)iterator2.next();
                Pnt pnt3 = (Pnt)iterator2.next();
                if (Math.abs(pnt.coord(0)) >= d || Math.abs(pnt2.coord(0)) >= d || Math.abs(pnt3.coord(0)) >= d) continue;
                int[] nArray = new int[3];
                int[] nArray2 = new int[3];
                nArray[0] = (int)Math.round(pnt.coord(0));
                nArray2[0] = (int)Math.round(pnt.coord(1));
                nArray[1] = (int)Math.round(pnt2.coord(0));
                nArray2[1] = (int)Math.round(pnt2.coord(1));
                nArray[2] = (int)Math.round(pnt3.coord(0));
                nArray2[2] = (int)Math.round(pnt3.coord(1));
                polygon = new Polygon(nArray, nArray2, 3);
                generalPath.append(polygon, false);
                ++n;
                continue;
            }
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return new PolygonRoi(polygon, 2);
        }
        return new ShapeRoi((Shape)generalPath);
    }

    class CustomCanvas
    extends ImageCanvas
    implements KeyListener {
        DelaunayTriangulation delaunay;
        final double inf;
        double pixelWidth;
        double pixelHeight;
        double mean;
        double variance;
        int total;

        CustomCanvas(ImagePlus imagePlus) {
            super(imagePlus);
            this.inf = imagePlus.getWidth() + imagePlus.getHeight();
            this.initDelaunay();
            this.addKeyListener(this);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.drawOverlay(graphics);
        }

        void drawOverlay(Graphics graphics) {
            if (this.delaunay == null) {
                return;
            }
            Iterator iterator = this.delaunay.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2;
                Simplex simplex = (Simplex)iterator.next();
                if (Delaunay_Voronoi.this.mode == 1) {
                    iterator2 = simplex.iterator();
                    Pnt pnt = (Pnt)iterator2.next();
                    Pnt pnt2 = (Pnt)iterator2.next();
                    Pnt pnt3 = (Pnt)iterator2.next();
                    this.draw(graphics, pnt, pnt2);
                    this.draw(graphics, pnt, pnt3);
                    this.draw(graphics, pnt2, pnt3);
                    continue;
                }
                iterator2 = this.delaunay.neighbors(simplex).iterator();
                while (iterator2.hasNext()) {
                    this.draw(graphics, simplex, (Simplex)iterator2.next());
                }
            }
        }

        void draw(Graphics graphics, Pnt pnt, Pnt pnt2) {
            if (Delaunay_Voronoi.this.mode != 2 && (Math.abs(pnt.coord(0)) >= this.inf || Math.abs(pnt2.coord(0)) >= this.inf)) {
                return;
            }
            if (graphics == null) {
                ImageProcessor imageProcessor = this.imp.getProcessor();
                imageProcessor.drawLine((int)pnt.coord(0), (int)pnt.coord(1), (int)pnt2.coord(0), (int)pnt2.coord(1));
                return;
            }
            double d = this.magnification;
            double d2 = (pnt.coord(0) - (double)this.srcRect.x) * d;
            double d3 = (pnt.coord(1) - (double)this.srcRect.y) * d;
            double d4 = (pnt2.coord(0) - (double)this.srcRect.x) * d;
            double d5 = (pnt2.coord(1) - (double)this.srcRect.y) * d;
            this.imp.getRoi();
            graphics.setColor(Roi.getColor());
            graphics.drawLine((int)d2, (int)d3, (int)d4, (int)d5);
            if (Delaunay_Voronoi.this.drawZoom && this.srcRect.width != this.imageWidth && graphics != null) {
                int n = 10;
                int n2 = 10;
                int n3 = 64;
                int n4 = 64;
                if (this.imageHeight > this.imageWidth) {
                    d = 64.0 / (double)this.imageHeight;
                    n3 = (int)((double)this.imageWidth * d);
                } else {
                    d = 64.0 / (double)this.imageWidth;
                    n4 = (int)((double)this.imageHeight * d);
                }
                d2 = pnt.coord(0) * d + (double)n;
                d3 = pnt.coord(1) * d + (double)n2;
                d4 = pnt2.coord(0) * d + (double)n;
                d5 = pnt2.coord(1) * d + (double)n2;
                Shape shape = graphics.getClip();
                graphics.setColor(new Color(128, 128, 255));
                graphics.clipRect(n, n2, n3, n4);
                graphics.drawLine((int)d2, (int)d3, (int)d4, (int)d5);
                graphics.setClip(shape);
            }
        }

        void draw(Graphics graphics, Simplex simplex, Simplex simplex2) {
            this.draw(graphics, Pnt.circumcenter(simplex.toArray(new Pnt[0])), Pnt.circumcenter(simplex2.toArray(new Pnt[0])));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            this.initDelaunay();
            this.repaint();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32) {
                Delaunay_Voronoi.this.mode = Delaunay_Voronoi.this.mode == 1 ? 2 : 1;
                this.repaint();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void initDelaunay() {
            this.delaunay = null;
            Roi roi = this.imp.getRoi();
            if (roi == null || !(roi instanceof PointRoi)) {
                return;
            }
            PointRoi pointRoi = (PointRoi)roi;
            Rectangle rectangle = pointRoi.getBounds();
            int n = pointRoi.getNCoordinates();
            int[] nArray = pointRoi.getXCoordinates();
            int[] nArray2 = pointRoi.getYCoordinates();
            Simplex simplex = new Simplex(new Pnt[]{new Pnt(-this.inf, -this.inf), new Pnt(-this.inf, 5.0 * this.inf), new Pnt(5.0 * this.inf, -this.inf)});
            this.delaunay = new DelaunayTriangulation(simplex);
            for (int i = 0; i < n; ++i) {
                this.delaunay.delaunayPlace(new Pnt(nArray[i] + rectangle.x, nArray2[i] + rectangle.y));
            }
            if (Delaunay_Voronoi.this.showMeanDistance && Delaunay_Voronoi.this.mode == 1) {
                this.showMeanAndVariance();
            }
        }

        private void addToMean(Pnt pnt, Pnt pnt2) {
            if (Math.abs(pnt.coord(0)) >= this.inf || Math.abs(pnt2.coord(0)) >= this.inf) {
                return;
            }
            double d = (pnt2.coord(0) - pnt.coord(0)) * this.pixelWidth;
            double d2 = (pnt2.coord(1) - pnt.coord(1)) * this.pixelHeight;
            double d3 = d * d + d2 * d2;
            this.mean += Math.sqrt(d3);
            this.variance += d3;
            ++this.total;
        }

        public void showMeanAndVariance() {
            Calibration calibration = this.imp.getCalibration();
            this.pixelWidth = calibration.pixelWidth;
            this.pixelHeight = calibration.pixelHeight;
            this.total = 0;
            this.mean = this.variance = (double)0;
            Iterator iterator = this.delaunay.iterator();
            while (iterator.hasNext()) {
                Simplex simplex = (Simplex)iterator.next();
                Iterator iterator2 = simplex.iterator();
                Pnt pnt = (Pnt)iterator2.next();
                Pnt pnt2 = (Pnt)iterator2.next();
                Pnt pnt3 = (Pnt)iterator2.next();
                this.addToMean(pnt, pnt2);
                this.addToMean(pnt2, pnt3);
                this.addToMean(pnt3, pnt);
            }
            if (this.total > 0) {
                this.mean /= (double)this.total;
                this.variance /= (double)this.total;
                this.variance -= this.mean * this.mean;
                IJ.write((String)("mean distance: " + this.mean + ", variance: " + this.variance));
            }
        }
    }

    private static class PntPair
    implements Comparable {
        Pnt a;
        Pnt b;

        PntPair(Pnt pnt, Pnt pnt2) {
            if (PntPair.compare(pnt, pnt2) > 0) {
                this.a = pnt2;
                this.b = pnt;
            } else {
                this.a = pnt;
                this.b = pnt2;
            }
        }

        public int compareTo(Object object) {
            PntPair pntPair = (PntPair)object;
            int n = PntPair.compare(this.a, pntPair.a);
            if (n == 0) {
                n = PntPair.compare(this.b, pntPair.b);
            }
            return n;
        }

        public static int compare(Pnt pnt, Pnt pnt2) {
            double d = pnt.coord(0) - pnt2.coord(0);
            if (d == 0.0) {
                d = pnt.coord(1) - pnt2.coord(1);
            }
            return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
        }
    }
}

