/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Despeckle_
implements PlugInFilter {
    public static String ACCURATE = "Accurate";
    public static String FAST = "Fast";
    private ImagePlus image;
    private byte[] currentSlide;
    private int w;
    private int h;
    private int k_diameter;
    private String mode = ACCURATE;
    private int FG = 0;
    private int BG = 255;

    public void run(ImageProcessor imageProcessor) {
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        GenericDialog genericDialog = new GenericDialog("Despeckle");
        genericDialog.addNumericField("Radius of largest particles to remove", 5.0, 0);
        genericDialog.addNumericField("Foreground color", 0.0, 0);
        genericDialog.addNumericField("Background color", 255.0, 0);
        genericDialog.addChoice("Mode", new String[]{ACCURATE, FAST}, FAST);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.k_diameter = (int)genericDialog.getNextNumber() + 2;
        this.FG = (int)genericDialog.getNextNumber();
        this.BG = (int)genericDialog.getNextNumber();
        if (this.FG < 0 || this.FG > 255 || this.BG < 0 || this.BG > 255) {
            IJ.showMessage((String)"Wrong color range");
        }
        this.despeckle();
        this.image.updateAndDraw();
    }

    public void despeckle() {
        for (int i = 0; i < this.image.getStackSize(); ++i) {
            this.currentSlide = (byte[])this.image.getStack().getProcessor(i + 1).getPixels();
            this.despeckleSlide();
        }
    }

    private void despeckleSlide() {
        for (int i = -1; i < this.h - this.k_diameter + 1; ++i) {
            for (int j = -1; j < this.w - this.k_diameter + 1; ++j) {
                this.handlePosition(j, i);
            }
        }
    }

    private void handlePosition(int n, int n2) {
        if (this.isIsland(n, n2)) {
            this.removeIsland(n, n2);
        }
    }

    private boolean isIsland(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.k_diameter; ++n3) {
            if (this.get(n + n3, n2) != (byte)this.FG && this.get(n + n3, n2 + this.k_diameter) != (byte)this.FG) continue;
            return false;
        }
        for (n3 = 1; n3 < this.k_diameter - 1; ++n3) {
            if (this.get(n, n2 + n3) != (byte)this.FG && this.get(n + this.k_diameter, n2 + n3) != (byte)this.FG) continue;
            return false;
        }
        return true;
    }

    private void removeIsland(int n, int n2) {
        for (int i = 1; i < this.k_diameter - 1; ++i) {
            int n3 = n2 + i;
            for (int j = 1; j < this.k_diameter - 1; ++j) {
                int n4 = n + j;
                this.currentSlide[n3 * this.w + n4] = (byte)this.BG;
            }
        }
    }

    private byte get(int n, int n2) {
        return n < this.w && n >= 0 && n2 >= 0 && n2 < this.h ? this.currentSlide[n2 * this.w + n] : (byte)this.BG;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }
}

