/*
 * Decompiled with CFR 0.152.
 */
class FFT {
    FFT() {
    }

    public static double[][] fft(double[][] dArray) {
        int n = dArray.length;
        if (n == 1) {
            return new double[][]{dArray[0]};
        }
        if ((n & 1) != 0) {
            throw new RuntimeException("n is not a power of 2");
        }
        double[][] dArrayArray = new double[n / 2][];
        for (int i = 0; i < n / 2; ++i) {
            dArrayArray[i] = dArray[2 * i];
        }
        double[][] dArray2 = FFT.fft(dArrayArray);
        double[][] dArrayArray2 = dArrayArray;
        for (int i = 0; i < n / 2; ++i) {
            dArrayArray2[i] = dArray[2 * i + 1];
        }
        double[][] dArray3 = FFT.fft(dArrayArray2);
        double[][] dArray4 = new double[n][2];
        for (int i = 0; i < n / 2; ++i) {
            double d = (double)(-2 * i) * Math.PI / (double)n;
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = d2 * dArray3[i][0] - d3 * dArray3[i][1];
            double d5 = d2 * dArray3[i][1] + d3 * dArray3[i][0];
            dArray4[i][0] = dArray2[i][0] + d4;
            dArray4[i][1] = dArray2[i][1] + d5;
            dArray4[i + n / 2][0] = dArray2[i][0] - d4;
            dArray4[i + n / 2][1] = dArray2[i][1] - d5;
        }
        return dArray4;
    }

    public static double[][] conjugate(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = dArray[i][0];
            dArray2[i][1] = -dArray[i][1];
        }
        return dArray2;
    }

    public static double[][] divide(double[][] dArray, double d) {
        double[][] dArray2 = new double[dArray.length][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = dArray[i][0] / d;
            dArray2[i][1] = dArray[i][1] / d;
        }
        return dArray2;
    }

    public static double[][] ifft(double[][] dArray) {
        return FFT.divide(FFT.conjugate(FFT.fft(FFT.conjugate(dArray))), dArray.length);
    }

    public static void print(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(" " + dArray[i][0] + ";" + dArray[i][1]);
        }
        System.out.println("");
    }

    public static double[][] multiply(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[dArray.length][2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i][0] = dArray[i][0] * dArray2[i][0] - dArray[i][1] * dArray2[i][1];
            dArray3[i][1] = dArray[i][1] * dArray2[i][0] + dArray[i][0] * dArray2[i][1];
        }
        return dArray3;
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{{1.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}, {0.0, 1.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        double[][] dArrayArray2 = new double[][]{{0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 1.0}, {5.0, 6.0}, {3.0, 4.0}, {1.0, 2.0}};
        double[][] dArrayArray3 = new double[][]{{1.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}, {0.0, 0.0}};
        double[][] dArray = FFT.fft(dArrayArray);
        double[][] dArray2 = FFT.fft(dArrayArray2);
        double[][] dArray3 = FFT.ifft(dArray);
        double[][] dArray4 = FFT.multiply(dArray, dArray2);
        double[][] dArray5 = FFT.ifft(dArray4);
        FFT.print(dArrayArray);
        FFT.print(dArray);
        FFT.print(dArray3);
        FFT.print(dArray2);
        FFT.print(dArray4);
        FFT.print(dArray5);
    }
}

