/*
 * Decompiled with CFR 0.152.
 */
public class FibonacciHeapInt {
    private Node root = new Node(0, null, null);
    private Node min;
    int count;

    public void add(int n, Object object) {
        Node node = new Node(n, object, this.root);
        if (this.min == null || this.min.key - n > 0) {
            this.min = node;
        }
        this.root.insertChild(node);
        ++this.count;
    }

    public Object pop() {
        if (this.min == null) {
            return null;
        }
        Node node = this.min.firstChild;
        while (node != null) {
            Node node2 = node.next;
            node.previous = null;
            node.next = null;
            node.parent = null;
            this.root.firstChild.insert(node);
            node = node2;
        }
        node = this.min;
        if (this.root.firstChild == this.min) {
            this.root.firstChild = this.min.next;
            if (this.min.next != null) {
                this.min.next.previous = null;
            }
        } else {
            if (this.min.next != null) {
                this.min.next.previous = this.min.previous;
            }
            if (this.min.previous != null) {
                this.min.previous.next = this.min.next;
            }
        }
        if (this.root.firstChild != null) {
            this.consolidate();
        } else {
            this.min = null;
        }
        --this.count;
        return node.object;
    }

    public boolean hasMore() {
        return this.root.firstChild != null;
    }

    public int compareTo(int n) {
        return this.min == null ? 1 : this.min.key - n;
    }

    private final Node link(Node node, Node node2) {
        if (node.key - node2.key > 0) {
            return this.link(node2, node);
        }
        node2.extract();
        node2.parent = node;
        node.insertChild(node2);
        return node;
    }

    private final void insert(Node[] nodeArray, Node node) {
        if (nodeArray[node.degree] == null) {
            nodeArray[node.degree] = node;
        } else {
            int n = node.degree;
            node = this.link(node, nodeArray[n]);
            nodeArray[n] = null;
            this.insert(nodeArray, node);
        }
    }

    private final void consolidate() {
        int n = 1;
        for (int i = 1; i <= this.count; i *= 2) {
            ++n;
        }
        Node[] nodeArray = new Node[n];
        Node node = this.root.firstChild;
        while (node != null) {
            Node node2 = node.next;
            node.extract();
            node.parent = this.root;
            this.insert(nodeArray, node);
            node = node2;
        }
        node = null;
        this.root.firstChild = null;
        for (int i = 0; i < n; ++i) {
            if (nodeArray[i] == null) continue;
            if (node == null) {
                node = this.root.firstChild = nodeArray[i];
                node.next = null;
                node.previous = null;
                this.min = node;
                continue;
            }
            node.next = nodeArray[i];
            nodeArray[i].previous = node;
            node = nodeArray[i];
            node.next = null;
            if (this.min.key - node.key <= 0) continue;
            this.min = node;
        }
    }

    public static void main(String[] stringArray) {
        int n;
        FibonacciHeapInt fibonacciHeapInt = new FibonacciHeapInt();
        double[] dArray = new double[]{9.0, -5.0, Math.PI, 132.0, 15.223, 900000.0, 1997.0, 0.001, 0.0012, 0.0};
        for (n = 0; n < dArray.length; ++n) {
            Double d = new Double(dArray[n]);
            fibonacciHeapInt.add((int)dArray[n], new Double((int)dArray[n]));
        }
        n = 0;
        while (fibonacciHeapInt.hasMore()) {
            System.out.println("Extract " + ++n + ": " + (Double)fibonacciHeapInt.pop());
        }
    }

    private static class Node {
        int key;
        Object object;
        Node next;
        Node previous;
        Node parent;
        Node firstChild;
        int degree;
        boolean marked;

        public Node(int n, Object object, Node node) {
            this.key = n;
            this.object = object;
            this.parent = node;
        }

        void insert(Node node) {
            if (node.next != null || node.previous != null || node.parent != null && node.parent != this.parent || this.previous != null) {
                throw new RuntimeException("node not new: " + node.next + ", " + node.previous + ", " + node.parent + ", " + this.previous);
            }
            node.next = this;
            this.previous = node;
            node.parent = this.parent;
            this.parent.firstChild = node;
        }

        void insertChild(Node node) {
            if (this.firstChild == null) {
                this.firstChild = node;
                this.degree = node.degree + 1;
            } else {
                this.firstChild.insert(node);
                if (node.degree + 1 > this.degree) {
                    this.degree = node.degree + 1;
                }
            }
        }

        final void extract() {
            if (this.parent != null && this.parent.firstChild == this) {
                this.parent.firstChild = this.next;
            }
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            this.parent = null;
            this.next = null;
            this.previous = null;
        }

        public void print(String string) {
            this.print(string, "");
        }

        public void print(String string, String string2) {
            System.out.println(string2 + string + ": " + this.key + ", " + this.object);
            int n = 1;
            Node node = this.firstChild;
            while (node != null) {
                node.print(string + ":" + n++, string2 + "    ");
                node = node.next;
            }
        }
    }
}

