/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class FindIt_
implements PlugInFilter {
    ImagePlus imp;
    int width;
    int height;
    int fuzz;
    int minOffset;
    int maxOffset;
    int samplingFactor;
    int samplingBorder;
    int[] pixels;
    boolean debug;
    int offset;
    int top;
    int left;
    int right;
    int bottom;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 31;
    }

    boolean matches(int n, int n2, int n3, int n4) {
        int n5 = 3;
        int n6 = this.pixels[n + this.width * n2];
        int n7 = this.pixels[n3 + this.width * n4];
        for (int i = 0; i < n5 * 8; i += 8) {
            if (Math.abs((n6 >> i & 0xFF) - (n7 >> i & 0xFF)) <= this.fuzz) continue;
            return false;
        }
        return true;
    }

    double find_offset(int n, int n2, int n3) {
        int[] nArray = new int[n2 + 1 - n];
        int n4 = 0;
        int n5 = 0;
        for (int i = n; i <= n2; ++i) {
            for (int j = n3 / 2; j < this.width - i; j += n3) {
                for (int k = n3 / 2; k < this.height; k += n3) {
                    if (!this.matches(j, k, j + i, k) || this.matches(j, k, j + this.samplingBorder, k)) continue;
                    int n6 = i - n;
                    nArray[n6] = nArray[n6] + 1;
                }
            }
            n4 += nArray[i - n];
            if (nArray[n5] >= nArray[i - n]) continue;
            n5 = i - n;
        }
        this.offset = n + n5;
        return (double)nArray[n5] / (double)n4;
    }

    boolean find_top_left_corner(int n, int n2) {
        int n3 = 5;
        for (int i = 0; i < this.width - this.offset; ++i) {
            for (int j = 0; j < this.height - n2; ++j) {
                int n4;
                int n5 = 0;
                for (n4 = 0; n4 < n2 && this.matches(i, j + n4, i + this.offset, j + n4) && (this.matches(i + n, j + n4, i + n + this.offset, j + n4) || ++n5 < n3); ++n4) {
                    n5 = 0;
                }
                if (n4 >= n2) {
                    this.top = j;
                    this.left = i;
                    return true;
                }
                j += n4;
            }
        }
        return false;
    }

    boolean find_rectangle(int n, int n2) {
        int n3;
        if (!this.find_top_left_corner(n, n2)) {
            return false;
        }
        int n4 = 2;
        int n5 = 3;
        if (this.debug) {
            IJ.write((String)("found (" + this.left + "," + this.top + ")"));
        }
        this.right = this.left + n;
        int n6 = 0;
        while (this.right < this.left + this.offset - 2 * n4 && (this.matches(this.right, this.top + n4, this.right + this.bottom, this.top + n4) && this.matches(this.right, this.top + 2 * n4, this.right + this.bottom, this.top + 2 * n4) || ++n6 < n5)) {
            ++this.right;
            n6 = 0;
        }
        if (this.debug) {
            IJ.write((String)("found right: " + this.right));
        }
        if (this.right == this.left + n) {
            return false;
        }
        this.bottom = this.top + n2 + n4;
        n6 = 0;
        while (this.bottom < this.height && n6 < (this.right - this.left) / 2) {
            n6 = 0;
            for (n3 = this.left; n3 < this.right; ++n3) {
                if (this.matches(n3, this.bottom, n3 + this.offset, this.bottom)) continue;
                ++n6;
            }
            ++this.bottom;
        }
        if (this.debug) {
            IJ.write((String)("found bottom: " + this.bottom));
        }
        --this.top;
        n6 = 0;
        while (this.top > 0 && n6 < (this.right - this.left) / 2) {
            n6 = 0;
            for (n3 = this.left; n3 < this.right; ++n3) {
                if (this.matches(n3, this.top, n3 + this.offset, this.top)) continue;
                ++n6;
            }
            --this.top;
        }
        ++this.top;
        if (this.debug) {
            IJ.write((String)("found new top: " + this.top));
        }
        return true;
    }

    void add_slices(ImageStack imageStack) {
        int n;
        int[] nArray = new int[this.pixels.length];
        int[] nArray2 = new int[this.pixels.length];
        for (n = 0; n < this.pixels.length; ++n) {
            nArray[n] = this.pixels[n];
            nArray2[n] = 0;
        }
        for (n = this.top; n < this.bottom; ++n) {
            for (int i = this.left; i < this.right; ++i) {
                int n2 = i + this.width * n;
                nArray[n2] = this.pixels[n2 + this.offset];
                nArray[n2 + this.offset] = this.pixels[n2];
                nArray2[n2] = 0;
                for (int j = 0; j < 24; j += 8) {
                    int n3 = n2;
                    nArray2[n3] = nArray2[n3] | Math.abs((nArray[n2] >> j & 0xFF) - (this.pixels[n2] >> j & 0xFF)) << j;
                }
            }
            nArray2[this.left + this.width * n] = -1;
            nArray2[this.right - 1 + this.width * n] = -1;
        }
        imageStack.addSlice("", (ImageProcessor)new ColorProcessor(this.width, this.height, this.pixels));
        imageStack.addSlice("", (ImageProcessor)new ColorProcessor(this.width, this.height, nArray));
        imageStack.addSlice("", (ImageProcessor)new ColorProcessor(this.width, this.height, nArray2));
    }

    public void run(ImageProcessor imageProcessor) {
        imageProcessor = imageProcessor.convertToRGB();
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.pixels = (int[])imageProcessor.getPixels();
        this.debug = false;
        GenericDialog genericDialog = new GenericDialog("Parameters");
        genericDialog.addNumericField("Fuzz", 25.0, 0);
        genericDialog.addNumericField("MinOffset", (double)(this.width / 7), 0);
        genericDialog.addNumericField("MaxOffset", (double)(this.width / 2), 0);
        genericDialog.addNumericField("SamplingFactor", (double)(this.width / 40), 0);
        genericDialog.addNumericField("SamplingBorder", 20.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.fuzz = (int)genericDialog.getNextNumber();
        this.minOffset = (int)genericDialog.getNextNumber();
        this.maxOffset = (int)genericDialog.getNextNumber();
        this.samplingFactor = (int)genericDialog.getNextNumber();
        this.samplingBorder = (int)genericDialog.getNextNumber();
        double d = this.find_offset(this.minOffset, this.maxOffset, this.samplingFactor);
        if (this.debug) {
            IJ.write((String)("Offset is " + this.offset + " (" + d * 100.0 + "%)"));
        }
        if (this.find_rectangle(this.offset / 2, this.offset / 2)) {
            ImageStack imageStack = new ImageStack(this.width, this.height);
            this.add_slices(imageStack);
            new ImagePlus("result", imageStack).show();
        }
    }
}

