/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class KD_Cartoon
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Despeckle");
        genericDialog.addNumericField("ratio color/space", 256.0 / (double)(imageProcessor.getWidth() * imageProcessor.getHeight()), 3);
        genericDialog.addNumericField("number of classes", 20.0, 0);
        genericDialog.addNumericField("iterations (at most)", 50.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d = genericDialog.getNextNumber();
        int n = (int)genericDialog.getNextNumber();
        int n2 = (int)genericDialog.getNextNumber();
        KD kD = new KD(imageProcessor, d, n, n2);
        ImageProcessor imageProcessor2 = kD.getResult();
        new ImagePlus("KD Cartoon of " + this.image.getTitle(), imageProcessor2).show();
    }

    private static class KD {
        ImageProcessor ip;
        boolean isColor;
        double ratio;
        int w;
        int h;
        int n;
        int iterations;
        int[] c;
        Difference[] diff;

        public KD(ImageProcessor imageProcessor, double d, int n, int n2) {
            this.ip = imageProcessor;
            this.isColor = imageProcessor.isColorLut() || imageProcessor instanceof ColorProcessor;
            this.ratio = d;
            this.w = imageProcessor.getWidth();
            this.h = imageProcessor.getHeight();
            this.c = new int[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                this.c[i] = (int)(Math.random() * (double)n);
            }
            this.n = n;
            this.iterations = n2;
        }

        public int iterate() {
            int n;
            int n2;
            this.diff = new Difference[this.n];
            for (n2 = 0; n2 < this.n; ++n2) {
                this.diff[n2] = this.isColor ? new ColorDifference(this.ip, this.ratio) : new GrayDifference(this.ip, this.ratio);
                this.diff[n2].init();
            }
            for (n2 = 0; n2 < this.h; ++n2) {
                for (n = 0; n < this.w; ++n) {
                    this.diff[this.c[n + this.w * n2]].add(n, n2);
                }
            }
            for (n2 = 0; n2 < this.n; ++n2) {
                this.diff[n2].finish();
            }
            n2 = 0;
            for (n = 0; n < this.h; ++n) {
                for (int i = 0; i < this.w; ++i) {
                    int n3 = 0;
                    double d = this.diff[0].getDiff(i, n);
                    for (int j = 1; j < this.n; ++j) {
                        double d2 = this.diff[j].getDiff(i, n);
                        if (!(d > d2)) continue;
                        n3 = j;
                        d = d2;
                    }
                    if (this.c[i + this.w * n] == n3) continue;
                    ++n2;
                    this.c[i + this.w * n] = n3;
                }
            }
            return n2;
        }

        public ImageProcessor getResult() {
            for (int i = 0; i < this.iterations; ++i) {
                int n = this.iterate();
                IJ.showStatus((String)("adjusted pixels: " + n + " (" + (i + 1) + "/" + this.iterations + ")"));
                if (n == 0) break;
            }
            return this.getImage();
        }

        private ImageProcessor getImage() {
            if (this.isColor) {
                int[] nArray = new int[this.n];
                for (int i = 0; i < this.n; ++i) {
                    nArray[i] = ((ColorDifference)this.diff[i]).getMean();
                }
                int[] nArray2 = new int[this.w * this.h];
                for (int i = 0; i < this.w * this.h; ++i) {
                    nArray2[i] = nArray[this.c[i]];
                }
                return new ColorProcessor(this.w, this.h, nArray2);
            }
            float[] fArray = new float[this.n];
            for (int i = 0; i < this.n; ++i) {
                fArray[i] = ((GrayDifference)this.diff[i]).getMean();
            }
            float[] fArray2 = new float[this.w * this.h];
            for (int i = 0; i < this.w * this.h; ++i) {
                fArray2[i] = fArray[this.c[i]];
            }
            return new FloatProcessor(this.w, this.h, fArray2, null);
        }
    }

    private static class GrayDifference
    extends Difference {
        float mean;

        public GrayDifference(ImageProcessor imageProcessor, double d) {
            super(imageProcessor, d);
        }

        public void init() {
            this.mean = 0.0f;
            super.init();
        }

        public void add(int n, int n2) {
            this.mean += this.ip.getf(n, n2);
            super.add(n, n2);
        }

        public void finish() {
            if (this.count < 1) {
                return;
            }
            this.mean /= (float)this.count;
            super.finish();
        }

        public double getDiff(int n, int n2) {
            float f = this.mean - this.ip.getf(n, n2);
            return super.getDiff(n, n2) + (double)(f * f);
        }

        public float getMean() {
            return this.mean;
        }
    }

    private static class ColorDifference
    extends Difference {
        double r;
        double g;
        double b;
        double r2;
        double g2;
        double b2;

        public ColorDifference(ImageProcessor imageProcessor, double d) {
            super(imageProcessor, d);
        }

        private void decompose(int n) {
            this.r = n >> 16 & 0xFF;
            this.g = n >> 8 & 0xFF;
            this.b = n & 0xFF;
        }

        public void init() {
            this.b2 = 0.0;
            this.g2 = 0.0;
            this.r2 = 0.0;
            super.init();
        }

        public void add(int n, int n2) {
            int n3 = this.ip.get(n, n2);
            this.decompose(n3);
            this.r2 += this.r;
            this.g2 += this.g;
            this.b2 += this.b;
            super.add(n, n2);
        }

        public void finish() {
            if (this.count < 1) {
                return;
            }
            this.r2 /= (double)this.count;
            this.g2 /= (double)this.count;
            this.b2 /= (double)this.count;
            super.finish();
        }

        public double getDiff(int n, int n2) {
            int n3 = this.ip.get(n, n2);
            this.decompose(n3);
            this.r -= this.r2;
            this.g -= this.g2;
            this.b -= this.b2;
            double d = (double)n - this.x2;
            double d2 = (double)n2 - this.y2;
            return super.getDiff(n, n2) + this.r * this.r + this.g * this.g + this.b * this.b;
        }

        public int getMean() {
            return (int)this.r2 << 16 | (int)this.g2 << 8 | (int)this.b2;
        }
    }

    private static class Difference {
        ImageProcessor ip;
        double ratio;
        int count;
        double x2;
        double y2;

        public Difference(ImageProcessor imageProcessor, double d) {
            this.ip = imageProcessor;
            this.ratio = d;
        }

        public void init() {
            this.y2 = 0.0;
            this.x2 = 0.0;
            this.count = 0;
        }

        public void add(int n, int n2) {
            this.x2 += (double)n;
            this.y2 += (double)n2;
            ++this.count;
        }

        public void finish() {
            this.x2 /= (double)this.count;
            this.y2 /= (double)this.count;
        }

        public double getDiff(int n, int n2) {
            double d = (double)n - this.x2;
            double d2 = (double)n2 - this.y2;
            return this.ratio * (d * d + d2 * d2);
        }
    }
}

