/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Lasso_
implements PlugIn {
    private Difference difference;
    private double[] dijkstra;
    private int[] previous;
    private int w;
    private int h;
    private Roi originalRoi;
    private double ratioSpaceColor = 1.0;
    public static final String MACRO_CMD = "var clicked = 0;\nvar spacePressed = 0;\nvar leftClick = 16;\nvar currentX = -1;\nvar currentY = -1;\n\nmacro 'Lasso Tool - C000Pdaa79796a6c4c2a1613215276998a6a70' {\n  tool = toolID();\n  while (tool == toolID()) {\n    if (!spacePressed) {\n        if (isKeyDown('space'))\n            spacePressed = 1;\n    } else {\n        if (!isKeyDown('space')) {\n            spacePressed = 0;\n            call('Lasso_.toggleMode');\n        }\n    }\n    getCursorLoc(x, y, z, flags);\n    if (!clicked) {\n        if ((flags & leftClick) != 0) {\n            clicked = 1;\n            call('Lasso_.start', x, y);\n        }\n    } else {\n        if ((flags & leftClick) == 0)\n            clicked = 0;\n        else if (x != currentX || y != currentY) {\n            call('Lasso_.move', x, y);\n            currentX = x;\n            currentY = y;\n        }\n    }\n    wait(100);\n  }\n}\n\nmacro 'Lasso Tool Options' {\n    call('Lasso_.callOptionDialog');\n}\n";
    protected boolean macroInstalled = false;
    private static Lasso_ instance;
    private static final int BLOW = 0;
    private static final int LASSO = 1;
    private static final int MIN_LASSO = 2;
    private static final int MAX_TOOL = 2;
    private static final String[] modeTitles;
    private int mode = 0;
    static final int[] stepX;
    static final int[] stepY;
    static final int[] stepW;
    FibonacciHeapDouble queue;
    int startX;
    int startY;

    public void run(String string) {
        if (IJ.versionLessThan((String)"1.37j")) {
            return;
        }
        if (this.macroInstalled) {
            return;
        }
        MacroInstaller macroInstaller = new MacroInstaller();
        macroInstaller.install(MACRO_CMD);
        Toolbar.getInstance().setTool(10);
        this.macroInstalled = true;
    }

    public static synchronized void setMode(int n) {
        if (instance == null) {
            instance = new Lasso_();
        }
        Lasso_.instance.mode = n;
        IJ.showStatus((String)modeTitles[n]);
    }

    public static synchronized void setMode(String string) {
        if (string.equals("lasso")) {
            Lasso_.setMode(1);
        } else if (string.equals("blow")) {
            Lasso_.setMode(0);
        } else {
            IJ.error((String)("Unknown Lasso/Blow mode: " + string));
        }
    }

    public static synchronized void toggleMode() {
        int n = instance == null ? 0 : Lasso_.instance.mode;
        Lasso_.setMode((n + 1) % 3);
    }

    public static synchronized void callOptionDialog() {
        if (instance == null) {
            instance = new Lasso_();
        }
        instance.optionDialog();
    }

    public void optionDialog() {
        GenericDialog genericDialog = new GenericDialog("Lasso Tool Options");
        genericDialog.addChoice("mode", modeTitles, modeTitles[this.mode]);
        genericDialog.addNumericField("ratio space/color", this.ratioSpaceColor, 2);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.mode = genericDialog.getNextChoiceIndex();
        this.ratioSpaceColor = genericDialog.getNextNumber();
    }

    public static synchronized void start(String string, String string2) {
        if (instance == null) {
            instance = new Lasso_();
        }
        int n = (int)Float.parseFloat(string);
        int n2 = (int)Float.parseFloat(string2);
        instance.initDijkstra(n, n2);
    }

    public static synchronized void move(String string, String string2) {
        int n = (int)Float.parseFloat(string);
        int n2 = (int)Float.parseFloat(string2);
        if (n < 0) {
            n = 0;
        }
        if (n >= Lasso_.instance.w) {
            n = Lasso_.instance.w - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= Lasso_.instance.h) {
            n2 = Lasso_.instance.h - 1;
        }
        try {
            if (Lasso_.instance.mode == 0) {
                instance.moveBlow(n, n2);
            } else {
                instance.moveLasso(n, n2);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Caught throwable " + throwable);
            throwable.printStackTrace();
        }
    }

    private void moveLasso(int n, int n2) {
        int n3;
        this.getDijkstra(n, n2);
        int[] nArray = new int[this.w * this.h];
        int[] nArray2 = new int[this.w * this.h];
        for (n3 = 0; n3 < this.w * this.h; ++n3) {
            nArray[n3] = n;
            nArray2[n3] = n2;
            int n4 = this.previous[n + this.w * n2];
            n = n4 % this.w;
            n2 = n4 / this.w;
            if (n != this.startX || n2 != this.startY) continue;
        }
        PolygonRoi polygonRoi = new PolygonRoi(nArray, nArray2, n3, 7);
        if (this.originalRoi != null) {
            polygonRoi = new ShapeRoi(this.originalRoi).or(new ShapeRoi((Roi)polygonRoi));
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        imagePlus.setRoi((Roi)polygonRoi);
        imagePlus.updateAndDraw();
    }

    private void moveBlow(int n, int n2) {
        this.getDijkstra(n, n2);
        FloatProcessor floatProcessor = new FloatProcessor(this.w, this.h, this.dijkstra);
        floatProcessor.setThreshold(Double.MIN_VALUE, this.dijkstra[n + this.w * n2] + 1.0, 2);
        ImagePlus imagePlus = new ImagePlus("blow", (ImageProcessor)floatProcessor);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus);
        thresholdToSelection.run((ImageProcessor)floatProcessor);
        Roi roi = imagePlus.getRoi();
        if (this.originalRoi != null) {
            roi = new ShapeRoi(this.originalRoi).or(new ShapeRoi(roi));
        }
        ImagePlus imagePlus2 = WindowManager.getCurrentImage();
        imagePlus2.setRoi(roi);
        imagePlus2.updateAndDraw();
    }

    Difference getDifference(ImageProcessor imageProcessor) {
        if (this.mode == 2) {
            if (imageProcessor instanceof ByteProcessor) {
                return new ByteMinValue((byte[])imageProcessor.getPixels());
            }
            if (imageProcessor instanceof ColorProcessor) {
                return new ColorMinValue((int[])imageProcessor.getPixels());
            }
            return new MinValue(imageProcessor);
        }
        if (imageProcessor instanceof ByteProcessor) {
            return new ByteDifference((byte[])imageProcessor.getPixels());
        }
        if (imageProcessor instanceof ColorProcessor) {
            return new ColorDifference((int[])imageProcessor.getPixels());
        }
        return new Difference(imageProcessor);
    }

    private void initDijkstra(int n, int n2) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        this.originalRoi = IJ.shiftKeyDown() ? imagePlus.getRoi() : null;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        this.w = imageProcessor.getWidth();
        this.h = imageProcessor.getHeight();
        this.difference = this.getDifference(imageProcessor);
        this.previous = new int[this.w * this.h];
        this.previous[n + this.w * n2] = n + this.w * n2;
        this.dijkstra = new double[this.w * this.h];
        for (int i = 0; i < this.w * this.h; ++i) {
            this.dijkstra[i] = Double.MAX_VALUE;
        }
        this.queue = new FibonacciHeapDouble();
        this.queue.add(0.0, new PixelCost(n, n2, 0.0));
        this.startX = n;
        this.startY = n2;
    }

    private void getDijkstra(int n, int n2) {
        PixelCost pixelCost;
        while (this.queue.compareTo(this.dijkstra[n + this.w * n2]) < 0.0 && (pixelCost = (PixelCost)this.queue.pop()) != null) {
            int n3 = pixelCost.x;
            int n4 = pixelCost.y;
            double d = pixelCost.cost;
            if (this.dijkstra[n3 + this.w * n4] <= d) continue;
            this.dijkstra[n3 + this.w * n4] = d;
            for (int i = 0; i < stepW.length; ++i) {
                double d2;
                int n5 = n3 + stepX[i];
                int n6 = n4 + stepY[i];
                if (n5 < 0 || n6 < 0 || n5 >= this.w || n6 >= this.h || !(this.dijkstra[n5 + this.w * n6] > (d2 = d + (double)stepW[i] + this.ratioSpaceColor * this.difference.difference(n3, n4, n5, n6)))) continue;
                this.queue.add(d2, new PixelCost(n5, n6, d2));
                this.previous[n5 + this.w * n6] = n3 + this.w * n4;
            }
        }
    }

    static {
        modeTitles = new String[]{"Blow tool", "Lasso tool", "Lasso minimum tool"};
        stepX = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
        stepY = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};
        stepW = new int[]{4, 3, 4, 3, 4, 3, 4, 3};
    }

    private class PixelCost {
        int x;
        int y;
        double cost;

        public PixelCost(int n, int n2, double d) {
            this.x = n;
            this.y = n2;
            this.cost = d;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ": " + this.cost + ")";
        }
    }

    private class ColorMinValue
    extends Difference {
        int[] pixels;

        ColorMinValue(int[] nArray) {
            super(null);
            this.pixels = nArray;
        }

        final double difference(int n, int n2, int n3, int n4) {
            int n5 = this.pixels[n3 + Lasso_.this.w * n4];
            int n6 = n5 >> 16 & 0xFF;
            int n7 = n5 >> 8 & 0xFF;
            int n8 = n5 & 0xFF;
            return n6 + n7 + n8;
        }
    }

    private class ByteMinValue
    extends Difference {
        byte[] pixels;

        ByteMinValue(byte[] byArray) {
            super(null);
            this.pixels = byArray;
        }

        final double difference(int n, int n2, int n3, int n4) {
            return this.pixels[n3 + Lasso_.this.w * n4] & 0xFF;
        }
    }

    private class MinValue
    extends Difference {
        ImageProcessor ip;

        MinValue(ImageProcessor imageProcessor) {
            super(null);
            this.ip = imageProcessor;
        }

        double difference(int n, int n2, int n3, int n4) {
            return this.ip.getPixelValue(n3, n4);
        }
    }

    private class ColorDifference
    extends Difference {
        int[] pixels;

        ColorDifference(int[] nArray) {
            super(null);
            this.pixels = nArray;
        }

        final double difference(int n, int n2, int n3, int n4) {
            int n5 = this.pixels[n + Lasso_.this.w * n2];
            int n6 = this.pixels[n3 + Lasso_.this.w * n4];
            int n7 = (n6 >> 16 & 0xFF) - (n5 >> 16 & 0xFF);
            int n8 = (n6 >> 8 & 0xFF) - (n5 >> 8 & 0xFF);
            int n9 = (n6 & 0xFF) - (n5 & 0xFF);
            return Math.abs(n7) + Math.abs(n8) + Math.abs(n9);
        }
    }

    private class ByteDifference
    extends Difference {
        byte[] pixels;

        ByteDifference(byte[] byArray) {
            super(null);
            this.pixels = byArray;
        }

        final double difference(int n, int n2, int n3, int n4) {
            return Math.abs((this.pixels[n + Lasso_.this.w * n2] & 0xFF) - (this.pixels[n3 + Lasso_.this.w * n4] & 0xFF));
        }
    }

    private class Difference {
        ImageProcessor ip;

        Difference(ImageProcessor imageProcessor) {
            this.ip = imageProcessor;
        }

        double difference(int n, int n2, int n3, int n4) {
            return Math.abs(this.ip.getPixelValue(n, n2) - this.ip.getPixelValue(n3, n4));
        }
    }
}

