/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;

public class Moving_Least_Squares
implements PlugIn {
    ImagePlus image;
    public static final int AFFINE = 0;
    public static final int SIMILARITY = 1;
    public static final int RIGID = 2;

    private void need2Images() {
        IJ.showMessage((String)"Need 2 images with a point roi in each,\nwith equal number of points in each roi.");
    }

    public void run(String string) {
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (null == nArray) {
            this.need2Images();
            return;
        }
        ArrayList<ImagePlus> arrayList = new ArrayList<ImagePlus>();
        for (int i = 0; i < nArray.length; ++i) {
            ImagePlus imagePlus = WindowManager.getImage((int)nArray[i]);
            object = imagePlus.getRoi();
            if (null == object || !(object instanceof PointRoi)) continue;
            arrayList.add(imagePlus);
        }
        if (arrayList.size() < 2) {
            this.need2Images();
            return;
        }
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        object = arrayList.iterator();
        while (object.hasNext()) {
            stringArray[n++] = ((ImagePlus)object.next()).getTitle();
        }
        object = new String[]{"Affine", "Similarity", "Rigid"};
        GenericDialog genericDialog = new GenericDialog("Align Images");
        String string2 = WindowManager.getCurrentImage().getTitle();
        genericDialog.addChoice("source image", stringArray, string2.equals(stringArray[0]) ? stringArray[1] : stringArray[0]);
        genericDialog.addChoice("target image", stringArray, string2);
        genericDialog.addChoice("method", (String[])object, (String)object[2]);
        genericDialog.addNumericField("alpha", 1.0, 3);
        genericDialog.addNumericField("gridSize", 0.0, 3);
        genericDialog.addCheckbox("forward", true);
        genericDialog.addCheckbox("merged result", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        ImagePlus imagePlus = (ImagePlus)arrayList.get(genericDialog.getNextChoiceIndex());
        ImagePlus imagePlus2 = (ImagePlus)arrayList.get(genericDialog.getNextChoiceIndex());
        Method method = Moving_Least_Squares.getMethod(genericDialog.getNextChoiceIndex());
        method.alpha = (float)genericDialog.getNextNumber();
        float f = (float)genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        PointRoi pointRoi = (PointRoi)imagePlus.getRoi();
        PointRoi pointRoi2 = (PointRoi)imagePlus2.getRoi();
        if (pointRoi.getNCoordinates() != pointRoi2.getNCoordinates()) {
            IJ.showMessage((String)"Unequal number of points!");
            return;
        }
        ImageProcessor imageProcessor = Moving_Least_Squares.process(imagePlus, pointRoi, imagePlus2, pointRoi2, method, f, bl, bl2);
        if (null != imageProcessor) {
            new ImagePlus("warped" + (bl ? " forward" : ""), imageProcessor).show();
        }
    }

    public static ImageProcessor process(ImagePlus imagePlus, PointRoi pointRoi, ImagePlus imagePlus2, PointRoi pointRoi2, Method method, float f, boolean bl, boolean bl2) {
        if (pointRoi.getNCoordinates() != pointRoi2.getNCoordinates()) {
            IJ.log((String)"Unequal number of points!");
            return null;
        }
        Interpolator interpolator = imagePlus.getType() == 4 ? new ColorInterpolator(imagePlus.getProcessor()) : new BilinearInterpolator(imagePlus.getProcessor());
        ImageProcessor imageProcessor = imagePlus2.getProcessor().duplicate();
        if (!bl2) {
            imageProcessor.setValue(0.0);
            imageProcessor.setRoi(0, 0, imageProcessor.getWidth(), imageProcessor.getHeight());
            imageProcessor.fill();
        }
        if (bl) {
            if (f < 1.0f) {
                f = 10.0f;
            }
            method.setCoordinates(pointRoi, pointRoi2);
            method.warpImageForward(interpolator, (int)f, imageProcessor);
        } else {
            method.setCoordinates(pointRoi2, pointRoi);
            int n = imageProcessor.getWidth();
            int n2 = imageProcessor.getHeight();
            method.warpImage(interpolator, n, n2, imageProcessor.getPixels());
            if (f > 0.0f) {
                method.drawGrid(n, n2, f, imageProcessor.getPixels());
            }
        }
        return imageProcessor;
    }

    public static Method getMethod(int n) {
        switch (n) {
            case 0: {
                return new Affine();
            }
            case 1: {
                return new Similarity();
            }
        }
        return new Rigid();
    }

    static class ColorInterpolator
    extends Interpolator {
        ColorProcessor cp;

        public ColorInterpolator(ImageProcessor imageProcessor) {
            super(imageProcessor);
            this.cp = (ColorProcessor)imageProcessor;
        }

        public float get(float f, float f2) {
            return this.cp.getInterpolatedRGBPixel((double)f, (double)f2);
        }
    }

    static class BilinearInterpolator
    extends Interpolator {
        public BilinearInterpolator(ImageProcessor imageProcessor) {
            super(imageProcessor);
        }

        public float get(float f, float f2) {
            int n = (int)f;
            int n2 = (int)f2;
            float f3 = f - (float)n;
            float f4 = f2 - (float)n2;
            float f5 = this.ip.getPixelValue(n, n2);
            float f6 = this.ip.getPixelValue(n + 1, n2);
            float f7 = this.ip.getPixelValue(n, n2 + 1);
            float f8 = this.ip.getPixelValue(n + 1, n2 + 1);
            return (1.0f - f3) * (1.0f - f4) * f5 + f3 * (1.0f - f4) * f6 + (1.0f - f3) * f4 * f7 + f3 * f4 * f8;
        }
    }

    static abstract class Interpolator {
        ImageProcessor ip;
        int w;
        int h;

        public Interpolator(ImageProcessor imageProcessor) {
            this.ip = imageProcessor;
            this.w = imageProcessor.getWidth();
            this.h = imageProcessor.getHeight();
        }

        public abstract float get(float var1, float var2);
    }

    static class Rigid
    extends Method {
        Rigid() {
        }

        public void calculateM(float f, float f2) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            this.m22 = 0.0f;
            this.m21 = 0.0f;
            this.m12 = 0.0f;
            this.m11 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float f5 = this.w(f, f2, this.pX[i], this.pY[i]);
                float f6 = this.pX[i] - this.pCX;
                float f7 = this.pY[i] - this.pCY;
                float f8 = this.qX[i] - this.qCX;
                float f9 = this.qY[i] - this.qCY;
                this.m11 += f5 * (f6 * f8 + f7 * f9);
                this.m12 += f5 * (f7 * f8 - f6 * f9);
            }
            float f10 = (float)Math.sqrt(this.m11 * this.m11 + this.m12 * this.m12);
            this.m11 /= f10;
            this.m12 /= f10;
            this.m21 = -this.m12;
            this.m22 = this.m11;
        }
    }

    static class Similarity
    extends Method {
        Similarity() {
        }

        public void calculateM(float f, float f2) {
            float f3 = 0.0f;
            this.m22 = 0.0f;
            this.m21 = 0.0f;
            this.m12 = 0.0f;
            this.m11 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float f4 = this.w(f, f2, this.pX[i], this.pY[i]);
                float f5 = this.pX[i] - this.pCX;
                float f6 = this.pY[i] - this.pCY;
                float f7 = this.qX[i] - this.qCX;
                float f8 = this.qY[i] - this.qCY;
                this.m11 += f4 * (f5 * f7 + f6 * f8);
                this.m12 += f4 * (f6 * f7 - f5 * f8);
                f3 += f4 * (f5 * f5 + f6 * f6);
            }
            this.m11 /= f3;
            this.m12 /= f3;
            this.m21 = -this.m12;
            this.m22 = this.m11;
        }
    }

    static class Affine
    extends Method {
        Affine() {
        }

        public void calculateM(float f, float f2) {
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float f10 = this.w(f, f2, this.pX[i], this.pY[i]);
                float f11 = this.pX[i] - this.pCX;
                float f12 = this.pY[i] - this.pCY;
                float f13 = this.qX[i] - this.qCX;
                float f14 = this.qY[i] - this.qCY;
                f9 += f10 * f11 * f11;
                f8 += f10 * f11 * f12;
                f7 += f10 * f12 * f12;
                f6 += f10 * f11 * f13;
                f5 += f10 * f11 * f14;
                f4 += f10 * f12 * f13;
                f3 += f10 * f12 * f14;
            }
            float f15 = f9 * f7 - f8 * f8;
            this.m11 = (f7 * f6 - f8 * f4) / f15;
            this.m12 = (-f8 * f6 + f9 * f4) / f15;
            this.m21 = (f7 * f5 - f8 * f3) / f15;
            this.m22 = (-f8 * f5 + f9 * f3) / f15;
        }
    }

    static abstract class Method {
        public float alpha = 1.0f;
        int n;
        float pCX;
        float pCY;
        float qCX;
        float qCY;
        float[] pX;
        float[] pY;
        float[] qX;
        float[] qY;
        float m11;
        float m12;
        float m21;
        float m22;
        float resultX;
        float resultY;

        Method() {
        }

        public void setCoordinates(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
            this.setCoordinates(nArray, nArray2, 0, 0, nArray3, nArray4, 0, 0, n);
        }

        public void setCoordinates(PointRoi pointRoi, PointRoi pointRoi2) {
            Rectangle rectangle = pointRoi.getBounds();
            Rectangle rectangle2 = pointRoi2.getBounds();
            this.setCoordinates(pointRoi.getXCoordinates(), pointRoi.getYCoordinates(), rectangle.x, rectangle.y, pointRoi2.getXCoordinates(), pointRoi2.getYCoordinates(), rectangle2.x, rectangle2.y, pointRoi.getNCoordinates());
        }

        public void setCoordinates(int[] nArray, int[] nArray2, int n, int n2, int[] nArray3, int[] nArray4, int n3, int n4, int n5) {
            this.n = n5;
            this.pX = new float[n5];
            this.pY = new float[n5];
            this.qX = new float[n5];
            this.qY = new float[n5];
            for (int i = 0; i < n5; ++i) {
                this.pX[i] = nArray[i] + n;
                this.pY[i] = nArray2[i] + n2;
                this.qX[i] = nArray3[i] + n3;
                this.qY[i] = nArray4[i] + n4;
            }
        }

        public void setCoordinates(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n) {
            this.n = n;
            this.pX = fArray;
            this.pY = fArray2;
            this.qX = fArray3;
            this.qY = fArray4;
        }

        public float w(float f, float f2, float f3, float f4) {
            if ((f -= f3) == 0.0f && (f2 -= f4) == 0.0f) {
                return 1.0E10f;
            }
            f = 1.0f / (f * f + f2 * f2);
            if (this.alpha == 1.0f) {
                return f;
            }
            return (float)Math.exp(Math.log(f) * (double)this.alpha);
        }

        public void calculateCentroids(float f, float f2) {
            this.qCY = 0.0f;
            this.qCX = 0.0f;
            this.pCY = 0.0f;
            this.pCX = 0.0f;
            float f3 = 0.0f;
            for (int i = 0; i < this.n; ++i) {
                float f4 = this.w(f, f2, this.pX[i], this.pY[i]);
                f3 += f4;
                this.pCX += f4 * this.pX[i];
                this.pCY += f4 * this.pY[i];
                this.qCX += f4 * this.qX[i];
                this.qCY += f4 * this.qY[i];
            }
            this.pCX /= f3;
            this.pCY /= f3;
            this.qCX /= f3;
            this.qCY /= f3;
        }

        public abstract void calculateM(float var1, float var2);

        public void calculate(float f, float f2) {
            this.calculateCentroids(f, f2);
            this.calculateM(f, f2);
            this.resultX = this.qCX + this.m11 * (f - this.pCX) + this.m12 * (f2 - this.pCY);
            this.resultY = this.qCY + this.m21 * (f - this.pCX) + this.m22 * (f2 - this.pCY);
        }

        public void warpImage(Interpolator interpolator, int n, int n2, Object object) {
            if (object instanceof byte[]) {
                this.warpImage(interpolator, n, n2, (byte[])object);
            } else if (object instanceof short[]) {
                this.warpImage(interpolator, n, n2, (short[])object);
            } else if (object instanceof float[]) {
                this.warpImage(interpolator, n, n2, (float[])object);
            } else if (object instanceof int[]) {
                this.warpImage(interpolator, n, n2, (int[])object);
            } else {
                IJ.error((String)"Unknown pixel type");
            }
        }

        public void warpImage(Interpolator interpolator, int n, int n2, float[] fArray) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.calculate(j, i);
                    fArray[j + n * i] = interpolator.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(i + 1), (int)n2);
            }
        }

        public void warpImage(Interpolator interpolator, int n, int n2, int[] nArray) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.calculate(j, i);
                    nArray[j + n * i] = (int)interpolator.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(i + 1), (int)n2);
            }
        }

        public void warpImage(Interpolator interpolator, int n, int n2, short[] sArray) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.calculate(j, i);
                    sArray[j + n * i] = (short)interpolator.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(i + 1), (int)n2);
            }
        }

        public void warpImage(Interpolator interpolator, int n, int n2, byte[] byArray) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.calculate(j, i);
                    byArray[j + n * i] = (byte)interpolator.get(this.resultX, this.resultY);
                }
                IJ.showProgress((int)(i + 1), (int)n2);
            }
        }

        public void drawGrid(int n, int n2, float f, Object object) {
            if (object instanceof byte[]) {
                this.drawGrid(n, n2, f, (byte[])object);
            } else if (object instanceof short[]) {
                this.drawGrid(n, n2, f, (short[])object);
            } else if (object instanceof float[]) {
                this.drawGrid(n, n2, f, (float[])object);
            } else {
                IJ.error((String)"Unknown pixel type");
            }
        }

        boolean gridCondition(int n, int n2, float f) {
            float f2 = (float)Math.floor(this.resultX / f);
            float f3 = (float)Math.floor(this.resultY / f);
            this.calculate(n, (float)n2 - 0.5f);
            float f4 = (float)Math.floor(this.resultX / f);
            float f5 = (float)Math.floor(this.resultY / f);
            this.calculate(n, (float)n2 + 0.5f);
            float f6 = (float)Math.floor(this.resultX / f);
            float f7 = (float)Math.floor(this.resultY / f);
            this.calculate((float)n + 0.5f, n2);
            float f8 = (float)Math.floor(this.resultX / f);
            float f9 = (float)Math.floor(this.resultY / f);
            return f2 != f4 || f2 != f6 || f2 != f8 || f3 != f5 || f3 != f7 || f3 != f9;
        }

        public void drawGrid(int n, int n2, float f, float[] fArray) {
            for (int i = 0; i < n2; ++i) {
                this.calculate(-0.5f, (float)i - 0.5f);
                for (int j = 0; j < n; ++j) {
                    if (!this.gridCondition(j, i, f)) continue;
                    fArray[j + n * i] = 0.0f;
                }
                IJ.showProgress((int)(i + 1), (int)n2);
            }
        }

        public void drawGrid(int n, int n2, float f, short[] sArray) {
            for (int i = 0; i < n2; ++i) {
                this.calculate(-0.5f, (float)i - 0.5f);
                for (int j = 0; j < n; ++j) {
                    if (!this.gridCondition(j, i, f)) continue;
                    sArray[j + n * i] = 0;
                }
                IJ.showProgress((int)(i + 1), (int)n2);
            }
        }

        public void drawGrid(int n, int n2, float f, byte[] byArray) {
            for (int i = 0; i < n2; ++i) {
                this.calculate(-0.5f, (float)i - 0.5f);
                for (int j = 0; j < n; ++j) {
                    if (!this.gridCondition(j, i, f)) continue;
                    byArray[j + n * i] = 0;
                }
                IJ.showProgress((int)(i + 1), (int)n2);
            }
        }

        void forwardQuadrilateral(Interpolator interpolator, float[] fArray, float[] fArray2, ImageProcessor imageProcessor, int n, int n2, float[] fArray3, float[] fArray4) {
            int n3;
            float f;
            float f2 = f = fArray4[0];
            for (n3 = 1; n3 < 4; ++n3) {
                if (f2 > fArray4[n3]) {
                    f2 = fArray4[n3];
                    continue;
                }
                if (!(f < fArray4[n3])) continue;
                f = fArray4[n3];
            }
            n3 = f2 < 0.0f ? 0 : (int)Math.floor(f2);
            int n4 = f > (float)n2 ? n2 : (int)Math.ceil(f);
            for (int i = n3; i < n4; ++i) {
                float f3;
                float f4;
                float f5;
                int n5;
                int n6;
                float f6 = n;
                float f7 = 0.0f;
                for (n6 = 0; n6 < 4; ++n6) {
                    n5 = n6 == 3 ? 0 : n6 + 1;
                    float f8 = Math.round(fArray4[n6]);
                    f5 = Math.round(fArray4[n5]);
                    f4 = Math.round(i);
                    if ((f4 - f8) * (f4 - f5) > 0.0f) continue;
                    if (f8 != f5) {
                        f3 = fArray3[n6] + ((float)i - fArray4[n6]) * (fArray3[n5] - fArray3[n6]) / (fArray4[n5] - fArray4[n6]);
                        if (f6 > f3) {
                            f6 = f3;
                        }
                        if (!(f7 < f3)) continue;
                        f7 = f3;
                        continue;
                    }
                    if (fArray3[n6] < fArray3[n5]) {
                        if (f6 > fArray3[n6]) {
                            f6 = fArray3[n6];
                        }
                        if (!(f7 < fArray3[n5])) continue;
                        f7 = fArray3[n5];
                        continue;
                    }
                    if (f6 > fArray3[n5]) {
                        f6 = fArray3[n5];
                    }
                    if (!(f7 < fArray3[n6])) continue;
                    f7 = fArray3[n6];
                }
                n6 = f6 < 0.0f ? 0 : (int)Math.floor(f6);
                n5 = f7 > (float)n ? n : (int)Math.ceil(f7);
                for (int j = n6; j < n5; ++j) {
                    float f9;
                    float f10;
                    f5 = fArray3[0] - (float)j;
                    f4 = fArray3[1] - fArray3[0];
                    f3 = fArray3[3] - fArray3[0];
                    float f11 = fArray3[2] - fArray3[3] - fArray3[1] + fArray3[0];
                    float f12 = fArray4[0] - (float)i;
                    float f13 = fArray4[1] - fArray4[0];
                    float f14 = fArray4[3] - fArray4[0];
                    float f15 = fArray4[2] - fArray4[3] - fArray4[1] + fArray4[0];
                    float f16 = f4 * f15 - f11 * f13;
                    float f17 = f4 * f14 + f5 * f15 - f11 * f12 - f3 * f13;
                    float f18 = f5 * f14 - f3 * f12;
                    float f19 = f17 * f17 - 4.0f * f16 * f18;
                    if (f16 == 0.0f || f19 < 0.0f) {
                        if (f4 == 0.0f) {
                            f10 = 0.0f;
                            f9 = -f12 / f14;
                        } else {
                            f10 = -f5 / f3;
                            f9 = 0.0f;
                        }
                    } else {
                        f10 = (-f17 + (float)Math.sqrt(f19)) / 2.0f / f16;
                        f9 = -(f5 + f4 * f10) / (f3 + f11 * f10);
                    }
                    float f20 = (1.0f - f10) * (1.0f - f9) * fArray[0] + f10 * (1.0f - f9) * fArray[1] + (1.0f - f10) * f9 * fArray[3] + f10 * f9 * fArray[2];
                    float f21 = (1.0f - f10) * (1.0f - f9) * fArray2[0] + f10 * (1.0f - f9) * fArray2[1] + (1.0f - f10) * f9 * fArray2[3] + f10 * f9 * fArray2[2];
                    float f22 = interpolator.get(f20, f21);
                    imageProcessor.setf(j, i, f22);
                }
            }
        }

        public void warpImageForward(Interpolator interpolator, int n, ImageProcessor imageProcessor) {
            boolean bl = false;
            int n2 = imageProcessor.getWidth();
            int n3 = imageProcessor.getHeight();
            if (bl) {
                imageProcessor.setValue(0.0);
            }
            for (int i = 0; i < interpolator.h; i += n) {
                for (int j = 0; j < interpolator.w; j += n) {
                    float[] fArray = new float[4];
                    float[] fArray2 = new float[4];
                    float[] fArray3 = new float[4];
                    float[] fArray4 = new float[4];
                    fArray[0] = j;
                    fArray2[0] = i;
                    fArray[1] = j + n;
                    fArray2[1] = i;
                    fArray[2] = j + n;
                    fArray2[2] = i + n;
                    fArray[3] = j;
                    fArray2[3] = i + n;
                    for (int k = 0; k < 4; ++k) {
                        this.calculate(fArray[k], fArray2[k]);
                        fArray3[k] = this.resultX;
                        fArray4[k] = this.resultY;
                    }
                    this.forwardQuadrilateral(interpolator, fArray, fArray2, imageProcessor, n2, n3, fArray3, fArray4);
                    if (!bl) continue;
                    imageProcessor.drawLine((int)fArray3[0], (int)fArray4[0], (int)fArray3[1], (int)fArray4[1]);
                    imageProcessor.drawLine((int)fArray3[1], (int)fArray4[1], (int)fArray3[2], (int)fArray4[2]);
                    imageProcessor.drawLine((int)fArray3[2], (int)fArray4[2], (int)fArray3[3], (int)fArray4[3]);
                    imageProcessor.drawLine((int)fArray3[3], (int)fArray4[3], (int)fArray3[0], (int)fArray4[0]);
                }
                IJ.showProgress((int)(i + n), (int)interpolator.h);
            }
        }
    }
}

