/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class Seam_Remover
implements PlugInFilter {
    protected ImagePlus image;
    protected int w;
    protected int h;
    protected int[] pixels;
    protected ImageEnergy energy;

    public void run(ImageProcessor imageProcessor) {
        int[] nArray;
        String[] stringArray = new String[]{"Remove one Horizontal Seam", "Remove one Vertical Seam", "Mark one Horizontal Seam", "Mark one Vertical Seam", "Resize by removing Seams"};
        GenericDialog genericDialog = new GenericDialog("Seam Remover");
        genericDialog.addChoice("mode", stringArray, stringArray[4]);
        genericDialog.addNumericField("width", (double)this.image.getWidth(), 0);
        genericDialog.addNumericField("height", (double)this.image.getHeight(), 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = genericDialog.getNextChoiceIndex();
        int n2 = (int)genericDialog.getNextNumber();
        int n3 = (int)genericDialog.getNextNumber();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.pixels = (int[])this.image.getProcessor().getPixels();
        this.energy = new ColorDerivativeEnergy(this.w, this.h, this.pixels);
        if (n == 4) {
            ImageProcessor imageProcessor2 = this.resize(this.energy, n2, n3);
            new ImagePlus("resized " + this.image.getTitle(), imageProcessor2).show();
            return;
        }
        boolean bl = n == 2 || n == 3;
        boolean bl2 = n == 1 || n == 3;
        int[] nArray2 = nArray = bl2 ? this.energy.getVerticalSeam() : this.energy.getHorizontalSeam();
        if (bl) {
            this.image.setRoi(this.energy.seam2roi(nArray, bl2));
            this.image.updateAndDraw();
        } else {
            ImageProcessor imageProcessor3 = this.energy.removeSeam(nArray, bl2).getProcessor();
            new ImagePlus("removed seam", imageProcessor3).show();
        }
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 16;
    }

    public ImageProcessor resize(ImageEnergy imageEnergy, int n, int n2) {
        if (n > imageEnergy.w || n2 > imageEnergy.h) {
            throw new RuntimeException("Cannot enlarge image");
        }
        int n3 = imageEnergy.w - n + imageEnergy.h - n2;
        int n4 = 0;
        while (n < imageEnergy.w || n2 < imageEnergy.h) {
            int[] nArray;
            if (imageEnergy.w - n < imageEnergy.h - n2) {
                nArray = imageEnergy.getHorizontalSeam();
                imageEnergy = imageEnergy.removeSeam(nArray, false);
            } else {
                nArray = imageEnergy.getVerticalSeam();
                imageEnergy = imageEnergy.removeSeam(nArray, true);
            }
            IJ.showProgress((int)(++n4), (int)n3);
        }
        return imageEnergy.getProcessor();
    }

    private class ColorDerivativeEnergy
    extends ImageEnergy {
        int[] pixels;

        public ColorDerivativeEnergy(int n, int n2, int[] nArray) {
            super(n, n2);
            this.pixels = nArray;
        }

        int getDiff(int n, int n2, int n3, int n4) {
            int n5 = this.pixels[n + n2 * this.w];
            int n6 = this.pixels[n3 + n4 * this.w];
            int n7 = (n5 >> 16 & 0xFF) - (n6 >> 16 & 0xFF);
            int n8 = (n5 >> 8 & 0xFF) - (n6 >> 8 & 0xFF);
            int n9 = (n5 & 0xFF) - (n6 & 0xFF);
            return n7 + n8 + n9;
        }

        public float get(int n, int n2) {
            return (n == 0 ? 2 * this.getDiff(n, n2, n + 1, n2) : (n == this.w - 1 ? 2 * this.getDiff(n - 1, n2, n, n2) : this.getDiff(n - 1, n2, n + 1, n2))) + (n2 == 0 ? 2 * this.getDiff(n, n2, n, n2 + 1) : (n2 == this.h - 1 ? 2 * this.getDiff(n, n2 - 1, n, n2) : this.getDiff(n, n2 - 1, n, n2 + 1)));
        }

        public ImageEnergy removeSeam(int[] nArray, boolean bl) {
            if (bl) {
                int[] nArray2 = new int[(this.w - 1) * this.h];
                for (int i = 0; i < this.h; ++i) {
                    int n;
                    for (n = 0; n < nArray[i]; ++n) {
                        nArray2[n + i * (this.w - 1)] = this.pixels[n + i * this.w];
                    }
                    for (n = nArray[i] + 1; n < this.w; ++n) {
                        nArray2[n - 1 + i * (this.w - 1)] = this.pixels[n + i * this.w];
                    }
                }
                return new ColorDerivativeEnergy(this.w - 1, this.h, nArray2);
            }
            int[] nArray3 = new int[this.w * (this.h - 1)];
            for (int i = 0; i < this.w; ++i) {
                int n;
                for (n = 0; n < nArray[i]; ++n) {
                    nArray3[i + n * this.w] = this.pixels[i + n * this.w];
                }
                for (n = nArray[i] + 1; n < this.h; ++n) {
                    nArray3[i + (n - 1) * this.w] = this.pixels[i + n * this.w];
                }
            }
            return new ColorDerivativeEnergy(this.w, this.h - 1, nArray3);
        }

        public ImageProcessor getProcessor() {
            return new ColorProcessor(this.w, this.h, this.pixels);
        }
    }

    private static class FlippedImageEnergy
    extends ImageEnergy {
        private ImageEnergy orig;

        public FlippedImageEnergy(ImageEnergy imageEnergy) {
            super(imageEnergy.h, imageEnergy.w);
            this.orig = imageEnergy;
        }

        public float get(int n, int n2) {
            return this.orig.get(n2, n);
        }

        public ImageEnergy removeSeam(int[] nArray, boolean bl) {
            return this.orig.removeSeam(nArray, !bl);
        }

        public ImageProcessor getProcessor() {
            throw new RuntimeException("Cannot flip arbitrary ImageProcessor");
        }
    }

    private static abstract class ImageEnergy {
        int w;
        int h;

        public ImageEnergy(int n, int n2) {
            this.w = n;
            this.h = n2;
        }

        public abstract float get(int var1, int var2);

        public int[] getVerticalSeam() {
            int n;
            int n2;
            int[] nArray = new int[this.w * this.h];
            float[] fArray = new float[this.w];
            float[] fArray2 = new float[this.w];
            for (n2 = 0; n2 < this.w; ++n2) {
                nArray[n2] = n2;
                fArray2[n2] = Math.abs(this.get(n2, 0));
            }
            for (n2 = 1; n2 < this.h; ++n2) {
                for (int i = 0; i < this.w; ++i) {
                    n = i + n2 * this.w;
                    fArray[i] = fArray2[i];
                    nArray[n] = i;
                    if (i > 0 && fArray[i] > fArray2[i - 1]) {
                        fArray[i] = fArray2[i - 1];
                        nArray[n] = i - 1;
                    }
                    if (i < this.w - 1 && fArray[i] > fArray2[i + 1]) {
                        fArray[i] = fArray2[i + 1];
                        nArray[n] = i + 1;
                    }
                    int n3 = i;
                    fArray[n3] = fArray[n3] + Math.abs(this.get(i, n2));
                }
                float[] fArray3 = fArray2;
                fArray2 = fArray;
                fArray = fArray3;
            }
            n2 = 0;
            for (int i = 1; i < this.w; ++i) {
                if (!(fArray2[i] < fArray2[n2])) continue;
                n2 = i;
            }
            int[] nArray2 = new int[this.h];
            n = n2;
            for (int i = this.h - 1; i >= 0; --i) {
                nArray2[i] = n;
                n = nArray[n + i * this.w];
            }
            return nArray2;
        }

        public int[] getHorizontalSeam() {
            return new FlippedImageEnergy(this).getVerticalSeam();
        }

        public abstract ImageProcessor getProcessor();

        public abstract ImageEnergy removeSeam(int[] var1, boolean var2);

        public ImageProcessor removeVerticalSeam() {
            return this.removeSeam(this.getVerticalSeam(), true).getProcessor();
        }

        public ImageProcessor removeHorizontalSeam() {
            return this.removeSeam(this.getHorizontalSeam(), false).getProcessor();
        }

        public Roi seam2roi(int[] nArray, boolean bl) {
            int[] nArray2 = new int[bl ? this.h : this.w];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = i;
            }
            return new PolygonRoi(bl ? nArray : nArray2, bl ? nArray2 : nArray, nArray.length, 7);
        }
    }
}

