/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Triangle_Algorithm
implements PlugInFilter {
    protected ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        int[] nArray = this.getHistogram(imageProcessor);
        int n = this.triangleAlgorithm(nArray);
        imageProcessor.setThreshold((double)n, 256.0, 0);
        this.image.updateAndDraw();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 129;
    }

    int[] getHistogram(ImageProcessor imageProcessor) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int[] nArray = new int[256];
        for (int i = 0; i < n * n2; ++i) {
            int n3 = byArray[i] & 0xFF;
            nArray[n3] = nArray[n3] + 1;
        }
        return nArray;
    }

    int triangleAlgorithm(int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[n] > nArray[i]) {
                n = i;
                continue;
            }
            if (nArray[n2] >= nArray[i]) continue;
            n2 = i;
        }
        if (n == n2) {
            return n;
        }
        double d = nArray[n2] - nArray[n];
        double d2 = n - n2;
        double d3 = Math.sqrt(d * d + d2 * d2);
        d /= d3;
        d2 /= d3;
        d3 = d * (double)n + d2 * (double)nArray[n];
        int n3 = n;
        double d4 = 0.0;
        for (int i = n + 1; i <= n2; ++i) {
            double d5 = d * (double)i + d2 * (double)nArray[i] - d3;
            if (!(d5 > d4)) continue;
            n3 = i;
            d4 = d5;
        }
        return n3;
    }
}

