/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Two_Point_Correlation
implements PlugInFilter {
    ImagePlus image;
    byte[] pixels;
    float[] convolved;
    int w;
    int h;

    final int get(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.w || n2 >= this.h) {
            return 0;
        }
        return this.pixels[n + this.w * n2] & 0xFF;
    }

    final float getConvolved(float f, float f2) {
        int n = (int)Math.floor(f);
        int n2 = (int)Math.floor(f2);
        if (n < -this.w + 1 || n >= this.w - 1 || n2 < -this.h + 1 || n2 >= this.h - 1) {
            return 0.0f;
        }
        float f3 = f - (float)n;
        float f4 = f2 - (float)n2;
        float f5 = this.convolved[this.w - 1 + n + (this.h - 1 + n2) * 2 * this.w];
        float f6 = this.convolved[this.w + n + (this.h - 1 + n2) * 2 * this.w];
        float f7 = this.convolved[this.w - 1 + n + (this.h + n2) * 2 * this.w];
        float f8 = this.convolved[this.w + n + (this.h + n2) * 2 * this.w];
        float f9 = Float.MIN_VALUE + (1.0f - f3) * (1.0f - f3) + (1.0f - f4) * (1.0f - f4);
        float f10 = Float.MIN_VALUE + f3 * f3 + (1.0f - f4) * (1.0f - f4);
        float f11 = Float.MIN_VALUE + (1.0f - f3) * (1.0f - f3) + f4 * f4;
        float f12 = Float.MIN_VALUE + f3 * f3 + f4 * f4;
        return (f5 * f9 + f6 * f10 + f7 * f11 + f8 * f12) / (f9 + f10 + f11 + f12);
    }

    static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    void getConvolvedNaive() {
        for (int i = -this.h + 1; i < this.h; ++i) {
            for (int j = -this.w + 1; j < this.w; ++j) {
                int n = 0;
                int n2 = this.w - 1 + j + (this.h - 1 + i) * 2 * this.w;
                for (int k = Two_Point_Correlation.min(0, -j); j + k < this.w && k < this.w; ++k) {
                    for (int i2 = Two_Point_Correlation.min(0, -i); i + i2 < this.h && i2 < this.h; ++i2) {
                        int n3 = n2;
                        this.convolved[n3] = this.convolved[n3] + (float)(this.get(k, i2) * this.get(j + k, i + i2));
                        ++n;
                    }
                }
                int n4 = n2;
                this.convolved[n4] = this.convolved[n4] / ((float)n * 255.0f * 255.0f);
                IJ.showProgress((int)(n2 + 0), (int)(4 * this.w * (this.h - 1)));
            }
        }
    }

    void getConvolved() {
        int n;
        for (n = 2; n < this.w || n < this.h; n *= 2) {
        }
        int n2 = (n *= 2) * n;
        double[][] dArray = new double[n2][2];
        double[][] dArray2 = new double[n2][2];
        for (int i = 0; i < this.h; ++i) {
            for (int j = 0; j < this.w; ++j) {
                int n3 = j + this.w * i;
                dArray[n3 + this.w * i][0] = this.pixels[n3];
                dArray2[this.w - j - 1 + 2 * this.w * (this.h - i - 1)][0] = this.pixels[n3];
            }
        }
        IJ.showProgress((double)0.0);
        double[][] dArray3 = FFT.fft(dArray);
        IJ.showProgress((double)0.3);
        double[][] dArray4 = FFT.fft(dArray2);
        IJ.showProgress((double)0.6);
        double[][] dArray5 = FFT.multiply(dArray3, dArray4);
        IJ.showProgress((double)0.7);
        double[][] dArray6 = FFT.ifft(dArray5);
        IJ.showProgress((double)0.9);
        for (int i = 0; i < this.convolved.length; ++i) {
            this.convolved[i] = (float)dArray6[i][0] / 255.0f / 255.0f;
        }
        IJ.showProgress((double)1.0);
    }

    public void run(ImageProcessor imageProcessor) {
        int n;
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        GenericDialog genericDialog = new GenericDialog("Two Point Correlation");
        genericDialog.addNumericField("min_radius", 0.0, 1);
        genericDialog.addNumericField("max_radius", Math.sqrt(this.w * this.w + this.h * this.h), 1);
        genericDialog.addNumericField("radius_step", 0.3, 1);
        genericDialog.addCheckbox("invert", false);
        genericDialog.addCheckbox("normalize", false);
        genericDialog.addCheckbox("naive computation (slow)", false);
        genericDialog.addCheckbox("show convolved image", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d = genericDialog.getNextNumber();
        double d2 = genericDialog.getNextNumber();
        double d3 = genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        boolean bl2 = genericDialog.getNextBoolean();
        boolean bl3 = genericDialog.getNextBoolean();
        boolean bl4 = genericDialog.getNextBoolean();
        this.pixels = (byte[])this.image.getProcessor().getPixels();
        if (bl) {
            for (n = 0; n < this.pixels.length; ++n) {
                this.pixels[n] = (byte)(255 - (this.pixels[n] & 0xFF));
            }
        }
        this.convolved = new float[4 * this.w * this.h];
        if (bl3) {
            this.getConvolvedNaive();
        } else {
            this.getConvolved();
        }
        if (bl4) {
            new ImagePlus("convolved", (ImageProcessor)new FloatProcessor(2 * this.w, 2 * this.h, this.convolved, null)).show();
        }
        n = (int)((d2 - d) / d3) + 1;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float f = -3.4028235E38f;
        float f2 = -f;
        for (int i = 0; i < n; ++i) {
            float f3 = (float)(d + (double)i * (d2 - d) / (double)n);
            int n2 = (int)(1.0 + Math.PI * 2 * (double)f3);
            float f4 = 0.0f;
            for (int j = 0; j < n2; ++j) {
                float f5 = (float)(Math.PI * 2 * (double)j / (double)n2);
                f4 += this.getConvolved((float)((double)f3 * Math.cos(f5)), (float)((double)f3 * Math.sin(f5)));
            }
            fArray[i] = f3;
            fArray2[i] = f4 / (float)n2;
            if (f < fArray2[i]) {
                f = fArray2[i];
                continue;
            }
            if (!(f2 > fArray2[i])) continue;
            f2 = fArray2[i];
        }
        if (bl2) {
            float f6 = this.getConvolved(0.0f, 0.0f);
            int n3 = 0;
            while (n3 < fArray.length) {
                int n4 = n3++;
                fArray2[n4] = fArray2[n4] / f6;
            }
            f2 /= f6;
            f /= f6;
        }
        PlotWindow plotWindow = new PlotWindow("Two Point Correlation", "radius", "S2(radius)", fArray, fArray2);
        plotWindow.setLimits(0.0, d2, (double)f2, (double)f);
        plotWindow.draw();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 129;
    }
}

