/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class Visual_Grep
implements PlugInFilter {
    ImagePlus imp;
    float minDistance;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 144;
    }

    public void run(ImageProcessor imageProcessor) {
        int n;
        int[] nArray = WindowManager.getIDList();
        String[] stringArray = new String[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            stringArray[n] = WindowManager.getImage((int)nArray[n]).getTitle();
        }
        n = 0;
        int n2 = imageProcessor.getWidth();
        while (n2 > 200) {
            n2 /= 2;
            ++n;
        }
        GenericDialog genericDialog = new GenericDialog("Visual Grep");
        genericDialog.addChoice("needle", stringArray, stringArray[0]);
        genericDialog.addNumericField("tolerance", 5000.0, 0);
        genericDialog.addNumericField("pyramidLevel", (double)n, 0);
        genericDialog.addCheckbox("testDistance", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n3 = nArray[genericDialog.getNextChoiceIndex()];
        ImagePlus imagePlus = WindowManager.getImage((int)n3);
        int n4 = (int)genericDialog.getNextNumber();
        n = (int)genericDialog.getNextNumber();
        boolean bl = genericDialog.getNextBoolean();
        if (bl) {
            this.testDistance(imageProcessor, imagePlus.getProcessor(), n);
            return;
        }
        this.minDistance = Float.MAX_VALUE;
        ArrayList arrayList = this.getPoints(imageProcessor, imagePlus.getProcessor(), n4, n, n, null);
        if (arrayList.size() == 0) {
            IJ.error((String)("No region found! Minimal tolerance needed: " + this.minDistance));
            return;
        }
        Roi roi = this.getRoi(arrayList, imagePlus.getWidth(), imagePlus.getHeight());
        this.imp.setRoi(roi);
        this.imp.updateAndDraw();
    }

    void testDistance(ImageProcessor imageProcessor, ImageProcessor imageProcessor2, int n) {
        if (n > 0) {
            int n2 = 1 << n;
            imageProcessor = imageProcessor.resize(imageProcessor.getWidth() / n2, imageProcessor.getHeight() / n2);
            imageProcessor2 = imageProcessor2.resize(imageProcessor2.getWidth() / n2, imageProcessor2.getHeight() / n2);
        }
        int[] nArray = (int[])imageProcessor.getPixels();
        int[] nArray2 = (int[])imageProcessor2.getPixels();
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        int n5 = imageProcessor2.getWidth();
        int n6 = imageProcessor2.getHeight();
        int n7 = n3 - n5;
        int n8 = n4 - n6;
        float[] fArray = new float[n7 * n8];
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n7; ++j) {
                fArray[j + n7 * i] = this.distance(nArray, j, i, n3, nArray2, n5, n6);
            }
            IJ.showProgress((int)(i + 1), (int)n8);
        }
        FloatProcessor floatProcessor = new FloatProcessor(n7, n8, fArray, null);
        new ImagePlus("distance", (ImageProcessor)floatProcessor).show();
    }

    ArrayList getPoints(ImageProcessor imageProcessor, ImageProcessor imageProcessor2, int n, int n2, int n3, ArrayList arrayList) {
        int n4 = imageProcessor.getWidth();
        int n5 = imageProcessor.getHeight();
        int n6 = imageProcessor2.getWidth();
        int n7 = imageProcessor2.getHeight();
        ArrayList arrayList2 = new ArrayList();
        int[] nArray = (int[])imageProcessor.getPixels();
        int[] nArray2 = (int[])imageProcessor2.getPixels();
        if (n2 > 0) {
            Point point;
            ArrayList<Point> arrayList3 = null;
            if (arrayList != null) {
                arrayList3 = new ArrayList<Point>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    point = (Point)arrayList.get(i);
                    Point point2 = new Point(point.x / 2, point.y / 2, point.diff);
                    arrayList3.add(point2);
                }
            }
            ImageProcessor imageProcessor3 = imageProcessor.resize(n4 / 2, n5 / 2);
            point = imageProcessor2.resize(n6 / 2, n7 / 2);
            arrayList = this.getPoints(imageProcessor3, (ImageProcessor)point, n, n2 - 1, n3, arrayList3);
            for (int i = 0; i < arrayList.size(); ++i) {
                Point point3 = (Point)arrayList.get(i);
                point3.x *= 2;
                point3.y *= 2;
                int n8 = 2;
                int n9 = 2;
                if (point3.x + n8 + n6 > n4) {
                    n8 = 1;
                }
                if (point3.y + n9 + n7 > n5) {
                    n9 = 1;
                }
                this.getPoints(arrayList2, nArray, n4, nArray2, n6, n7, point3.x, point3.y, point3.x + n8, point3.y + n9, n, false);
            }
        } else {
            this.getPoints(arrayList2, nArray, n4, nArray2, n6, n7, 0, 0, n4 - n6, n5 - n7, n, true);
        }
        IJ.showProgress((int)(n2 + 1), (int)n3);
        return arrayList2;
    }

    void getPoints(ArrayList arrayList, int[] nArray, int n, int[] nArray2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        for (int i = n5; i < n7; ++i) {
            for (int j = n4; j < n6; ++j) {
                float f = this.distance(nArray, j, i, n, nArray2, n2, n3);
                if (!(f < (float)n8)) continue;
                this.addPoint(arrayList, n2, n3, new Point(j, i, f));
            }
            if (!bl) continue;
            IJ.showProgress((int)(i - n5 + 1), (int)(n7 - n5));
        }
    }

    void addPoint(ArrayList arrayList, int n, int n2, Point point) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Point point2 = (Point)arrayList.get(i);
            if (!point2.overlaps(point, n, n2)) continue;
            if (point2.diff > point.diff) {
                point2.replaceWith(point);
            }
            return;
        }
        arrayList.add(point);
    }

    float distance(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5) {
        long l = 0L;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n6 = nArray[n + j + n3 * (n2 + i)];
                int n7 = nArray2[j + n4 * i];
                int n8 = (n6 >> 16 & 0xFF) - (n7 >> 16 & 0xFF);
                int n9 = (n6 >> 8 & 0xFF) - (n7 >> 8 & 0xFF);
                int n10 = (n6 & 0xFF) - (n7 & 0xFF);
                l += (long)(n8 * n8 + n9 * n9 + n10 * n10);
            }
        }
        float f = (float)l / (float)(n4 * n5);
        if (this.minDistance > f) {
            this.minDistance = f;
        }
        return f;
    }

    Roi getRoi(ArrayList arrayList, int n, int n2) {
        if (arrayList.size() < 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            Point point = (Point)arrayList.get(0);
            return new Roi(point.x, point.y, n, n2);
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < arrayList.size(); ++i) {
            Point point = (Point)arrayList.get(i);
            generalPath.moveTo(point.x, point.y);
            generalPath.lineTo(point.x + n, point.y);
            generalPath.lineTo(point.x + n, point.y + n2);
            generalPath.lineTo(point.x, point.y + n2);
            generalPath.closePath();
        }
        return new ShapeRoi((Shape)generalPath);
    }

    private class Point {
        int x;
        int y;
        float diff;

        Point(int n, int n2, float f) {
            this.x = n;
            this.y = n2;
            this.diff = f;
        }

        boolean overlaps(Point point, int n, int n2) {
            return this.x + n > point.x && point.x + n > this.x && this.y + n2 > point.y && point.y + n2 > this.y;
        }

        void replaceWith(Point point) {
            this.x = point.x;
            this.y = point.y;
            this.diff = point.diff;
        }
    }
}

