/*
 * Decompiled with CFR 0.152.
 */
package adt;

import java.util.Random;

public class ByteProbability {
    public static final double[] BYTE_TO_DOUBLE;
    public static final byte[] INTEGER_TO_BYTE;
    public static final byte[][] MULTIPLY;
    public static final byte[][] DIVIDE;

    public static byte toByte(double d) {
        byte by = 0;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < 256; ++i) {
            double d3 = BYTE_TO_DOUBLE[i];
            double d4 = Math.abs(d - d3);
            if (!(d4 < d2)) continue;
            d2 = d4;
            by = INTEGER_TO_BYTE[i];
        }
        return by;
    }

    public static final byte multiply(byte by, byte by2) {
        return MULTIPLY[by & 0xFF][by2 & 0xFF];
    }

    public static final byte divide(byte by, byte by2) {
        return DIVIDE[by & 0xFF][by2 & 0xFF];
    }

    public static void main(String[] stringArray) {
        double d;
        double d2;
        double d3;
        double d4;
        byte by;
        byte by2;
        int n;
        int n2;
        int n3;
        for (int i = 0; i < 256; ++i) {
            System.out.println("i = " + i);
            n3 = INTEGER_TO_BYTE[i];
            System.out.println("tstByte = " + n3);
            System.out.println("tstByte&0xFF = " + (n3 & 0xFF));
            System.out.println("INTEGER_TO_BYTE[tstByte & 0xFF] = " + INTEGER_TO_BYTE[n3 & 0xFF]);
            System.out.println("BYTE_TO_DOUBLE[tstByte&0xFF] = " + BYTE_TO_DOUBLE[n3 & 0xFF]);
            n3 = (byte)(n3 + 1);
        }
        Random random = new Random();
        for (n3 = 0; n3 < 20; ++n3) {
            n2 = random.nextInt(256);
            n = random.nextInt(256);
            by2 = INTEGER_TO_BYTE[n2];
            by = INTEGER_TO_BYTE[n];
            d4 = BYTE_TO_DOUBLE[by2 & 0xFF];
            d3 = BYTE_TO_DOUBLE[by & 0xFF];
            d2 = BYTE_TO_DOUBLE[MULTIPLY[by2 & 0xFF][by & 0xFF] & 0xFF];
            d = d4 * d3;
            System.out.println("multiply via byte = " + d2);
            System.out.println("check via double = " + d);
        }
        for (n3 = 0; n3 < 20; ++n3) {
            n2 = random.nextInt(256);
            n = random.nextInt(256);
            by2 = INTEGER_TO_BYTE[n2];
            by = INTEGER_TO_BYTE[n];
            d4 = BYTE_TO_DOUBLE[by2 & 0xFF];
            d3 = BYTE_TO_DOUBLE[by & 0xFF];
            d2 = BYTE_TO_DOUBLE[DIVIDE[by2 & 0xFF][by & 0xFF] & 0xFF];
            d = d4 / d3;
            System.out.println("divide via byte = " + d2);
            System.out.println("check via double = " + d);
        }
    }

    static {
        int n;
        int n2;
        BYTE_TO_DOUBLE = new double[256];
        INTEGER_TO_BYTE = new byte[256];
        MULTIPLY = new byte[256][256];
        DIVIDE = new byte[256][256];
        for (n2 = 0; n2 < 256; ++n2) {
            ByteProbability.BYTE_TO_DOUBLE[n2] = (double)n2 / 255.0;
        }
        for (n2 = -128; n2 <= 127; ++n2) {
            n = n2;
            int n3 = n & 0xFF;
            ByteProbability.INTEGER_TO_BYTE[n3] = n;
        }
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                ByteProbability.MULTIPLY[n2][n] = ByteProbability.toByte(BYTE_TO_DOUBLE[n2] * BYTE_TO_DOUBLE[n]);
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                ByteProbability.DIVIDE[n2][n] = ByteProbability.toByte(BYTE_TO_DOUBLE[n2] / BYTE_TO_DOUBLE[n]);
            }
        }
    }
}

