/*
 * Decompiled with CFR 0.152.
 */
package adt;

import adt.Points;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connectivity2D {
    HashSet<Points> islands = new HashSet();
    Point topLeft;
    Point bottomRight;

    public void addPoint(int n, int n2) {
        this.addPoint(new Point(n, n2));
    }

    public void addLowerRightPoint(Point point) {
        if (this.topLeft == null) {
            this.topLeft = new Point(point.x, point.y);
        } else {
            if (point.x < this.topLeft.x) {
                this.topLeft.x = point.x;
            }
            if (point.y < this.topLeft.y) {
                this.topLeft.y = point.y;
            }
        }
        if (this.bottomRight == null) {
            this.bottomRight = new Point(point.x, point.y);
        }
        this.addPoint(point, Connectivity2D.getUpperLeftNeigbours(point));
    }

    public void addPoint(Point point) {
        if (this.topLeft == null) {
            this.topLeft = new Point(point.x, point.y);
        } else {
            if (point.x < this.topLeft.x) {
                this.topLeft.x = point.x;
            }
            if (point.y < this.topLeft.y) {
                this.topLeft.y = point.y;
            }
        }
        if (this.bottomRight == null) {
            this.bottomRight = new Point(point.x, point.y);
        } else {
            if (point.x > this.bottomRight.x) {
                this.bottomRight.x = point.x;
            }
            if (point.y > this.bottomRight.y) {
                this.bottomRight.y = point.y;
            }
        }
        this.addPoint(point, Connectivity2D.getNeighbours(point));
    }

    private void addPoint(Point point, Set<Point> set) {
        Points points = null;
        HashSet<Points> hashSet = new HashSet<Points>();
        for (Point object : set) {
            for (Points points2 : this.islands) {
                if (!points2.contains(object)) continue;
                points2.addPoint(point);
                if (points == null) {
                    points = points2;
                    continue;
                }
                if (points2 == points) continue;
                hashSet.add(points2);
            }
        }
        if (points == null) {
            Points points3 = new Points();
            points3.addPoint(point);
            this.islands.add(points3);
        } else {
            for (Points points3 : hashSet) {
                points.addPoints(points3);
                this.islands.remove(points3);
            }
        }
    }

    public Iterable<Points> getIslands() {
        return this.islands;
    }

    public static Set<Point> getNeighbours(Point point) {
        HashSet<Point> hashSet = new HashSet<Point>();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                hashSet.add(new Point(point.x + i, point.y + j));
            }
        }
        return hashSet;
    }

    public static Set<Point> getUpperLeftNeigbours(Point point) {
        HashSet<Point> hashSet = new HashSet<Point>();
        hashSet.add(new Point(point.x - 1, point.y));
        hashSet.add(new Point(point.x, point.y - 1));
        return hashSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Points points : this.islands) {
            stringBuffer.append("\n").append("island: ").append(n++);
            for (Point point : points.getPoints()) {
                stringBuffer.append(point).append("\t");
            }
        }
        return stringBuffer.toString();
    }
}

