/*
 * Decompiled with CFR 0.152.
 */
package adt;

public class PixelStats {
    int n = 0;
    long[] pixelOccurences = new long[256];
    int seqLength = 0;
    double seqSum = 0.0;
    double seqSumSquared = 0.0;
    int seqN = 0;

    public void addData(byte by) {
        int n = by & 0xFF;
        this.pixelOccurences[n] = this.pixelOccurences[n] + 1L;
        ++this.n;
        ++this.seqLength;
    }

    public void endOfSequence() {
        this.seqSum += (double)this.seqLength;
        this.seqSumSquared += (double)(this.seqLength * this.seqLength);
        this.seqLength = 0;
        ++this.seqN;
    }

    public int getN() {
        return this.n;
    }

    public double getMeanSequenceLength() {
        return this.seqSum / (double)this.seqN;
    }

    public double getVarianceSequenceLength() {
        return this.seqSumSquared / (double)this.seqN - this.getMeanSequenceLength() * this.getMeanSequenceLength();
    }

    public double getProb(byte by) {
        return (double)this.pixelOccurences[by & 0xFF] / (double)this.n;
    }

    public static void main(String[] stringArray) {
    }
}

