/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraTable;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmiraParameters {
    public static final String INFO = "Info";
    private int width;
    private int height;
    private int depth;
    private static Pattern parameterKeyPattern;
    private static Pattern parameterStringValuePattern;
    private static Pattern parameterStringValuePattern2;
    private static Pattern parameterGroupValuePattern;
    private static Pattern parameterGroupEndPattern;
    private static Pattern colorPattern;
    private Properties parameters;
    private Vector materials;
    String line;
    public static String defaultMaterialsString;

    public AmiraParameters(ImagePlus imagePlus) {
        this.parameters = new Properties();
        if (AmiraParameters.isAmiraMesh(imagePlus) || imagePlus.getProperty(INFO) != null) {
            this.line = "Parameters {\n" + (String)imagePlus.getProperty(INFO) + "}\n";
            this.parseParameters(this.parameters);
        }
        this.initializeMaterials();
        this.initDefaults(imagePlus);
    }

    public AmiraParameters(Properties properties) {
        this.parameters = new Properties();
        this.parameters.putAll((Map<?, ?>)properties);
    }

    public AmiraParameters(String string) {
        this.line = string;
        this.parameters = new Properties();
        this.parseParameters(this.parameters);
        this.initializeMaterials();
        if (this.parameters.get("Parameters") == null) {
            this.initDefaults(1, 1, 1);
        }
    }

    private void initDefaults(int n, int n2, int n3) {
        this.initDefaults(n, n2, n3, 1.0, 1.0, 1.0);
    }

    private void initDefaults(int n, int n2, int n3, double d, double d2, double d3) {
        this.width = n;
        this.height = n2;
        this.depth = n3;
        Hashtable<String, String> hashtable = (Hashtable<String, String>)this.parameters.get("Parameters");
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            this.parameters.put("Parameters", hashtable);
        }
        hashtable.put("BoundingBox", "0.0 " + (double)n * d + " 0.0 " + (double)n2 * d2 + " 0.0 " + (double)n3 * d3);
        hashtable.put("CoordType", "\"uniform\"");
        hashtable.put("Content", "\"" + n + "x" + n2 + "x" + n3 + " byte, uniform coordinates\"");
    }

    public void initDefaults(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        if (imageStack == null) {
            this.initDefaults(imagePlus.getWidth(), imagePlus.getHeight(), 1);
        } else {
            this.initDefaults(imageStack.getWidth(), imageStack.getHeight(), imageStack.getSize());
        }
        Calibration calibration = imagePlus.getCalibration();
        if (calibration != null) {
            this.put("BoundingBox", calibration.getX(0.0) + " " + calibration.getX((double)imagePlus.getWidth()) + " " + calibration.getY(0.0) + " " + calibration.getY((double)imagePlus.getHeight()) + " " + calibration.getZ(0.0) + " " + calibration.getZ((double)(imageStack == null ? 1 : imageStack.getSize())));
        }
    }

    public static boolean isAmiraMesh(ImagePlus imagePlus) {
        Object object = imagePlus.getProperty(INFO);
        if (object == null || !(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        return string.indexOf("CoordType") >= 0;
    }

    public static final boolean isAmiraLabelfield(ImagePlus imagePlus) {
        Object object = imagePlus.getProperty(INFO);
        if (object == null || !(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        return string.indexOf("CoordType") >= 0 && string.indexOf("Materials") >= 0;
    }

    public static boolean isAmiraLabelfield(Properties properties) {
        return properties != null && properties.get("Parameters") != null && ((Hashtable)properties.get("Parameters")).get("Materials") != null;
    }

    private void assertPatternsInitialized() {
        if (parameterKeyPattern == null) {
            parameterKeyPattern = Pattern.compile("\\A[ \t\n]*([-A-Za-z0-9_]+)[ \t]*(.*)\\z", 32);
            parameterStringValuePattern = Pattern.compile("\\A([^\n]*?)([,}]?)\n(.*)\\z", 32);
            parameterStringValuePattern2 = Pattern.compile("\\A\"([^\"]*?)(\")\n(.*)\\z", 32);
            parameterGroupValuePattern = Pattern.compile("\\A\\{(.*)\\z", 32);
            parameterGroupEndPattern = Pattern.compile("\\A[ \t\n]*}(.*)\\z", 32);
            colorPattern = Pattern.compile("^([0-9]*(\\.[0-9]*e?-?[0-9]*)?)[ \t]+([0-9]*(\\.[0-9]*e?-?[0-9]*)?)[ \t]+([0-9]*(\\.[0-9]*e?-?[0-9]*)?)");
        }
    }

    private boolean parseParameters(Hashtable hashtable) {
        return this.parseParameters(hashtable, false);
    }

    private boolean parseParameters(Hashtable hashtable, boolean bl) {
        this.assertPatternsInitialized();
        Matcher matcher = parameterKeyPattern.matcher(this.line);
        if (matcher.matches()) {
            String string = matcher.group(1);
            this.line = matcher.group(2);
            Matcher matcher2 = parameterGroupValuePattern.matcher(this.line);
            if (matcher2.matches()) {
                if (bl) {
                    if (this.materials == null) {
                        this.materials = new Vector();
                    }
                    this.materials.add(string);
                }
                this.line = matcher2.group(1);
                Hashtable hashtable2 = new Hashtable();
                hashtable.put(string, hashtable2);
                while (this.parseParameters(hashtable2, string.equals("Materials"))) {
                }
                return true;
            }
            Matcher matcher3 = parameterStringValuePattern2.matcher(this.line);
            if (!matcher3.matches()) {
                matcher3 = parameterStringValuePattern.matcher(this.line);
            }
            if (matcher3.matches()) {
                String string2 = matcher3.group(1);
                String string3 = matcher3.group(2);
                this.line = matcher3.group(3);
                hashtable.put(string, string2);
                return !string3.equals("}");
            }
            System.err.println("Warning: empty value for key " + string);
            hashtable.put(string, "");
            return true;
        }
        Matcher matcher4 = parameterGroupEndPattern.matcher(this.line);
        if (matcher4.matches()) {
            this.line = matcher4.group(1);
            return false;
        }
        System.err.println("This shouldn't happen: no key, and no '}': " + this.line);
        return false;
    }

    public Object get(String string) {
        Hashtable hashtable = (Hashtable)this.parameters.get("Parameters");
        return hashtable.get(string);
    }

    public void put(String string, Object object) {
        Hashtable hashtable = (Hashtable)this.parameters.get("Parameters");
        hashtable.put(string, object);
    }

    void initializeMaterials() {
        String string;
        if (this.materials == null) {
            this.materials = new Vector();
        }
        if ((string = (String)this.parameters.get("MaterialList")) == null) {
            string = "";
            for (int i = 0; i < this.materials.size(); ++i) {
                string = string + (i > 0 ? "," : "") + (String)this.materials.get(i);
            }
            this.parameters.put("MaterialList", string);
        } else {
            this.materials.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.materials.add(stringTokenizer.nextToken());
            }
        }
    }

    public String toString() {
        String string = "";
        String string2 = "\t";
        Hashtable hashtable = (Hashtable)this.parameters.get("Parameters");
        if (hashtable == null) {
            return string;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            string = string + string2 + string3 + " " + this.getProperty(hashtable, string3, string2) + "\n";
        }
        return string;
    }

    public String getProperty(String string) {
        if (string == null) {
            return "";
        }
        return this.getProperty((Hashtable)this.parameters.get("Parameters"), string, "");
    }

    public String getProperty(Hashtable hashtable, String string, String string2) {
        Enumeration<Object> enumeration;
        Object v = hashtable.get(string);
        if (v == null) {
            return "\"\"";
        }
        if (v instanceof String) {
            return (String)v;
        }
        String string3 = string2 + "}";
        string2 = string2 + "\t";
        String string4 = "{";
        String string5 = "\n";
        Hashtable hashtable2 = (Hashtable)v;
        Enumeration<Object> enumeration2 = enumeration = string.equals("Materials") ? this.materials.elements() : hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            String string7 = this.getProperty(hashtable2, string6, string2);
            string4 = string4 + string5 + string2 + string6 + " " + string7;
            if (!string7.equals("") && !string7.endsWith("}")) {
                string5 = ",\n";
                continue;
            }
            string5 = "\n";
        }
        string4 = string4 + "\n" + string3;
        return string4;
    }

    public ColorModel getColorModel() {
        if (this.materials == null || this.materials.size() == 0) {
            return null;
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (int i = 0; i < this.getMaterialCount(); ++i) {
            double[] dArray = this.getMaterialColor(i);
            byArray[i] = (byte)Math.round(dArray[0] * 255.0);
            byArray2[i] = (byte)Math.round(dArray[1] * 255.0);
            byArray3[i] = (byte)Math.round(dArray[2] * 255.0);
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }

    public void setParameters(ImagePlus imagePlus) {
        this.setParameters(imagePlus, true);
    }

    public void setParameters(ImagePlus imagePlus, boolean bl) {
        ColorModel colorModel;
        imagePlus.setProperty(INFO, (Object)this.toString());
        if (bl) {
            this.setCalibration(imagePlus);
        }
        if ((colorModel = this.getColorModel()) == null) {
            byte[] byArray = new byte[256];
            byte[] byArray2 = new byte[256];
            byte[] byArray3 = new byte[256];
            for (int i = 0; i < 256; ++i) {
                byArray[i] = (byte)i;
                byArray2[i] = (byte)i;
                byArray3[i] = (byte)i;
            }
            colorModel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        }
        imagePlus.getProcessor().setColorModel(colorModel);
        if (imagePlus.getStackSize() > 1) {
            imagePlus.getStack().setColorModel(colorModel);
        }
    }

    public void setParameters(Properties properties) {
        Enumeration<Object> enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, this.parameters.get(string));
        }
    }

    public boolean changeLabelfieldToGray() {
        Hashtable hashtable = (Hashtable)this.parameters.get("Parameters");
        if (this.parameters.get("MaterialList") == null && this.materials == null && (hashtable == null || hashtable.get("Materials") == null)) {
            return false;
        }
        if (hashtable != null) {
            hashtable.remove("Materials");
        }
        this.materials = null;
        this.parameters.remove("MaterialList");
        return true;
    }

    public int addMaterial(String string, double d, double d2, double d3) {
        Hashtable hashtable = this.getMaterials();
        if (hashtable == null) {
            hashtable = new Hashtable();
            ((Hashtable)this.parameters.get("Parameters")).put("Materials", hashtable);
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("Color", d + " " + d2 + " " + d3);
        hashtable.put(string, hashtable2);
        if (this.materials == null) {
            this.materials = new Vector();
        }
        this.materials.add(string);
        String string2 = (String)this.parameters.get("MaterialList");
        if (string2 == null) {
            this.initializeMaterials();
        } else {
            this.parameters.put("MaterialList", string2 + "," + string);
        }
        return this.materials.size() - 1;
    }

    public String[] getMaterialList() {
        int n = this.getMaterialCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getMaterialName(i);
        }
        return stringArray;
    }

    public Hashtable getMaterials() {
        return (Hashtable)this.get("Materials");
    }

    public int getMaterialCount() {
        return this.materials.size();
    }

    public String getMaterialName(int n) {
        return (String)this.materials.get(n);
    }

    public int getMaterialID(String string) {
        for (int i = 0; i < this.materials.size(); ++i) {
            if (!string.equals(this.materials.get(i))) continue;
            return i;
        }
        return -1;
    }

    public double[] getMaterialColor(int n) {
        double[] dArray = new double[3];
        this.assertPatternsInitialized();
        Hashtable hashtable = (Hashtable)this.getMaterials().get(this.materials.get(n));
        Object v = hashtable.get("Color");
        if (v == null) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        } else {
            Matcher matcher = colorPattern.matcher((String)v);
            if (matcher.matches()) {
                dArray[0] = Double.parseDouble(matcher.group(1));
                dArray[1] = Double.parseDouble(matcher.group(3));
                dArray[2] = Double.parseDouble(matcher.group(5));
            } else {
                dArray[2] = 0.0;
                dArray[1] = 0.0;
                dArray[0] = 0.0;
            }
        }
        return dArray;
    }

    public boolean editMaterial(int n, String string, double d, double d2, double d3) {
        if (n < 0 || this.materials == null || n >= this.materials.size()) {
            return false;
        }
        if (string == null) {
            string = this.getMaterialName(n);
        }
        double[] dArray = this.getMaterialColor(n);
        if (d < 0.0 || d > 1.0) {
            d = dArray[0];
        }
        if (d2 < 0.0 || d2 > 1.0) {
            d2 = dArray[1];
        }
        if (d3 < 0.0 || d3 > 1.0) {
            d3 = dArray[2];
        }
        this.materials.set(n, string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Color", d + " " + d2 + " " + d3);
        this.getMaterials().put(string, hashtable);
        return true;
    }

    public void setCalibration(ImagePlus imagePlus) {
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        ImageStack imageStack = imagePlus.getStack();
        this.depth = imageStack == null ? 1 : imageStack.getSize();
        Calibration calibration = imagePlus.getCalibration();
        if (calibration == null) {
            calibration = new Calibration();
            imagePlus.setCalibration(calibration);
        }
        this.setCalibration(calibration);
    }

    public void setCalibration(Calibration calibration) {
        String string = (String)this.get("BoundingBox");
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            calibration.xOrigin = -Double.parseDouble(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            calibration.pixelWidth = (Double.parseDouble(stringTokenizer.nextToken()) + calibration.xOrigin) / (double)this.width;
            if (calibration.pixelWidth != 0.0) {
                calibration.xOrigin /= calibration.pixelWidth;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            calibration.yOrigin = -Double.parseDouble(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            calibration.pixelHeight = (Double.parseDouble(stringTokenizer.nextToken()) + calibration.yOrigin) / (double)this.height;
            if (calibration.pixelHeight != 0.0) {
                calibration.yOrigin /= calibration.pixelHeight;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            calibration.zOrigin = -Double.parseDouble(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            calibration.pixelDepth = (Double.parseDouble(stringTokenizer.nextToken()) + calibration.zOrigin) / (double)this.depth;
            if (calibration.pixelDepth != 0.0) {
                calibration.zOrigin /= calibration.pixelDepth;
            }
        }
    }

    public static boolean addImageList(GenericDialog genericDialog, String string, String string2, IsA isA) {
        ImagePlus imagePlus;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        while ((imagePlus = WindowManager.getImage((int)n)) != null) {
            if (isA.isA(imagePlus)) {
                vector.add(imagePlus.getTitle());
            }
            ++n;
        }
        if (vector.size() < 1) {
            IJ.error((String)("No " + string2 + " available"));
            return false;
        }
        AmiraParameters.addChoice(genericDialog, string, vector);
        return true;
    }

    public static boolean addAmiraMeshList(GenericDialog genericDialog, String string) {
        return AmiraParameters.addImageList(genericDialog, string, "AmiraMesh", new IsA(){

            public boolean isA(Object object) {
                ImagePlus imagePlus = (ImagePlus)object;
                return AmiraParameters.isAmiraMesh(imagePlus);
            }
        });
    }

    public static boolean addAmiraLabelsList(GenericDialog genericDialog, String string) {
        return AmiraParameters.addImageList(genericDialog, string, "AmiraLabel", new IsA(){

            public boolean isA(Object object) {
                ImagePlus imagePlus = (ImagePlus)object;
                return AmiraParameters.isAmiraLabelfield(imagePlus);
            }
        });
    }

    public static boolean addAmiraTableList(GenericDialog genericDialog, String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        MenuBar menuBar = Menus.getMenuBar();
        Menu menu = null;
        for (n = 0; n < menuBar.getMenuCount(); ++n) {
            if (!menuBar.getMenu(n).getLabel().equals("Window")) continue;
            menu = menuBar.getMenu(n);
            break;
        }
        if (menu == null) {
            throw new RuntimeException("no Window menu?");
        }
        for (n = 0; n < menu.getItemCount(); ++n) {
            String string2 = menu.getItem(n).getLabel();
            Frame frame = WindowManager.getFrame((String)string2);
            if (frame == null || !(frame instanceof AmiraTable)) continue;
            vector.add(string2);
        }
        if (vector.size() < 1) {
            IJ.error((String)"No AmiraTable available");
            return false;
        }
        AmiraParameters.addChoice(genericDialog, string, vector);
        return true;
    }

    public static int addWindowList(GenericDialog genericDialog, String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (Interpreter.isBatchMode()) {
            vector.add(Macro.getValue((String)Macro.getOptions(), (String)"window", (String)"(null)"));
        } else {
            int n = WindowManager.getWindowCount();
            for (int i = 0; i < n; ++i) {
                ImagePlus imagePlus = WindowManager.getImage((int)(i + 1));
                if (bl && !AmiraParameters.isAmiraMesh(imagePlus)) continue;
                vector.add(imagePlus.getTitle());
            }
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus != null) {
            return AmiraParameters.addChoice(genericDialog, string, vector, imagePlus.getTitle());
        }
        return AmiraParameters.addChoice(genericDialog, string, vector);
    }

    public static int addChoice(GenericDialog genericDialog, String string, Vector vector) {
        return AmiraParameters.addChoice(genericDialog, string, vector, vector.size() > 0 ? (String)vector.get(0) : "");
    }

    public static int addChoice(GenericDialog genericDialog, String string, Vector vector, String string2) {
        String[] stringArray = new String[vector.size()];
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.get(i);
            if (!stringArray[i].equals(string2)) continue;
            bl = true;
        }
        if (!bl) {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray = stringArray2;
            stringArray[0] = string2;
        }
        genericDialog.addChoice(string, stringArray, string2);
        return stringArray.length;
    }

    public Material getMaterial(int n) {
        return new Material(this.getMaterialName(n), n, this.getMaterialColor(n));
    }

    public static AmiraParameters defaultMaterials() {
        return new AmiraParameters("Parameters {\n" + defaultMaterialsString + "}\n");
    }

    public static String[] getWindowList() {
        Object object;
        int n;
        Vector<String> vector = new Vector<String>();
        MenuBar menuBar = Menus.getMenuBar();
        Menu menu = null;
        for (n = 0; n < menuBar.getMenuCount(); ++n) {
            if (!menuBar.getMenu(n).getLabel().equals("Window")) continue;
            menu = menuBar.getMenu(n);
            break;
        }
        if (menu == null) {
            throw new RuntimeException("no Window menu?");
        }
        for (n = 0; n < WindowManager.getWindowCount(); ++n) {
            object = WindowManager.getImage((int)(n + 1));
            vector.add(object.getTitle());
        }
        for (n = 0; n < menu.getItemCount(); ++n) {
            object = menu.getItem(n).getLabel();
            if (WindowManager.getFrame((String)object) == null) continue;
            vector.add((String)object);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    static {
        defaultMaterialsString = "    Materials {\n        Exterior {\n            Id 1\n        }\n        medulla_r {\n            Id -1,\n            Color 1 0 0,\n            Name \"outer_medulla_r\",\n            Group \"OL_r\"\n        }\n        medulla_l {\n            Id -1,\n            Color 1 0 0,\n            Name \"outer_medulla_l\",\n            Group \"OL_l\"\n        }\n        lobula_r {\n            Group \"OL_r\",\n            Color 1 0.552326 0\n        }\n        lobula_l {\n            Id -1,\n            Color 1 0.552326 0,\n            Group \"OL_l\"\n        }\n        lobula_plate_r {\n            Id -1,\n            Color 1 0.796512 0,\n            Group \"OL_r\"\n        }\n        lobula_plate_l {\n            Id -1,\n            Color 1 0.802326 0,\n            Group \"OL_l\"\n        }\n        mushroom_body_r {\n            Id -1,\n            Color 0.401163 0.0988372 0\n        }\n        mushroom_body_l {\n            Id -1,\n            Color 0.401163 0.104651 0\n        }\n        ellipsoid_body {\n            Id -1,\n            Color 0 0.619 0,\n            Group \"CC\"\n        }\n        noduli {\n            Id -1,\n            Color 0.598837 1 0,\n            Group \"CC\"\n        }\n        fan_shaped_body {\n            Id -1,\n            Color 0.110465 1 0.0404624,\n            Group \"CC\"\n        }\n        protocerebral_bridge {\n            Id -1,\n            Color 0 0.373 0,\n            Name \"protocebral_bridge\",\n            Group \"CC\"\n        }\n        antennal_lobe_r {\n            Id 18,\n            Color 0.156863 0.45098 0.8\n        }\n        antennal_lobe_l {\n            Id 19,\n            Color 0.156863 0.45098 0.8\n        }\n        lateral_horn_r {\n            Id 18,\n            Color 0.57 0.3534 0.171,\n            Name \"lateral horn\"\n        }\n        lateral_horn_l {\n            Id 19,\n            Color 0.57 0.352944 0.171\n        }\n    }\n";
    }

    public static class Material {
        public final String name;
        public final int id;
        public final double[] colors;

        public Material(String string, int n, double[] dArray) {
            this.name = string;
            this.id = n;
            this.colors = dArray;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface IsA {
        public boolean isA(Object var1);
    }
}

