/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.IJ;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class AmiraTableEncoder {
    AmiraParameters parameters;
    TextWindow textWindow;
    int columnCount;
    int rowCount;
    String[] headings;
    float[][] values;
    int[] textSizes;
    String[][] text;

    public AmiraTableEncoder(TextWindow textWindow) {
        int n;
        this.textWindow = textWindow;
        TextPanel textPanel = textWindow.getTextPanel();
        String string = textPanel.getColumnHeadings();
        this.headings = string.split("\t");
        for (n = 0; n < this.headings.length; ++n) {
            if (!this.headings[n].equals("") && !this.headings[n].equals(" ")) continue;
            this.headings[n] = "column" + n;
        }
        this.columnCount = this.headings.length;
        this.rowCount = textPanel.getLineCount();
        this.text = new String[this.rowCount][this.columnCount];
        for (n = 0; n < this.rowCount; ++n) {
            this.text[n] = textPanel.getLine(n).split("\t");
        }
        if (textWindow instanceof AmiraTable) {
            this.parameters = new AmiraParameters(((AmiraTable)textWindow).properties);
        } else {
            String string2 = "Parameters {\n" + AmiraTable.getParameterString(this.rowCount, this.headings) + "}\n";
            this.parameters = new AmiraParameters(string2);
        }
        this.values = new float[this.columnCount][];
        this.textSizes = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.values[i] = new float[this.rowCount];
            this.textSizes[i] = -1;
            for (int j = 0; j < this.rowCount; ++j) {
                try {
                    this.values[i][j] = Float.parseFloat(this.text[j][i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    this.values[i] = null;
                    this.textSizes[i] = 0;
                    for (j = 0; j < this.rowCount; ++j) {
                        int n2 = i;
                        this.textSizes[n2] = this.textSizes[n2] + (this.text[j][i].length() + 1);
                    }
                }
            }
        }
    }

    public boolean write(String string) {
        try {
            int n;
            FileWriter fileWriter = new FileWriter(string);
            Date date = new Date();
            fileWriter.write("# AmiraMesh 3D ASCII 2.0\n# CreationDate: " + date + "\n\n");
            for (n = 0; n < this.columnCount; ++n) {
                fileWriter.write("define " + this.headings[n] + " " + (this.values[n] != null ? this.rowCount : this.textSizes[n]) + "\n");
            }
            fileWriter.write("\nParameters {\n" + this.parameters + "\n}\n\n");
            for (n = 0; n < this.columnCount; ++n) {
                fileWriter.write(this.headings[n] + " { " + (this.values[n] != null ? "float" : "byte") + " " + this.headings[n] + " } @" + (n + 1) + "\n");
            }
            fileWriter.write("\n#Data section follows\n");
            for (n = 0; n < this.columnCount; ++n) {
                fileWriter.write("@" + (n + 1) + "\n");
                if (this.values[n] != null) {
                    for (int i = 0; i < this.rowCount; ++i) {
                        fileWriter.write(this.text[i][n] + "\n");
                    }
                } else {
                    this.writeStringColumn(fileWriter, n);
                }
                fileWriter.write("\n");
            }
            fileWriter.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IJ.error((String)exception.toString());
            return false;
        }
    }

    void writeStringColumn(FileWriter fileWriter, int n) throws IOException {
        for (int i = 0; i < this.rowCount; ++i) {
            byte[] byArray = this.text[i][n].getBytes();
            for (int j = 0; j < byArray.length; ++j) {
                fileWriter.write(Integer.toString(byArray[j]) + "\n");
            }
            fileWriter.write("0\n");
        }
    }
}

