/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import java.util.List;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomLineMesh
extends CustomMesh {
    public static final int PAIRWISE = 0;
    public static final int CONTINUOUS = 1;
    public static final int SOLID = 0;
    public static final int DOT = 2;
    public static final int DASH = 1;
    public static final int DASH_DOT = 3;
    public static final int DEFAULT_MODE = 1;
    public static final int DEFAULT_PATTERN = 0;
    public static final float DEFAULT_LINEWIDTH = 1.0f;
    private int mode = 1;

    public CustomLineMesh(List<Point3f> list) {
        this(list, 1);
    }

    public CustomLineMesh(List<Point3f> list, int n) {
        this(list, n, DEFAULT_COLOR, 0.0f);
    }

    public CustomLineMesh(List<Point3f> list, int n, Color3f color3f, float f) {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        if (color3f != null) {
            this.color = color3f;
        }
        this.mesh = list;
        this.mode = n;
        this.transparency = f;
        this.update();
    }

    public void setPattern(int n) {
        this.getAppearance().getLineAttributes().setLinePattern(n);
    }

    public void setAntiAliasing(boolean bl) {
        this.getAppearance().getLineAttributes().setLineAntialiasingEnable(bl);
    }

    public void setLineWidth(float f) {
        this.getAppearance().getLineAttributes().setLineWidth(f);
    }

    @Override
    public float getVolume() {
        return 0.0f;
    }

    @Override
    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setCapability(10);
        appearance.setCapability(16);
        LineAttributes lineAttributes = new LineAttributes();
        lineAttributes.setCapability(5);
        lineAttributes.setCapability(3);
        lineAttributes.setCapability(1);
        lineAttributes.setLineWidth(1.0f);
        lineAttributes.setLinePattern(0);
        appearance.setLineAttributes(lineAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(3);
        polygonAttributes.setPolygonMode(2);
        polygonAttributes.setCullFace(1);
        polygonAttributes.setBackFaceNormalFlip(false);
        appearance.setPolygonAttributes(polygonAttributes);
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setShadeModel(3);
        coloringAttributes.setColor(this.color);
        appearance.setColoringAttributes(coloringAttributes);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        int n = this.transparency == 0.0f ? 4 : 0;
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        transparencyAttributes.setTransparencyMode(n);
        transparencyAttributes.setTransparency(this.transparency);
        appearance.setTransparencyAttributes(transparencyAttributes);
        Material material = new Material();
        material.setCapability(1);
        material.setAmbientColor(0.1f, 0.1f, 0.1f);
        material.setSpecularColor(0.1f, 0.1f, 0.1f);
        material.setDiffuseColor(0.1f, 0.1f, 0.1f);
        appearance.setMaterial(material);
        return appearance;
    }

    @Override
    protected Geometry createGeometry() {
        List list = this.mesh;
        Point3f[] point3fArray = list.toArray(new Point3f[0]);
        int n = point3fArray.length;
        Color3f[] color3fArray = new Color3f[n];
        for (int i = 0; i < n; ++i) {
            color3fArray[i] = this.color;
        }
        LineArray lineArray = null;
        if (this.mode == 0) {
            lineArray = new LineArray(n, 5);
        } else if (this.mode == 1) {
            lineArray = new LineStripArray(n, 5, new int[]{n});
        }
        lineArray.setCoordinates(0, point3fArray);
        lineArray.setColors(0, color3fArray);
        lineArray.setCapability(3);
        lineArray.setCapability(8);
        lineArray.setCapability(18);
        return lineArray;
    }
}

