/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import customnode.CustomMesh;
import isosurface.MeshProperties;
import java.util.List;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTriangleMesh
extends CustomMesh {
    private double volume = 0.0;

    public CustomTriangleMesh(List<Point3f> list) {
        this(list, DEFAULT_COLOR, 0.0f);
    }

    public CustomTriangleMesh(List<Point3f> list, Color3f color3f, float f) {
        super(list, color3f, f);
        if (list != null) {
            Point3d point3d = new Point3d();
            double[][] dArray = new double[3][3];
            this.volume = MeshProperties.compute(list, point3d, dArray);
        }
    }

    public void setMesh(List<Point3f> list) {
        this.mesh = list;
        this.update();
    }

    @Override
    protected Geometry createGeometry() {
        List list = this.mesh;
        Point3f[] point3fArray = list.toArray(new Point3f[0]);
        int n = point3fArray.length;
        Color3f[] color3fArray = new Color3f[n];
        for (int i = 0; i < n; ++i) {
            color3fArray[i] = this.color;
        }
        TriangleArray triangleArray = new TriangleArray(n, 7);
        triangleArray.setCoordinates(0, point3fArray);
        triangleArray.setColors(0, color3fArray);
        GeometryInfo geometryInfo = new GeometryInfo((GeometryArray)triangleArray);
        geometryInfo.recomputeIndices();
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        GeometryArray geometryArray = geometryInfo.getGeometryArray();
        geometryArray.setCapability(3);
        geometryArray.setCapability(8);
        geometryArray.setCapability(18);
        return geometryArray;
    }

    @Override
    public float getVolume() {
        return (float)this.volume;
    }
}

