/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

public class Pnt {
    private double[] coordinates;

    public Pnt(double[] dArray) {
        this.coordinates = new double[dArray.length];
        System.arraycopy(dArray, 0, this.coordinates, 0, dArray.length);
    }

    public Pnt(double d, double d2) {
        this(new double[]{d, d2});
    }

    public Pnt(double d, double d2, double d3) {
        this(new double[]{d, d2, d3});
    }

    public String toString() {
        if (this.coordinates.length == 0) {
            return "()";
        }
        String string = "Pnt(" + this.coordinates[0];
        for (int i = 1; i < this.coordinates.length; ++i) {
            string = string + "," + this.coordinates[i];
        }
        string = string + ")";
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pnt)) {
            return false;
        }
        Pnt pnt = (Pnt)object;
        if (this.coordinates.length != pnt.coordinates.length) {
            return false;
        }
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (this.coordinates[i] == pnt.coordinates[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.coordinates.length; ++i) {
            long l = Double.doubleToLongBits(this.coordinates[i]);
            n = 31 * n ^ (int)(l ^ l >> 32);
        }
        return n;
    }

    public double coord(int n) {
        return this.coordinates[n];
    }

    public int dimension() {
        return this.coordinates.length;
    }

    public int dimCheck(Pnt pnt) {
        int n = this.coordinates.length;
        if (n != pnt.coordinates.length) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        return n;
    }

    public Pnt extend(double[] dArray) {
        double[] dArray2 = new double[this.coordinates.length + dArray.length];
        System.arraycopy(this.coordinates, 0, dArray2, 0, this.coordinates.length);
        System.arraycopy(dArray, 0, dArray2, this.coordinates.length, dArray.length);
        return new Pnt(dArray2);
    }

    public double dot(Pnt pnt) {
        int n = this.dimCheck(pnt);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.coordinates[i] * pnt.coordinates[i];
        }
        return d;
    }

    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    public Pnt subtract(Pnt pnt) {
        int n = this.dimCheck(pnt);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coordinates[i] - pnt.coordinates[i];
        }
        return new Pnt(dArray);
    }

    public Pnt add(Pnt pnt) {
        int n = this.dimCheck(pnt);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coordinates[i] + pnt.coordinates[i];
        }
        return new Pnt(dArray);
    }

    public double angle(Pnt pnt) {
        return Math.acos(this.dot(pnt) / (this.magnitude() * pnt.magnitude()));
    }

    public Pnt bisector(Pnt pnt) {
        int n = this.dimCheck(pnt);
        Pnt pnt2 = this.subtract(pnt);
        Pnt pnt3 = this.add(pnt);
        double d = pnt2.dot(pnt3);
        return pnt2.extend(new double[]{-d / 2.0});
    }

    public static String toString(Pnt[] pntArray) {
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < pntArray.length; ++i) {
            stringBuffer.append(" " + pntArray[i]);
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static double determinant(Pnt[] pntArray) {
        if (pntArray.length != pntArray[0].dimension()) {
            throw new IllegalArgumentException("Matrix is not square");
        }
        boolean[] blArray = new boolean[pntArray.length];
        for (int i = 0; i < pntArray.length; ++i) {
            blArray[i] = true;
        }
        try {
            return Pnt.determinant(pntArray, 0, blArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
    }

    private static double determinant(Pnt[] pntArray, int n, boolean[] blArray) {
        if (n == pntArray.length) {
            return 1.0;
        }
        double d = 0.0;
        int n2 = 1;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            blArray[i] = false;
            d += (double)n2 * pntArray[n].coordinates[i] * Pnt.determinant(pntArray, n + 1, blArray);
            blArray[i] = true;
            n2 = -n2;
        }
        return d;
    }

    public static Pnt cross(Pnt[] pntArray) {
        int n = pntArray.length + 1;
        if (n != pntArray[0].dimension()) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = true;
        }
        double[] dArray = new double[n];
        int n2 = 1;
        try {
            for (int i = 0; i < n; ++i) {
                blArray[i] = false;
                dArray[i] = (double)n2 * Pnt.determinant(pntArray, 0, blArray);
                blArray[i] = true;
                n2 = -n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Matrix is wrong shape");
        }
        return new Pnt(dArray);
    }

    public static double content(Pnt[] pntArray) {
        int n;
        Pnt[] pntArray2 = new Pnt[pntArray.length];
        for (n = 0; n < pntArray2.length; ++n) {
            pntArray2[n] = pntArray[n].extend(new double[]{1.0});
        }
        n = 1;
        for (int i = 1; i < pntArray2.length; ++i) {
            n *= i;
        }
        return Pnt.determinant(pntArray2) / (double)n;
    }

    public int[] relation(Pnt[] pntArray) {
        int n;
        int n2;
        int n3 = pntArray.length - 1;
        if (this.dimension() != n3) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        Pnt[] pntArray2 = new Pnt[n3 + 1];
        double[] dArray = new double[n3 + 2];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = 1.0;
        }
        pntArray2[0] = new Pnt(dArray);
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[0] = this.coordinates[n2];
            for (int i = 0; i < pntArray.length; ++i) {
                dArray[i + 1] = pntArray[i].coordinates[n2];
            }
            pntArray2[n2 + 1] = new Pnt(dArray);
        }
        Pnt pnt = Pnt.cross(pntArray2);
        double d = pnt.coordinates[0];
        int[] nArray = new int[n3 + 1];
        for (n = 0; n < nArray.length; ++n) {
            double d2 = pnt.coordinates[n + 1];
            nArray[n] = Math.abs(d2) <= 1.0E-6 * Math.abs(d) ? 0 : (d2 < 0.0 ? -1 : 1);
        }
        if (d < 0.0) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = -nArray[n];
            }
        }
        if (d == 0.0) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = Math.abs(nArray[n]);
            }
        }
        return nArray;
    }

    public Pnt isOutside(Pnt[] pntArray) {
        int[] nArray = this.relation(pntArray);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            return pntArray[i];
        }
        return null;
    }

    public Pnt isOn(Pnt[] pntArray) {
        int[] nArray = this.relation(pntArray);
        Pnt pnt = null;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                pnt = pntArray[i];
                continue;
            }
            if (nArray[i] <= 0) continue;
            return null;
        }
        return pnt;
    }

    public boolean isInside(Pnt[] pntArray) {
        int[] nArray = this.relation(pntArray);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            return false;
        }
        return true;
    }

    public int vsCircumcircle(Pnt[] pntArray) {
        int n;
        Pnt[] pntArray2 = new Pnt[pntArray.length + 1];
        for (int i = 0; i < pntArray.length; ++i) {
            pntArray2[i] = pntArray[i].extend(new double[]{1.0, pntArray[i].dot(pntArray[i])});
        }
        pntArray2[pntArray.length] = this.extend(new double[]{1.0, this.dot(this)});
        double d = Pnt.determinant(pntArray2);
        int n2 = d < 0.0 ? -1 : (n = d > 0.0 ? 1 : 0);
        if (Pnt.content(pntArray) < 0.0) {
            n = -n;
        }
        return n;
    }

    public static Pnt circumcenter(Pnt[] pntArray) {
        int n = pntArray[0].dimension();
        if (pntArray.length - 1 != n) {
            throw new IllegalArgumentException("Dimension mismatch");
        }
        Pnt[] pntArray2 = new Pnt[n];
        for (int i = 0; i < n; ++i) {
            pntArray2[i] = pntArray[i].bisector(pntArray[i + 1]);
        }
        Pnt pnt = Pnt.cross(pntArray2);
        double d = pnt.coordinates[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = pnt.coordinates[i] / d;
        }
        return new Pnt(dArray);
    }

    public static void main(String[] stringArray) {
        Pnt pnt = new Pnt(1.0, 2.0, 3.0);
        System.out.println("Pnt created: " + pnt);
        Pnt[] pntArray = new Pnt[]{new Pnt(1.0, 2.0), new Pnt(3.0, 4.0)};
        Pnt[] pntArray2 = new Pnt[]{new Pnt(7.0, 0.0, 5.0), new Pnt(2.0, 4.0, 6.0), new Pnt(3.0, 8.0, 1.0)};
        System.out.print("Results should be -2 and -288: ");
        System.out.println(Pnt.determinant(pntArray) + " " + Pnt.determinant(pntArray2));
        Pnt pnt2 = new Pnt(1.0, 1.0);
        Pnt pnt3 = new Pnt(-1.0, 1.0);
        System.out.println("Angle between " + pnt2 + " and " + pnt3 + ": " + pnt2.angle(pnt3));
        System.out.println(pnt2 + " subtract " + pnt3 + ": " + pnt2.subtract(pnt3));
        Pnt pnt4 = new Pnt(0.0, 0.0);
        Pnt pnt5 = new Pnt(1.0, 1.0);
        Pnt pnt6 = new Pnt(2.0, 2.0);
        Pnt[] pntArray3 = new Pnt[]{pnt4, new Pnt(0.0, 1.0), new Pnt(1.0, 0.0)};
        Pnt pnt7 = new Pnt(0.1, 0.1);
        System.out.println(pnt7 + " isInside " + Pnt.toString(pntArray3) + ": " + pnt7.isInside(pntArray3));
        System.out.println(pnt5 + " isInside " + Pnt.toString(pntArray3) + ": " + pnt5.isInside(pntArray3));
        System.out.println(pnt7 + " vsCircumcircle " + Pnt.toString(pntArray3) + ": " + pnt7.vsCircumcircle(pntArray3));
        System.out.println(pnt5 + " vsCircumcircle " + Pnt.toString(pntArray3) + ": " + pnt5.vsCircumcircle(pntArray3));
        System.out.println(pnt6 + " vsCircumcircle " + Pnt.toString(pntArray3) + ": " + pnt6.vsCircumcircle(pntArray3));
        System.out.println("Circumcenter of " + Pnt.toString(pntArray3) + " is " + Pnt.circumcenter(pntArray3));
    }
}

