/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

import delaunay.Simplex;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Triangulation {
    private HashMap neighbors = new HashMap();

    public Triangulation(Simplex simplex) {
        this.neighbors.put(simplex, new HashSet());
    }

    public String toString() {
        return "Triangulation (with " + this.neighbors.size() + " elements)";
    }

    public int size() {
        return this.neighbors.size();
    }

    public boolean contains(Simplex simplex) {
        return this.neighbors.containsKey(simplex);
    }

    public Iterator iterator() {
        return Collections.unmodifiableSet(this.neighbors.keySet()).iterator();
    }

    public void printStuff() {
        boolean bl = Simplex.moreInfo;
        System.out.println("Neighbor data for " + this);
        for (Simplex simplex : this.neighbors.keySet()) {
            Simplex.moreInfo = true;
            System.out.print("    " + simplex + ":");
            Simplex.moreInfo = false;
            Iterator iterator = ((Set)this.neighbors.get(simplex)).iterator();
            while (iterator.hasNext()) {
                System.out.print(" " + iterator.next());
            }
            System.out.println();
        }
        Simplex.moreInfo = bl;
    }

    public Simplex neighborOpposite(Object object, Simplex simplex) {
        if (!simplex.contains(object)) {
            throw new IllegalArgumentException("Bad vertex; not in simplex");
        }
        block0: for (Simplex simplex2 : (Set)this.neighbors.get(simplex)) {
            for (Object e : simplex) {
                if (e.equals(object) || simplex2.contains(e)) continue;
                continue block0;
            }
            return simplex2;
        }
        return null;
    }

    public Set neighbors(Simplex simplex) {
        return new HashSet((Set)this.neighbors.get(simplex));
    }

    public void update(Set set, Set set2) {
        HashSet hashSet = new HashSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.addAll((Set)this.neighbors.get((Simplex)iterator.next()));
        }
        for (Simplex simplex : set) {
            Iterator iterator2 = ((Set)this.neighbors.get(simplex)).iterator();
            while (iterator2.hasNext()) {
                ((Set)this.neighbors.get(iterator2.next())).remove(simplex);
            }
            this.neighbors.remove(simplex);
            hashSet.remove(simplex);
        }
        hashSet.addAll(set2);
        iterator = set2.iterator();
        while (iterator.hasNext()) {
            this.neighbors.put((Simplex)iterator.next(), new HashSet());
        }
        for (Simplex simplex : set2) {
            for (Simplex simplex2 : hashSet) {
                if (!simplex.isNeighbor(simplex2)) continue;
                ((Set)this.neighbors.get(simplex)).add(simplex2);
                ((Set)this.neighbors.get(simplex2)).add(simplex);
            }
        }
    }
}

