/*
 * Decompiled with CFR 0.152.
 */
package distance;

import distance.PixelPairs;

public class MutualInformation
implements PixelPairs {
    private float minimum;
    private float maximum;
    private float width;
    long[] joint;
    private int count;
    private int bins;
    float h1;
    float h2;
    float h12;

    public MutualInformation(float f, float f2, int n) {
        this.minimum = f;
        this.maximum = f2;
        this.width = f2 - f;
        this.bins = n;
    }

    public MutualInformation() {
        this(0.0f, 255.0f, 256);
    }

    public void reset() {
        this.joint = new long[this.bins * this.bins];
        this.count = 0;
    }

    public void add(float f, float f2) {
        int n = (int)Math.floor((f - this.minimum) * (float)this.bins / this.width);
        int n2 = (int)Math.floor((f2 - this.minimum) * (float)this.bins / this.width);
        if (n >= this.bins) {
            n = this.bins - 1;
        }
        if (n2 >= this.bins) {
            n2 = this.bins - 1;
        }
        int n3 = n * this.bins + n2;
        this.joint[n3] = this.joint[n3] + 1L;
        ++this.count;
    }

    public float getEntropy1() {
        return this.h1;
    }

    public float getEntropy2() {
        return this.h2;
    }

    public float getJointEntropy() {
        return this.h12;
    }

    public float mutualInformation() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < this.bins; ++i) {
            long l = 0L;
            long l2 = 0L;
            for (int j = 0; j < this.bins; ++j) {
                float f4 = (float)this.joint[i * this.bins + j] / (float)this.count;
                if (f4 > 0.0f) {
                    f = (float)((double)f - (double)f4 * (Math.log(f4) / Math.log(2.0)));
                }
                l += this.joint[i * this.bins + j];
                l2 += this.joint[j * this.bins + i];
            }
            if (l > 0L) {
                float f5 = (float)l / (float)this.count;
                f2 = (float)((double)f2 - (double)f5 * (Math.log(f5) / Math.log(2.0)));
            }
            if (l2 <= 0L) continue;
            float f6 = (float)l2 / (float)this.count;
            f3 = (float)((double)f3 - (double)f6 * (Math.log(f6) / Math.log(2.0)));
        }
        this.h1 = f2;
        this.h2 = f3;
        this.h12 = f;
        return f2 + f3 - f;
    }

    public float distance() {
        float f = -this.mutualInformation();
        return f;
    }

    public void printJointMatrix() {
        for (int i = 0; i < this.bins; ++i) {
            for (int j = 0; j < this.bins; ++j) {
                System.out.println("[" + i + "," + j + "]: " + this.joint[i * this.bins + j]);
            }
        }
    }
}

