/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.RoiEvent;
import events.RoiListener;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.Roi;
import java.util.ArrayList;

public class RoiWatcher {
    public static final String MONITOR_LOC = "RoiWatcher.monitor";
    public static final long POLL_TIME = 10L;
    final ImagePlus data;

    public RoiWatcher(ImagePlus imagePlus) {
        this.data = imagePlus;
        if (imagePlus.getProperty(MONITOR_LOC) == null) {
            imagePlus.setProperty(MONITOR_LOC, (Object)new RoiMonitor(imagePlus));
        }
    }

    private RoiMonitor getMonitor() {
        return (RoiMonitor)this.data.getProperty(MONITOR_LOC);
    }

    public void addRoiListener(RoiListener roiListener) {
        this.getMonitor().addRoiListener(roiListener);
    }

    public boolean removeRoiListener(RoiListener roiListener) {
        return this.getMonitor().removeRoiListener(roiListener);
    }

    private static class RoiMonitor
    implements Runnable,
    ImageListener {
        final ImagePlus ip;
        final ArrayList<RoiListener> listeners = new ArrayList();
        Roi oldRoi;
        boolean run = true;
        Thread thread;

        public RoiMonitor(ImagePlus imagePlus) {
            this.ip = imagePlus;
            ImagePlus.addImageListener((ImageListener)this);
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void fireRoiChange(RoiEvent roiEvent) {
            System.out.println("roi change from " + this);
            for (RoiListener roiListener : this.listeners) {
                try {
                    roiListener.roiChanged(roiEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void addRoiListener(RoiListener roiListener) {
            this.listeners.add(roiListener);
        }

        public boolean removeRoiListener(RoiListener roiListener) {
            return this.listeners.remove(roiListener);
        }

        public void imageOpened(ImagePlus imagePlus) {
        }

        public void imageClosed(ImagePlus imagePlus) {
            if (imagePlus == this.ip) {
                imagePlus.getProperties().remove(RoiWatcher.MONITOR_LOC);
                this.listeners.clear();
                ImagePlus.removeImageListener((ImageListener)this);
            }
        }

        public void imageUpdated(ImagePlus imagePlus) {
            if (imagePlus == this.ip) {
                System.out.println("Image update, loading new ROI");
                this.oldRoi = this.ip.getRoi();
            }
        }

        public void run() {
            while (this.run) {
                Roi roi;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if ((roi = this.ip.getRoi()) == null && roi == null || (roi != null || roi == null) && roi.equals((Object)this.oldRoi)) continue;
                System.out.println("newRoi = " + roi);
                System.out.println("oldRoi = " + this.oldRoi);
                this.fireRoiChange(new RoiEvent(this.ip));
                this.oldRoi = roi;
            }
        }
    }
}

