/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.SliceEvent;
import events.SliceListener;
import ij.ImageListener;
import ij.ImagePlus;
import java.util.ArrayList;

public class SliceWatcher {
    public static final String MONITOR_LOC = "SliceWatcher.monitor";
    final ImagePlus data;

    public SliceWatcher(ImagePlus imagePlus) {
        this.data = imagePlus;
        if (imagePlus.getProperty(MONITOR_LOC) == null) {
            imagePlus.setProperty(MONITOR_LOC, (Object)new SliceMonitor(imagePlus));
        }
    }

    private SliceMonitor getMonitor() {
        return (SliceMonitor)this.data.getProperty(MONITOR_LOC);
    }

    public void addSliceListener(SliceListener sliceListener) {
        this.getMonitor().addSliceListener(sliceListener);
    }

    public boolean removeSliceListener(SliceListener sliceListener) {
        return this.getMonitor().removeSliceListener(sliceListener);
    }

    private static class SliceMonitor
    implements ImageListener {
        final ImagePlus ip;
        final ArrayList<SliceListener> listeners = new ArrayList();
        int lastSlicenumber;

        public SliceMonitor(ImagePlus imagePlus) {
            this.ip = imagePlus;
            ImagePlus.addImageListener((ImageListener)this);
        }

        public void fireSliceNumberChange(SliceEvent sliceEvent) {
            for (SliceListener sliceListener : this.listeners) {
                try {
                    sliceListener.sliceNumberChanged(sliceEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void addSliceListener(SliceListener sliceListener) {
            this.listeners.add(sliceListener);
        }

        public boolean removeSliceListener(SliceListener sliceListener) {
            return this.listeners.remove(sliceListener);
        }

        public void imageOpened(ImagePlus imagePlus) {
        }

        public void imageClosed(ImagePlus imagePlus) {
            if (imagePlus == this.ip) {
                imagePlus.getProperties().remove(SliceWatcher.MONITOR_LOC);
                this.listeners.clear();
                ImagePlus.removeImageListener((ImageListener)this);
            }
        }

        public void imageUpdated(ImagePlus imagePlus) {
            int n = this.ip.getCurrentSlice();
            if (n != this.lastSlicenumber) {
                this.fireSliceNumberChange(new SliceEvent(this.ip));
                this.lastSlicenumber = n;
            }
        }
    }
}

