/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.ComputeCurvatures;
import features.GaussianGenerationCallback;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public abstract class HessianEvalueProcessor
implements GaussianGenerationCallback {
    protected boolean normalize = false;
    protected double sigma = 1.0;
    protected boolean useCalibration = false;

    public void proportionDone(double d) {
        IJ.showProgress((double)d);
    }

    public abstract float measureFromEvalues2D(float[] var1);

    public abstract float measureFromEvalues3D(float[] var1);

    public void setSigma(double d) {
        this.sigma = d;
    }

    public ImagePlus generateImage(ImagePlus imagePlus) {
        Object object;
        Calibration calibration = imagePlus.getCalibration();
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (this.useCalibration && calibration != null) {
            f = (float)calibration.pixelWidth;
            f2 = (float)calibration.pixelHeight;
            f3 = (float)calibration.pixelDepth;
        }
        double d = Math.min(f, Math.min(f2, f));
        ComputeCurvatures computeCurvatures = new ComputeCurvatures(imagePlus, this.sigma, this, this.useCalibration);
        IJ.showStatus((String)("Convolving with Gaussian \u03c3=" + this.sigma + " (min. pixel separation: " + d + ")..."));
        computeCurvatures.run();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        ImageStack imageStack = new ImageStack(n, n2);
        float[] fArray = new float[3];
        IJ.showStatus((String)"Calculating Hessian eigenvalues at each point...");
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MIN_VALUE;
        if (n3 == 1) {
            object = new float[n * n2];
            for (int i = 1; i < n2 - 1; ++i) {
                for (int j = 1; j < n - 1; ++j) {
                    boolean bl = computeCurvatures.hessianEigenvaluesAtPoint2D(j, i, true, fArray, this.normalize, false, f, f2);
                    int n4 = i * n + j;
                    float f6 = 0.0f;
                    if (bl) {
                        f6 = this.measureFromEvalues2D(fArray);
                    }
                    object[n4] = f6;
                    if (f6 < f4) {
                        f4 = f6;
                    }
                    if (!(f6 > f5)) continue;
                    f5 = f6;
                }
                IJ.showProgress((double)(1.0 / (double)n2));
            }
            FloatProcessor floatProcessor = new FloatProcessor(n, n2);
            floatProcessor.setPixels(object);
            imageStack.addSlice(null, (ImageProcessor)floatProcessor);
        } else {
            for (int i = 0; i < n3; ++i) {
                float[] fArray2 = new float[n * n2];
                if (i >= 1 && i < n3 - 1) {
                    for (int j = 1; j < n2 - 1; ++j) {
                        for (int k = 1; k < n - 1; ++k) {
                            boolean bl = computeCurvatures.hessianEigenvaluesAtPoint3D(k, j, i, true, fArray, this.normalize, false, f, f2, f3);
                            int n5 = j * n + k;
                            float f7 = 0.0f;
                            if (bl) {
                                f7 = this.measureFromEvalues3D(fArray);
                            }
                            fArray2[n5] = f7;
                            if (f7 < f4) {
                                f4 = f7;
                            }
                            if (!(f7 > f5)) continue;
                            f5 = f7;
                        }
                    }
                }
                FloatProcessor floatProcessor = new FloatProcessor(n, n2);
                floatProcessor.setPixels((Object)fArray2);
                imageStack.addSlice(null, (ImageProcessor)floatProcessor);
                IJ.showProgress((double)((double)i / (double)n3));
            }
        }
        IJ.showProgress((double)1.0);
        object = new ImagePlus("processed " + imagePlus.getTitle(), imageStack);
        object.setCalibration(calibration);
        object.getProcessor().setMinAndMax((double)f4, (double)f5);
        object.updateAndDraw();
        return object;
    }
}

