/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.SurfacenessProcessor;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Surfaceness_
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.error((String)"No current image to calculate surfaceness of.");
            return;
        }
        if (imagePlus.getStackSize() == 1) {
            IJ.error((String)"It only makes sense to look for Sufaceness of 3D images (stacks)");
            return;
        }
        Calibration calibration = imagePlus.getCalibration();
        double d = 1.0;
        if (calibration != null) {
            d = Math.min(calibration.pixelWidth, Math.min(calibration.pixelHeight, calibration.pixelDepth));
        }
        GenericDialog genericDialog = new GenericDialog("\"Surfaceness\" Filter");
        genericDialog.addNumericField("Sigma: ", calibration == null ? 1.0 : d, 4);
        genericDialog.addMessage("(The default value for sigma is the pixel width.)");
        genericDialog.addCheckbox("Use calibration information", calibration != null);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        double d2 = genericDialog.getNextNumber();
        if (d2 <= 0.0) {
            IJ.error((String)"The value of sigma must be positive");
            return;
        }
        boolean bl = genericDialog.getNextBoolean();
        SurfacenessProcessor surfacenessProcessor = new SurfacenessProcessor(d2, bl);
        ImagePlus imagePlus2 = surfacenessProcessor.generateImage(imagePlus);
        imagePlus2.setTitle("surfaceness of " + imagePlus.getTitle());
        imagePlus2.show();
    }
}

