/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.image.IndexColorModel;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class ColorTable {
    public static String[] colorNames = new String[]{"None", "Black", "White", "Red", "Green", "Blue", "Cyan", "Magenta", "Yellow"};
    public static Color3f[] colors = new Color3f[]{null, new Color3f(0.0f, 0.0f, 0.0f), new Color3f(1.0f, 1.0f, 1.0f), new Color3f(1.0f, 0.0f, 0.0f), new Color3f(0.0f, 1.0f, 0.0f), new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.0f, 1.0f, 1.0f), new Color3f(1.0f, 0.0f, 1.0f), new Color3f(1.0f, 1.0f, 0.0f)};

    public static Color3f getColor(String string) {
        for (int i = 0; i < colors.length; ++i) {
            if (!colorNames[i].equals(string)) continue;
            return colors[i];
        }
        return null;
    }

    public static boolean isRedCh(String string) {
        return string.equals("White") || string.equals("Red") || string.equals("Magenta") || string.equals("Yellow");
    }

    public static boolean isGreenCh(String string) {
        return string.equals("White") || string.equals("Green") || string.equals("Cyan") || string.equals("Yellow");
    }

    public static boolean isBlueCh(String string) {
        return string.equals("White") || string.equals("Blue") || string.equals("Cyan") || string.equals("Magenta");
    }

    public static String getColorName(Color3f color3f) {
        for (int i = 1; i < colors.length; ++i) {
            if (!colors[i].equals((Tuple3f)color3f)) continue;
            return colorNames[i];
        }
        return "None";
    }

    public static int getHistogramMax(ImagePlus imagePlus) {
        int n;
        int n2;
        int n3 = imagePlus.getStackSize();
        int[] nArray = new int[256];
        for (n2 = 0; n2 < n3; ++n2) {
            int[] nArray2 = imagePlus.getStack().getProcessor(n2 + 1).getHistogram();
            for (n = 0; n < nArray.length; ++n) {
                int n4 = n;
                nArray[n4] = nArray[n4] + nArray2[n];
            }
        }
        n2 = -1;
        int n5 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] <= n2) continue;
            n2 = nArray[n];
            n5 = n;
        }
        return n5;
    }

    public static IndexColorModel getOpaqueIndexedColorModel(ImagePlus imagePlus, boolean[] blArray) {
        IndexColorModel indexColorModel = (IndexColorModel)imagePlus.getProcessor().getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < n; ++i) {
            byArray[i] = blArray[0] ? byArray[i] : (byte)0;
            byArray2[i] = blArray[1] ? byArray2[i] : (byte)0;
            byArray3[i] = blArray[2] ? byArray3[i] : (byte)0;
        }
        IndexColorModel indexColorModel2 = new IndexColorModel(8, n, byArray, byArray2, byArray3);
        return indexColorModel2;
    }

    public static IndexColorModel getIndexedColorModel(ImagePlus imagePlus, boolean[] blArray) {
        IndexColorModel indexColorModel = (IndexColorModel)imagePlus.getProcessor().getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int n2 = ColorTable.getHistogramMax(imagePlus);
        int[] nArray = new int[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
            if (blArray[0]) {
                int n4 = i;
                nArray[n4] = nArray[n4] + (byArray[i] & 0xFF);
            }
            if (blArray[1]) {
                int n5 = i;
                nArray[n5] = nArray[n5] + (byArray2[i] & 0xFF);
            }
            if (blArray[2]) {
                int n6 = i;
                nArray[n6] = nArray[n6] + (byArray3[i] & 0xFF);
            }
            n3 = nArray[i] > n3 ? nArray[i] : n3;
        }
        float f = 255.0f / (float)n3;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(f * (float)nArray[i]);
            byArray[i] = blArray[0] ? byArray[i] : (byte)0;
            byArray2[i] = blArray[1] ? byArray2[i] : (byte)0;
            byArray3[i] = blArray[2] ? byArray3[i] : (byte)0;
            byArray4[i] = by;
        }
        byArray4[n2] = 0;
        IndexColorModel indexColorModel2 = new IndexColorModel(8, n, byArray, byArray2, byArray3, byArray4);
        return indexColorModel2;
    }

    public static IndexColorModel getOpaqueAverageGrayColorModel(ImagePlus imagePlus, boolean[] blArray) {
        IndexColorModel indexColorModel = (IndexColorModel)imagePlus.getProcessor().getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
            if (blArray[0]) {
                int n3 = i;
                nArray[n3] = nArray[n3] + (byArray[i] & 0xFF);
            }
            if (blArray[1]) {
                int n4 = i;
                nArray[n4] = nArray[n4] + (byArray2[i] & 0xFF);
            }
            if (blArray[2]) {
                int n5 = i;
                nArray[n5] = nArray[n5] + (byArray3[i] & 0xFF);
            }
            n2 = nArray[i] > n2 ? nArray[i] : n2;
        }
        float f = 255.0f / (float)n2;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(f * (float)nArray[i]);
            float f2 = (float)nArray[i] / (float)n2;
            byArray[i] = by;
            byArray2[i] = by;
            byArray3[i] = by;
        }
        IndexColorModel indexColorModel2 = new IndexColorModel(8, n, byArray, byArray2, byArray3);
        return indexColorModel2;
    }

    public static IndexColorModel getAverageGrayColorModel(ImagePlus imagePlus, boolean[] blArray) {
        IndexColorModel indexColorModel = (IndexColorModel)imagePlus.getProcessor().getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        int n2 = ColorTable.getHistogramMax(imagePlus);
        int[] nArray = new int[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
            if (blArray[0]) {
                int n4 = i;
                nArray[n4] = nArray[n4] + (byArray[i] & 0xFF);
            }
            if (blArray[1]) {
                int n5 = i;
                nArray[n5] = nArray[n5] + (byArray2[i] & 0xFF);
            }
            if (blArray[2]) {
                int n6 = i;
                nArray[n6] = nArray[n6] + (byArray3[i] & 0xFF);
            }
            n3 = nArray[i] > n3 ? nArray[i] : n3;
        }
        float f = 255.0f / (float)n3;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(f * (float)nArray[i]);
            float f2 = (float)nArray[i] / (float)n3;
            byArray[i] = by;
            byArray2[i] = by;
            byArray3[i] = by;
            byArray4[i] = by;
        }
        byArray4[n2] = 0;
        IndexColorModel indexColorModel2 = new IndexColorModel(8, n, byArray, byArray2, byArray3, byArray4);
        return indexColorModel2;
    }

    public static ImagePlus adjustChannels(ImagePlus imagePlus, boolean[] blArray) {
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        int[] nArray = new int[3];
        IndexColorModel indexColorModel = (IndexColorModel)imagePlus.getProcessor().getColorModel();
        int n4 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        float f = 0.0f;
        for (int i = 0; i < 3; ++i) {
            if (!blArray[i]) continue;
            nArray[i] = 1;
            f += 1.0f;
        }
        ImageStack imageStack = new ImageStack(n, n2);
        for (int i = 0; i < n3; ++i) {
            byte[] byArray4 = (byte[])imagePlus.getStack().getProcessor(i + 1).getPixels();
            byte[] byArray5 = new byte[n * n2];
            for (int j = 0; j < n * n2; ++j) {
                int n5 = byArray4[j] & 0xFF;
                int n6 = nArray[0] * (byArray[n5] & 0xFF) + nArray[1] * (byArray2[n5] & 0xFF) + nArray[2] * (byArray3[n5] & 0xFF);
                byArray5[j] = (byte)((float)n6 / f);
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(n, n2, byArray5, null));
        }
        ImagePlus imagePlus2 = new ImagePlus(imagePlus.getTitle(), imageStack);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }

    public static void debug(IndexColorModel indexColorModel) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        for (int i = 0; i < 256; ++i) {
            System.out.println((byArray[i] & 0xFF) + "\t" + (byArray2[i] & 0xFF) + "\t" + (byArray3[i] & 0xFF));
        }
    }
}

