/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.UniverseListener;
import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Vector3d;

public abstract class DefaultAnimatableUniverse
extends DefaultUniverse {
    private Vector3d rotationAxis = new Vector3d(0.0, 1.0, 0.0);
    private Transform3D centerXform = new Transform3D();
    private Transform3D animationXform = new Transform3D();
    private Transform3D rotationXform = new Transform3D();
    private Transform3D rotate = new Transform3D();
    private Transform3D centerXformInv = new Transform3D();
    private boolean rotateAroundViewAxis = true;
    private RotationInterpolator rotpol;
    private Alpha animation;
    private TransformGroup animationTG;
    private TransformGroup rotationTG;
    private ImageStack freehandStack;
    private Vector3d v1 = new Vector3d();
    private Vector3d v2 = new Vector3d();
    private AxisAngle4d aa = new AxisAngle4d();

    public DefaultAnimatableUniverse(int n, int n2) {
        super(n, n2);
        this.animationTG = this.getAnimationTG();
        this.rotationTG = this.getRotationTG();
        this.updateRotationAxisAndCenter();
        this.animation = new Alpha(-1, 4000L);
        this.animation.pause();
        this.animation.setStartTime(System.currentTimeMillis());
        BranchGroup branchGroup = new BranchGroup();
        this.rotpol = new RotationInterpolator(this.animation, this.animationTG){

            public void processStimulus(Enumeration enumeration) {
                super.processStimulus(enumeration);
                if (!DefaultAnimatableUniverse.this.animation.isPaused()) {
                    DefaultAnimatableUniverse.this.fireTransformationUpdated();
                } else {
                    DefaultAnimatableUniverse.this.animationPaused();
                }
            }
        };
        this.rotpol.setTransformAxis(this.centerXform);
        this.rotpol.setSchedulingBounds((Bounds)this.bounds);
        this.rotpol.setEnable(false);
        branchGroup.addChild((Node)this.rotpol);
        this.animationTG.addChild((Node)branchGroup);
        this.addUniverseListener(new UniverseListener(){

            public void transformationStarted(View view) {
            }

            public void transformationFinished(View view) {
            }

            public void contentAdded(Content content) {
            }

            public void contentRemoved(Content content) {
            }

            public void canvasResized() {
            }

            public void universeClosed() {
            }

            public void contentSelected(Content content) {
            }

            public void transformationUpdated(View view) {
                DefaultAnimatableUniverse.this.addFreehandRecordingFrame();
            }

            public void contentChanged(Content content) {
                DefaultAnimatableUniverse.this.addFreehandRecordingFrame();
            }
        });
    }

    private void addFreehandRecordingFrame() {
        if (this.freehandStack == null) {
            return;
        }
        this.win.updateImagePlus();
        ImageProcessor imageProcessor = this.win.getImagePlus().getProcessor();
        this.freehandStack.addSlice("", imageProcessor);
    }

    public void startFreehandRecording() {
        if (this.freehandStack != null) {
            return;
        }
        ImageProcessor imageProcessor = this.win.getImagePlus().getProcessor();
        this.freehandStack = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight());
    }

    public ImagePlus stopFreehandRecording() {
        if (this.freehandStack == null || this.freehandStack.getSize() == 0) {
            return null;
        }
        ImagePlus imagePlus = new ImagePlus("Movie", this.freehandStack);
        this.freehandStack = null;
        return imagePlus;
    }

    public ImagePlus record360() {
        if (this.freehandStack != null) {
            IJ.error((String)"Freehand recording is active. Stop first.");
            return null;
        }
        if (!this.animation.isPaused()) {
            this.pauseAnimation();
        }
        ImageProcessor imageProcessor = this.win.getImagePlus().getProcessor();
        ImageStack imageStack = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight());
        this.updateRotationAxisAndCenter();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.centerXformInv.invert(this.centerXform);
        double d = Math.PI / 90;
        int n = (int)Math.round(Math.PI * 2 / d);
        this.getCanvas().getView().stopView();
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 = (double)i * d;
            this.rotationXform.rotY(d2);
            this.rotate.mul(this.centerXform, this.rotationXform);
            this.rotate.mul(this.rotate, this.centerXformInv);
            this.animationTG.setTransform(this.rotate);
            this.fireTransformationUpdated();
            this.getCanvas().getView().renderOnce();
            this.win.updateImagePlusAndWait();
            imageProcessor = this.win.getImagePlus().getProcessor();
            int n2 = imageProcessor.getWidth();
            int n3 = imageProcessor.getHeight();
            if (imageStack == null) {
                imageStack = new ImageStack(n2, n3);
            }
            imageStack.addSlice("", imageProcessor);
        }
        this.getCanvas().getView().startView();
        this.incorporateAnimationInRotation();
        if (imageStack.getSize() == 0) {
            return null;
        }
        ImagePlus imagePlus = new ImagePlus("Movie", imageStack);
        return imagePlus;
    }

    public void rotateX(double d) {
        this.viewTransformer.rotateX(d);
    }

    public void rotateY(double d) {
        this.viewTransformer.rotateY(d);
        this.fireTransformationUpdated();
    }

    public void rotateZ(double d) {
        this.viewTransformer.rotateZ(d);
    }

    public void startAnimation() {
        this.animationTG.getTransform(this.animationXform);
        this.updateRotationAxisAndCenter();
        this.rotpol.setTransformAxis(this.centerXform);
        this.rotpol.setEnable(true);
        this.animation.resume();
        this.fireTransformationStarted();
    }

    public void pauseAnimation() {
        this.animation.pause();
    }

    private void animationPaused() {
        this.rotpol.setEnable(false);
        this.incorporateAnimationInRotation();
        this.animation.setStartTime(System.currentTimeMillis());
        this.fireTransformationUpdated();
        this.fireTransformationFinished();
    }

    private void incorporateAnimationInRotation() {
        this.rotationTG.getTransform(this.rotationXform);
        this.animationTG.getTransform(this.animationXform);
        this.rotationXform.mul(this.rotationXform, this.animationXform);
        this.animationXform.setIdentity();
        this.animationTG.setTransform(this.animationXform);
        this.rotationTG.setTransform(this.rotationXform);
    }

    private void updateRotationAxisAndCenter() {
        this.v1.set(0.0, 1.0, 0.0);
        this.v2.cross(this.v1, this.rotationAxis);
        double d = Math.acos(this.v1.dot(this.rotationAxis));
        this.aa.set(this.v2, d);
        this.centerXform.set(this.aa);
    }
}

