/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.ImagePlus;
import ij3d.Content;
import ij3d.Executer;
import ij3d.Image3DUniverse;
import ij3d.UniverseListener;
import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.media.j3d.View;

public class Image3DMenubar
extends MenuBar
implements ActionListener,
ItemListener,
UniverseListener {
    private Image3DUniverse univ;
    private Executer executer;
    private MenuItem add;
    private MenuItem importObj;
    private MenuItem color;
    private MenuItem bgColor;
    private MenuItem channels;
    private MenuItem transparency;
    private MenuItem threshold;
    private MenuItem fill;
    private MenuItem slices;
    private MenuItem delete;
    private MenuItem properties;
    private MenuItem resetView;
    private MenuItem record360;
    private MenuItem startRecord;
    private MenuItem stopRecord;
    private MenuItem startAnimation;
    private MenuItem stopAnimation;
    private MenuItem viewPreferences;
    private MenuItem close;
    private MenuItem setTransform;
    private MenuItem resetTransform;
    private MenuItem applyTransform;
    private MenuItem saveTransform;
    private MenuItem exportTransformed;
    private MenuItem exportObj;
    private MenuItem exportDXF;
    private MenuItem smoothMesh;
    private MenuItem scalebar;
    private MenuItem smoothAllMeshes;
    private MenuItem displayAsVolume;
    private MenuItem displayAsOrtho;
    private MenuItem displayAsSurface;
    private MenuItem displayAsSurfacePlot;
    private MenuItem centerSelected;
    private MenuItem centerOrigin;
    private MenuItem centerUniverse;
    private MenuItem fitViewToUniverse;
    private MenuItem fitViewToContent;
    private MenuItem regist;
    private CheckboxMenuItem shaded;
    private MenuItem pl_load;
    private MenuItem pl_save;
    private MenuItem pl_size;
    private CheckboxMenuItem pl_show;
    private MenuItem j3dproperties;
    private MenuItem viewer4d;
    private CheckboxMenuItem coordinateSystem;
    private CheckboxMenuItem allCoordinateSystems;
    private CheckboxMenuItem lock;
    private CheckboxMenuItem show;
    private Menu transformMenu;
    private Menu editMenu;
    private Menu selectMenu;
    private Menu viewMenu;
    private Menu fileMenu;
    private Menu helpMenu;
    private SelectionListener selListener = new SelectionListener();

    public Image3DMenubar(Image3DUniverse image3DUniverse) {
        this.univ = image3DUniverse;
        this.executer = image3DUniverse.getExecuter();
        image3DUniverse.addUniverseListener(this);
        this.fileMenu = this.createFileMenu();
        this.add(this.fileMenu);
        this.editMenu = this.createEditMenu();
        this.add(this.editMenu);
        this.selectMenu = this.createSelectMenu();
        this.add(this.selectMenu);
        this.transformMenu = this.createTransformMenu();
        this.add(this.transformMenu);
        this.viewMenu = this.createViewMenu();
        this.add(this.viewMenu);
        this.helpMenu = this.createHelpMenu();
        this.add(this.helpMenu);
        this.setHelpMenu(this.helpMenu);
        this.contentSelected(null);
    }

    public Menu createFileMenu() {
        Menu menu = new Menu("File");
        this.add = new MenuItem("Add content");
        this.add.addActionListener(this);
        menu.add(this.add);
        this.importObj = new MenuItem("Import WaveFront");
        this.importObj.addActionListener(this);
        menu.add(this.importObj);
        this.delete = new MenuItem("Delete");
        this.delete.setEnabled(false);
        this.delete.addActionListener(this);
        menu.add(this.delete);
        menu.addSeparator();
        this.viewer4d = new MenuItem("Load 4D data");
        this.viewer4d.addActionListener(this);
        menu.add(this.viewer4d);
        menu.addSeparator();
        Menu menu2 = new Menu("Export surfaces as");
        menu.add(menu2);
        this.exportObj = new MenuItem("WaveFront");
        this.exportObj.addActionListener(this);
        menu2.add(this.exportObj);
        this.exportDXF = new MenuItem("DXF");
        this.exportDXF.addActionListener(this);
        menu2.add(this.exportDXF);
        menu.addSeparator();
        this.close = new MenuItem("Quit");
        this.close.addActionListener(this);
        menu.add(this.close);
        return menu;
    }

    public Menu createEditMenu() {
        Menu menu = new Menu("Edit");
        this.slices = new MenuItem("Adjust slices");
        this.slices.addActionListener(this);
        menu.add(this.slices);
        this.fill = new MenuItem("Fill selection");
        this.fill.addActionListener(this);
        menu.add(this.fill);
        this.smoothMesh = new MenuItem("Smooth mesh");
        this.smoothMesh.addActionListener(this);
        menu.add(this.smoothMesh);
        this.smoothAllMeshes = new MenuItem("Smooth all meshes");
        this.smoothAllMeshes.addActionListener(this);
        menu.add(this.smoothAllMeshes);
        menu.addSeparator();
        menu.add(this.createDisplayAsSubMenu());
        menu.add(this.createAttributesSubMenu());
        menu.add(this.createHideSubMenu());
        menu.add(this.createPLSubMenu());
        menu.addSeparator();
        this.regist = new MenuItem("Register");
        this.regist.addActionListener(this);
        menu.add(this.regist);
        menu.addSeparator();
        this.properties = new MenuItem("Object Properties");
        this.properties.addActionListener(this);
        menu.add(this.properties);
        return menu;
    }

    public Menu createSelectMenu() {
        Menu menu = new Menu("Select");
        if (this.univ == null) {
            return menu;
        }
        Iterator iterator = this.univ.contents();
        while (iterator.hasNext()) {
            String string = ((Content)iterator.next()).getName();
            MenuItem menuItem = new MenuItem(string);
            menuItem.addActionListener(this.selListener);
        }
        return menu;
    }

    public Menu createTransformMenu() {
        Menu menu = new Menu("Transformation");
        this.lock = new CheckboxMenuItem("Lock");
        this.lock.addItemListener(this);
        menu.add(this.lock);
        this.setTransform = new MenuItem("Set Transform");
        this.setTransform.addActionListener(this);
        menu.add(this.setTransform);
        this.resetTransform = new MenuItem("Reset Transform");
        this.resetTransform.addActionListener(this);
        menu.add(this.resetTransform);
        this.applyTransform = new MenuItem("Apply Transform");
        this.applyTransform.addActionListener(this);
        menu.add(this.applyTransform);
        this.saveTransform = new MenuItem("Save Transform");
        this.saveTransform.addActionListener(this);
        menu.add(this.saveTransform);
        menu.addSeparator();
        this.exportTransformed = new MenuItem("Export transformed image");
        this.exportTransformed.addActionListener(this);
        menu.add(this.exportTransformed);
        return menu;
    }

    public Menu createViewMenu() {
        Menu menu = new Menu("View");
        this.resetView = new MenuItem("Reset view");
        this.resetView.addActionListener(this);
        menu.add(this.resetView);
        Menu menu2 = new Menu("Center");
        this.centerSelected = new MenuItem("Selected content");
        this.centerSelected.addActionListener(this);
        menu2.add(this.centerSelected);
        this.centerOrigin = new MenuItem("Origin");
        this.centerOrigin.addActionListener(this);
        menu2.add(this.centerOrigin);
        this.centerUniverse = new MenuItem("Universe");
        this.centerUniverse.addActionListener(this);
        menu2.add(this.centerUniverse);
        menu.add(menu2);
        menu2 = new Menu("Fit view to");
        this.fitViewToUniverse = new MenuItem("Universe");
        this.fitViewToUniverse.addActionListener(this);
        menu2.add(this.fitViewToUniverse);
        this.fitViewToContent = new MenuItem("Selected content");
        this.fitViewToContent.addActionListener(this);
        menu2.add(this.fitViewToContent);
        menu.add(menu2);
        menu.addSeparator();
        this.record360 = new MenuItem("Record 360 deg rotation");
        this.record360.addActionListener(this);
        menu.add(this.record360);
        this.startRecord = new MenuItem("Start freehand recording");
        this.startRecord.addActionListener(this);
        menu.add(this.startRecord);
        this.stopRecord = new MenuItem("Stop freehand recording");
        this.stopRecord.addActionListener(this);
        menu.add(this.stopRecord);
        menu.addSeparator();
        this.startAnimation = new MenuItem("Start animation");
        this.startAnimation.addActionListener(this);
        menu.add(this.startAnimation);
        this.stopAnimation = new MenuItem("Stop animation");
        this.stopAnimation.addActionListener(this);
        menu.add(this.stopAnimation);
        menu.addSeparator();
        this.scalebar = new MenuItem("Edit Scalebar");
        this.scalebar.addActionListener(this);
        menu.add(this.scalebar);
        menu.addSeparator();
        this.viewPreferences = new MenuItem("View Preferences");
        this.viewPreferences.addActionListener(this);
        menu.add(this.viewPreferences);
        this.bgColor = new MenuItem("Change background color");
        this.bgColor.addActionListener(this);
        menu.add(this.bgColor);
        return menu;
    }

    public Menu createHelpMenu() {
        Menu menu = new Menu("Help");
        this.j3dproperties = new MenuItem("Java 3D Properties");
        this.j3dproperties.addActionListener(this);
        menu.add(this.j3dproperties);
        return menu;
    }

    public Menu createPLSubMenu() {
        Menu menu = new Menu("Point list");
        if (this.univ == null) {
            return menu;
        }
        this.pl_load = new MenuItem("Load Point List");
        this.pl_load.addActionListener(this);
        menu.add(this.pl_load);
        this.pl_save = new MenuItem("Save Point List");
        this.pl_save.addActionListener(this);
        menu.add(this.pl_save);
        this.pl_show = new CheckboxMenuItem("Show Point List");
        this.pl_show.addItemListener(this);
        menu.add(this.pl_show);
        menu.addSeparator();
        this.pl_size = new MenuItem("Point size");
        this.pl_size.addActionListener(this);
        menu.add(this.pl_size);
        return menu;
    }

    public Menu createHideSubMenu() {
        Menu menu = new Menu("Hide/Show");
        this.show = new CheckboxMenuItem("Show content");
        this.show.setState(true);
        this.show.addItemListener(this);
        menu.add(this.show);
        this.coordinateSystem = new CheckboxMenuItem("Show coordinate system", true);
        this.coordinateSystem.addItemListener(this);
        menu.add(this.coordinateSystem);
        this.allCoordinateSystems = new CheckboxMenuItem("Show all coordinate systems", true);
        this.allCoordinateSystems.addItemListener(this);
        menu.add(this.allCoordinateSystems);
        return menu;
    }

    public Menu createAttributesSubMenu() {
        Menu menu = new Menu("Attributes");
        this.channels = new MenuItem("Change channels");
        this.channels.addActionListener(this);
        menu.add(this.channels);
        this.color = new MenuItem("Change color");
        this.color.addActionListener(this);
        menu.add(this.color);
        this.transparency = new MenuItem("Change transparency");
        this.transparency.addActionListener(this);
        menu.add(this.transparency);
        this.threshold = new MenuItem("Adjust threshold");
        this.threshold.addActionListener(this);
        menu.add(this.threshold);
        this.shaded = new CheckboxMenuItem("Shade surface");
        this.shaded.setState(true);
        this.shaded.addItemListener(this);
        menu.add(this.shaded);
        return menu;
    }

    public Menu createDisplayAsSubMenu() {
        Menu menu = new Menu("Display as");
        this.displayAsVolume = new MenuItem("Volume");
        this.displayAsVolume.addActionListener(this);
        menu.add(this.displayAsVolume);
        this.displayAsOrtho = new MenuItem("Orthoslice");
        this.displayAsOrtho.addActionListener(this);
        menu.add(this.displayAsOrtho);
        this.displayAsSurface = new MenuItem("Surface");
        this.displayAsSurface.addActionListener(this);
        menu.add(this.displayAsSurface);
        this.displayAsSurfacePlot = new MenuItem("Surface Plot 2D");
        this.displayAsSurfacePlot.addActionListener(this);
        menu.add(this.displayAsSurfacePlot);
        return menu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.color) {
            this.executer.changeColor(this.univ.getSelected());
        } else if (object == this.bgColor) {
            this.executer.changeBackgroundColor();
        } else if (object == this.scalebar) {
            this.executer.editScalebar();
        } else if (object == this.viewer4d) {
            this.executer.load4D();
        } else if (object == this.channels) {
            this.executer.changeChannels(this.univ.getSelected());
        } else if (object == this.transparency) {
            this.executer.changeTransparency(this.univ.getSelected());
        } else if (object == this.add) {
            this.executer.addContent(null, -1);
        } else if (object == this.regist) {
            this.executer.register();
        } else if (object == this.delete) {
            this.executer.delete(this.univ.getSelected());
        } else if (object == this.resetView) {
            this.executer.resetView();
        } else if (object == this.centerSelected) {
            this.executer.centerSelected(this.univ.getSelected());
        } else if (object == this.centerOrigin) {
            this.executer.centerOrigin();
        } else if (object == this.centerUniverse) {
            this.executer.centerUniverse();
        } else if (object == this.fitViewToUniverse) {
            this.executer.fitViewToUniverse();
        } else if (object == this.fitViewToContent) {
            this.executer.fitViewToContent(this.univ.getSelected());
        } else if (object == this.record360) {
            this.executer.record360();
        } else if (object == this.startRecord) {
            this.executer.startFreehandRecording();
        } else if (object == this.stopRecord) {
            this.executer.stopFreehandRecording();
        } else if (object == this.startAnimation) {
            this.executer.startAnimation();
        } else if (object == this.stopAnimation) {
            this.executer.stopAnimation();
        } else if (object == this.threshold) {
            this.executer.changeThreshold(this.univ.getSelected());
        } else if (object == this.displayAsVolume) {
            this.executer.displayAs(this.univ.getSelected(), 0);
        } else if (object == this.displayAsOrtho) {
            this.executer.displayAs(this.univ.getSelected(), 1);
        } else if (object == this.displayAsSurface) {
            this.executer.displayAs(this.univ.getSelected(), 2);
        } else if (object == this.displayAsSurfacePlot) {
            this.executer.displayAs(this.univ.getSelected(), 3);
        } else if (object == this.slices) {
            this.executer.changeSlices(this.univ.getSelected());
        } else if (object == this.fill) {
            this.executer.fill(this.univ.getSelected());
        } else if (object == this.close) {
            this.executer.close();
        } else if (object == this.resetTransform) {
            this.executer.resetTransform(this.univ.getSelected());
        } else if (object == this.setTransform) {
            this.executer.setTransform(this.univ.getSelected());
        } else if (object == this.properties) {
            this.executer.contentProperties(this.univ.getSelected());
        } else if (object == this.applyTransform) {
            this.executer.applyTransform(this.univ.getSelected());
        } else if (object == this.saveTransform) {
            this.executer.saveTransform(this.univ.getSelected());
        } else if (object == this.exportTransformed) {
            this.executer.exportTransformed(this.univ.getSelected());
        } else if (object == this.pl_load) {
            this.executer.loadPointList(this.univ.getSelected());
        } else if (object == this.pl_save) {
            this.executer.savePointList(this.univ.getSelected());
        } else if (object == this.pl_size) {
            this.executer.changePointSize(this.univ.getSelected());
        } else if (object == this.importObj) {
            this.executer.importWaveFront();
        } else if (object == this.exportDXF) {
            this.executer.saveAsDXF();
        } else if (object == this.exportObj) {
            this.executer.saveAsWaveFront();
        } else if (object == this.smoothMesh) {
            this.executer.smoothMesh(this.univ.getSelected());
        } else if (object == this.smoothAllMeshes) {
            this.executer.smoothAllMeshes();
        } else if (object == this.viewPreferences) {
            this.executer.viewPreferences();
        } else if (object == this.j3dproperties) {
            this.executer.j3dproperties();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        Content content = this.univ.getSelected();
        if (object == this.coordinateSystem) {
            this.executer.showCoordinateSystem(content, this.coordinateSystem.getState());
        } else if (object == this.allCoordinateSystems) {
            this.executer.showAllCoordinateSystems(this.allCoordinateSystems.getState());
        } else if (object == this.show) {
            this.executer.showContent(content, this.show.getState());
        } else if (object == this.lock) {
            this.executer.setLocked(content, this.lock.getState());
        } else if (object == this.shaded) {
            this.executer.setShaded(content, this.shaded.getState());
        } else if (object == this.pl_show) {
            this.executer.showPointList(content, this.pl_show.getState());
        }
    }

    public void transformationStarted(View view) {
    }

    public void transformationFinished(View view) {
    }

    public void canvasResized() {
    }

    public void transformationUpdated(View view) {
    }

    public void contentChanged(Content content) {
    }

    public void universeClosed() {
    }

    public void contentAdded(Content content) {
        if (content == null) {
            return;
        }
        MenuItem menuItem = new MenuItem(content.getName());
        menuItem.addActionListener(this.selListener);
        this.selectMenu.add(menuItem);
    }

    public void contentRemoved(Content content) {
        if (content == null) {
            return;
        }
        for (int i = 0; i < this.selectMenu.getItemCount(); ++i) {
            MenuItem menuItem = this.selectMenu.getItem(i);
            if (!menuItem.getLabel().equals(content.getName())) continue;
            this.selectMenu.remove(i);
            return;
        }
    }

    public void contentSelected(Content content) {
        this.delete.setEnabled(content != null);
        this.centerSelected.setEnabled(content != null);
        this.fill.setEnabled(content != null);
        this.smoothMesh.setEnabled(content != null);
        this.displayAsVolume.setEnabled(content != null);
        this.displayAsSurface.setEnabled(content != null);
        this.displayAsSurfacePlot.setEnabled(content != null);
        this.displayAsOrtho.setEnabled(content != null);
        this.properties.setEnabled(content != null);
        this.color.setEnabled(content != null);
        this.transparency.setEnabled(content != null);
        this.threshold.setEnabled(content != null);
        this.channels.setEnabled(content != null);
        this.shaded.setEnabled(content != null);
        this.show.setEnabled(content != null);
        this.coordinateSystem.setEnabled(content != null);
        this.pl_load.setEnabled(content != null);
        this.pl_save.setEnabled(content != null);
        this.pl_show.setEnabled(content != null);
        this.pl_size.setEnabled(content != null);
        this.lock.setEnabled(content != null);
        this.setTransform.setEnabled(content != null);
        this.applyTransform.setEnabled(content != null);
        this.resetTransform.setEnabled(content != null);
        this.saveTransform.setEnabled(content != null);
        this.exportTransformed.setEnabled(content != null);
        if (content == null) {
            return;
        }
        int n = content.getType();
        this.slices.setEnabled(n == 1);
        this.fill.setEnabled(n == 0);
        this.shaded.setEnabled(n == 3 || n == 2 || n == 4);
        this.smoothMesh.setEnabled(n == 2 || n == 4);
        this.coordinateSystem.setState(content.hasCoord());
        this.lock.setState(content.isLocked());
        this.show.setState(content.isVisible());
        this.pl_show.setState(content.isPLVisible());
        this.shaded.setState(content.isShaded());
        ImagePlus imagePlus = content.image;
        this.displayAsVolume.setEnabled(n != 0 && imagePlus != null);
        this.displayAsOrtho.setEnabled(n != 1 && imagePlus != null);
        this.displayAsSurface.setEnabled(n != 2 && imagePlus != null);
        this.displayAsSurfacePlot.setEnabled(n != 3 && imagePlus != null);
    }

    private class SelectionListener
    implements ActionListener {
        private SelectionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Image3DMenubar.this.executer.select(actionEvent.getActionCommand());
        }
    }
}

