/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import com.sun.j3d.utils.universe.SimpleUniverse;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.UniverseSettings;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.j3d.Background;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.J3DGraphics2D;
import javax.vecmath.Color3f;

public class ImageCanvas3D
extends Canvas3D
implements KeyListener {
    private RoiImagePlus roiImagePlus;
    private ImageCanvas roiImageCanvas;
    private Map<Integer, Long> pressed;
    private Map<Integer, Long> released;
    private Background background = new Background(new Color3f(UniverseSettings.defaultBackground));
    private final ExecutorService exec = Executors.newSingleThreadExecutor();

    protected void flush() {
        this.exec.shutdown();
    }

    public ImageCanvas3D(int n, int n2) {
        super(SimpleUniverse.getPreferredConfiguration());
        this.setPreferredSize(new Dimension(n, n2));
        ByteProcessor byteProcessor = new ByteProcessor(n, n2);
        this.roiImagePlus = new RoiImagePlus("RoiImage", byteProcessor);
        this.roiImageCanvas = new ImageCanvas(this.roiImagePlus){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = Toolbar.getToolId();
                if (n != 11 && n != 7) {
                    super.mousePressed(mouseEvent);
                }
            }
        };
        this.roiImageCanvas.removeKeyListener((KeyListener)IJ.getInstance());
        this.roiImageCanvas.disablePopupMenu(true);
        this.getGraphicsContext3D().setBackground(this.background);
        this.addListeners();
        this.addMouseListener((MouseListener)this.roiImageCanvas);
        this.addMouseMotionListener((MouseMotionListener)this.roiImageCanvas);
    }

    public Background getBG() {
        return this.background;
    }

    public void killRoi() {
        this.roiImagePlus.killRoi();
        this.render();
    }

    private boolean isSelectionTool() {
        int n = Toolbar.getToolId();
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8;
    }

    private void addListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ImageCanvas3D.this.isSelectionTool()) {
                    ImageCanvas3D.this.exec.submit(new Runnable(){

                        public void run() {
                            ImageCanvas3D.this.postRender();
                        }
                    });
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ImageCanvas3D.this.isSelectionTool()) {
                    ImageCanvas3D.this.exec.submit(new Runnable(){

                        public void run() {
                            ImageCanvas3D.this.render();
                        }
                    });
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (ImageCanvas3D.this.isSelectionTool()) {
                    ImageCanvas3D.this.exec.submit(new Runnable(){

                        public void run() {
                            ImageCanvas3D.this.render();
                        }
                    });
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!ImageCanvas3D.this.isSelectionTool()) {
                    ImageCanvas3D.this.roiImagePlus.killRoi();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ImageCanvas3D.this.exec.submit(new Runnable(){

                    public void run() {
                        ByteProcessor byteProcessor = new ByteProcessor(ImageCanvas3D.this.getWidth(), ImageCanvas3D.this.getHeight());
                        ImageCanvas3D.this.roiImagePlus.setProcessor("RoiImagePlus", (ImageProcessor)byteProcessor);
                        ImageCanvas3D.this.render();
                    }
                });
            }
        });
        this.addKeyListener(this);
    }

    public Roi getRoi() {
        return this.roiImagePlus.getRoi();
    }

    public void preRender() {
        super.getGraphicsContext3D().clear();
        super.preRender();
    }

    public void render() {
        this.stopRenderer();
        this.swap();
        this.startRenderer();
    }

    public synchronized void keyPressed(KeyEvent keyEvent) {
        long l = keyEvent.getWhen();
        this.pressed.put(keyEvent.getKeyCode(), l);
    }

    public synchronized void keyReleased(KeyEvent keyEvent) {
        long l = keyEvent.getWhen();
        this.released.put(keyEvent.getKeyCode(), l);
    }

    public synchronized boolean isKeyDown(int n) {
        long l;
        if (!this.pressed.containsKey(n)) {
            return false;
        }
        if (!this.released.containsKey(n)) {
            return true;
        }
        long l2 = this.pressed.get(n);
        return l2 >= (l = this.released.get(n).longValue()) || System.currentTimeMillis() - l < 100L;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void postRender() {
        J3DGraphics2D j3DGraphics2D = this.getGraphics2D();
        Roi roi = this.roiImagePlus.getRoi();
        if (roi != null) {
            roi.draw((Graphics)j3DGraphics2D);
        }
        j3DGraphics2D.flush(true);
    }

    private class RoiImagePlus
    extends ImagePlus {
        public RoiImagePlus(String string, ByteProcessor byteProcessor) {
            this.setProcessor(string, (ImageProcessor)byteProcessor);
            ImageCanvas3D.this.pressed = new HashMap();
            ImageCanvas3D.this.released = new HashMap();
        }

        public ImageCanvas getCanvas() {
            return ImageCanvas3D.this.roiImageCanvas;
        }
    }
}

