/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import com.sun.j3d.utils.universe.SimpleUniverse;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import ij.macro.Interpreter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.ImageCanvas3D;
import ij3d.UniverseListener;
import ij3d.UniverseSettings;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RenderingError;
import javax.media.j3d.RenderingErrorListener;
import javax.media.j3d.Screen3D;
import javax.media.j3d.View;
import javax.vecmath.Color3f;

public class ImageWindow3D
extends ImageWindow
implements UniverseListener,
WindowStateListener,
KeyListener {
    DefaultUniverse universe;
    ImageCanvas3D canvas3D;
    Label status = new Label("");
    private boolean noOffScreen = true;
    private ErrorListener error_listener;
    private Canvas3D offScreenCanvas3D;
    final ImagePlusUpdater imp_updater = new ImagePlusUpdater();
    private int top = 0;
    private int bottom = 0;
    private int left = 0;
    private int right = 0;
    private int lastToolID = 12;

    public ImageWindow3D(String string, DefaultUniverse defaultUniverse) {
        super(string);
        String string2 = System.getProperty("j3d.noOffScreen");
        if (string2 != null && string2.equals("true")) {
            this.noOffScreen = true;
        }
        this.imp = new ImagePlus();
        this.universe = defaultUniverse;
        this.canvas3D = (ImageCanvas3D)defaultUniverse.getCanvas();
        this.error_listener = new ErrorListener();
        this.error_listener.addTo(defaultUniverse);
        WindowManager.addWindow((Frame)((Object)this));
        WindowManager.setCurrentWindow((ImageWindow)this);
        this.add((Component)((Object)this.canvas3D), -1);
        this.status.setText("");
        this.status.setForeground(Color.WHITE);
        Color3f color3f = UniverseSettings.defaultBackground;
        this.status.setBackground(new Color(color3f.x, color3f.y, color3f.z));
        this.status.setFont(new Font("Verdana", 0, 20));
        this.add(this.status, "South", -1);
        this.pack();
        this.addFocusListener((FocusListener)((Object)this));
        this.setFocusTraversalKeysEnabled(false);
        this.addWindowListener((WindowListener)((Object)this));
        this.addWindowStateListener(this);
        this.canvas3D.addKeyListener(this);
        ImageJ imageJ = IJ.getInstance();
        if (imageJ != null) {
            this.canvas3D.addKeyListener((KeyListener)imageJ);
            this.addKeyListener((KeyListener)imageJ);
        }
        defaultUniverse.addUniverseListener(this);
        this.updateImagePlus();
        Toolbar.getInstance().setTool(12);
        this.show();
    }

    public boolean close() {
        boolean bl = super.close();
        return bl;
    }

    public DefaultUniverse getUniverse() {
        return this.universe;
    }

    public ImageCanvas getCanvas() {
        return new ImageCanvas(this.getImagePlus());
    }

    private static Canvas3D getCanvas3D(int n, int n2) {
        return new ImageCanvas3D(n, n2);
    }

    public void drawInfo(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
    }

    public Insets getInsets() {
        int n;
        this.ic = this.getCanvas();
        Insets insets = super.getInsets();
        this.ic = null;
        double d = 1.0;
        int n2 = (int)((128.0 - (double)this.imp.getWidth() * d) / 2.0);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (int)((32.0 - (double)this.imp.getHeight() * d) / 2.0)) < 0) {
            n = 0;
        }
        insets = new Insets(insets.top - 10 - n, insets.left - n2, insets.bottom - n, insets.right - n2);
        return insets;
    }

    private Canvas3D getOffScreenCanvas() {
        if (this.offScreenCanvas3D != null) {
            return this.offScreenCanvas3D;
        }
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        graphicsConfigTemplate3D.setDoubleBuffer(3);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
        this.offScreenCanvas3D = new Canvas3D(graphicsConfiguration, true);
        Screen3D screen3D = this.canvas3D.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas3D.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D(this.offScreenCanvas3D);
        return this.offScreenCanvas3D;
    }

    private static ImagePlus makeDummyImagePlus() {
        ColorProcessor colorProcessor = new ColorProcessor(1, 1);
        return new ImagePlus("3D", (ImageProcessor)colorProcessor);
    }

    public void updateImagePlus() {
        this.imp_updater.update();
    }

    public void updateImagePlusAndWait() {
        this.imp_updater.updateAndWait();
    }

    public ImagePlus getImagePlus() {
        if (this.imp == null) {
            this.imp_updater.updateAndWait();
        }
        return this.imp;
    }

    private ImagePlus getNewImagePlus() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return ImageWindow3D.makeDummyImagePlus();
        }
        if (this.noOffScreen) {
            Robot robot;
            if (this.universe.getUseToFront()) {
                this.toFront();
            }
            Point point = this.canvas3D.getLocationOnScreen();
            int n = this.canvas3D.getWidth();
            int n2 = this.canvas3D.getHeight();
            try {
                robot = new Robot(this.getGraphicsConfiguration().getDevice());
            }
            catch (AWTException aWTException) {
                return ImageWindow3D.makeDummyImagePlus();
            }
            Rectangle rectangle = new Rectangle(point.x + this.left, point.y + this.top, n - this.left - this.right, n2 - this.top - this.bottom);
            BufferedImage bufferedImage = robot.createScreenCapture(rectangle);
            ColorProcessor colorProcessor = new ColorProcessor((Image)bufferedImage);
            ImagePlus imagePlus = new ImagePlus("3d", (ImageProcessor)colorProcessor);
            imagePlus.setRoi(this.canvas3D.getRoi());
            return imagePlus;
        }
        BufferedImage bufferedImage = new BufferedImage(this.canvas3D.getWidth(), this.canvas3D.getHeight(), 2);
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, bufferedImage);
        try {
            this.getOffScreenCanvas();
            this.offScreenCanvas3D.setOffScreenBuffer(imageComponent2D);
            this.offScreenCanvas3D.renderOffScreenBuffer();
            this.offScreenCanvas3D.waitForOffScreenRendering();
            bufferedImage = this.offScreenCanvas3D.getOffScreenBuffer().getImage();
            this.offScreenCanvas3D.setOffScreenBuffer(null);
        }
        catch (Exception exception) {
            this.noOffScreen = true;
            this.universe.getViewer().getView().removeCanvas3D(this.offScreenCanvas3D);
            this.offScreenCanvas3D = null;
            System.err.println("Java3D error: Off-screen rendering not supported by this\nsetup. Falling back to screen capturing");
            return this.getNewImagePlus();
        }
        ColorProcessor colorProcessor = new ColorProcessor((Image)bufferedImage);
        ImagePlus imagePlus = new ImagePlus("3d", (ImageProcessor)colorProcessor);
        imagePlus.setRoi(this.canvas3D.getRoi());
        return imagePlus;
    }

    public Label getStatusLabel() {
        return this.status;
    }

    public void windowActivated(WindowEvent windowEvent) {
        ImageJ imageJ = IJ.getInstance();
        boolean bl = imageJ != null && imageJ.quitting();
        this.imp.setActivated();
        if (!(this.closed || bl || Interpreter.isBatchMode())) {
            WindowManager.setCurrentWindow((ImageWindow)this);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.destroy();
    }

    public void destroy() {
        Method method;
        if (null == this.universe) {
            return;
        }
        this.universe.removeUniverseListener(this);
        try {
            method = SimpleUniverse.class.getMethod("removeRenderingErrorListener", RenderingErrorListener.class);
            if (null != method) {
                method.invoke((Object)this.universe, this.error_listener);
            }
        }
        catch (Exception exception) {
            System.out.println("Could NOT remove the RenderingErrorListener!");
            exception.printStackTrace();
        }
        if (null != this.universe.getWindow()) {
            this.universe.close();
        }
        if (null != (method = IJ.getInstance())) {
            this.removeKeyListener((KeyListener)((Object)method));
            this.canvas3D.removeKeyListener((KeyListener)((Object)method));
        }
        this.imp_updater.quit();
        this.canvas3D.flush();
        this.universe = null;
    }

    public void universeClosed() {
    }

    public void transformationStarted(View view) {
    }

    public void transformationUpdated(View view) {
    }

    public void contentSelected(Content content) {
    }

    public void transformationFinished(View view) {
        this.updateImagePlus();
    }

    public void contentAdded(Content content) {
        this.updateImagePlus();
    }

    public void contentRemoved(Content content) {
        this.updateImagePlus();
    }

    public void contentChanged(Content content) {
        this.updateImagePlus();
    }

    public void canvasResized() {
        this.updateImagePlus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        Content content;
        if (keyEvent.getKeyCode() == 27) {
            if (Toolbar.getToolId() == 12) {
                Toolbar.getInstance().setTool(this.lastToolID);
            } else {
                this.lastToolID = Toolbar.getToolId();
                Toolbar.getInstance().setTool(12);
            }
        }
        if (null != (content = this.universe.getSelected())) {
            switch (keyEvent.getKeyCode()) {
                case 88: 
                case 89: 
                case 90: {
                    keyEvent.consume();
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private class ErrorListener
    implements RenderingErrorListener {
        private ErrorListener() {
        }

        public void errorOccurred(RenderingError renderingError) {
            throw new RuntimeException(renderingError.getDetailMessage());
        }

        public void addTo(DefaultUniverse defaultUniverse) {
            try {
                Class[] classArray = new Class[]{RenderingErrorListener.class};
                Class<?> clazz = defaultUniverse.getClass();
                String string = "addRenderingErrorListener";
                Method method = clazz.getMethod(string, classArray);
                Object[] objectArray = new Object[]{this};
                method.invoke((Object)defaultUniverse, objectArray);
            }
            catch (Exception exception) {
                System.err.println("Java3D < 1.5 detected");
            }
        }
    }

    private class ImagePlusUpdater
    extends Thread {
        boolean go;
        int update;

        ImagePlusUpdater() {
            super("3D-V-IMP-updater");
            this.go = true;
            this.update = 0;
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() {
            ImagePlusUpdater imagePlusUpdater = this;
            synchronized (imagePlusUpdater) {
                ++this.update;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateAndWait() {
            this.update();
            ImagePlusUpdater imagePlusUpdater = this;
            synchronized (imagePlusUpdater) {
                while (this.update > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.go) {
                int n;
                ImagePlusUpdater imagePlusUpdater = this;
                synchronized (imagePlusUpdater) {
                    if (0 == this.update) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    n = this.update;
                }
                ImageWindow3D.this.imp = ImageWindow3D.this.getNewImagePlus();
                imagePlusUpdater = this;
                synchronized (imagePlusUpdater) {
                    if (n != this.update) {
                        continue;
                    }
                    this.update = 0;
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            this.go = false;
            ImagePlusUpdater imagePlusUpdater = this;
            synchronized (imagePlusUpdater) {
                this.update = -2147483647;
                this.notify();
            }
        }
    }
}

