/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij3d.Vector3;
import ij3d.VectorString3D;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;

public class Pipe {
    public static List generateTriangles(double[][][] dArray, double d) {
        int n = dArray.length;
        int n2 = dArray[0].length - 1;
        ArrayList<Point3f> arrayList = new ArrayList<Point3f>();
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2; ++j) {
                arrayList.add(new Point3f((float)(dArray[i][j][0] * d), (float)(dArray[i][j][1] * d), (float)(dArray[i][j][2] * d)));
                arrayList.add(new Point3f((float)(dArray[i][j + 1][0] * d), (float)(dArray[i][j + 1][1] * d), (float)(dArray[i][j + 1][2] * d)));
                arrayList.add(new Point3f((float)(dArray[i + 1][j][0] * d), (float)(dArray[i + 1][j][1] * d), (float)(dArray[i + 1][j][2] * d)));
                arrayList.add(new Point3f((float)(dArray[i + 1][j][0] * d), (float)(dArray[i + 1][j][1] * d), (float)(dArray[i + 1][j][2] * d)));
                arrayList.add(new Point3f((float)(dArray[i][j + 1][0] * d), (float)(dArray[i][j + 1][1] * d), (float)(dArray[i][j + 1][2] * d)));
                arrayList.add(new Point3f((float)(dArray[i + 1][j + 1][0] * d), (float)(dArray[i + 1][j + 1][1] * d), (float)(dArray[i + 1][j + 1][2] * d)));
            }
        }
        return arrayList;
    }

    public static double[][][] makeTube(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
        return Pipe.makeTube(dArray, dArray2, dArray3, dArray4, n, n2, true);
    }

    public static double[][][] makeTube(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, int n2, boolean bl) {
        int n3;
        Object object;
        int n4 = dArray.length;
        if (bl) {
            try {
                object = new VectorString3D(dArray, dArray2, dArray3);
                ((VectorString3D)object).addDependent(dArray4);
                ((VectorString3D)object).resample(((VectorString3D)object).getAverageDelta() * (double)n);
                dArray = ((VectorString3D)object).getPoints(0);
                dArray2 = ((VectorString3D)object).getPoints(1);
                dArray3 = ((VectorString3D)object).getPoints(2);
                dArray4 = ((VectorString3D)object).getDependent(0);
                n4 = ((VectorString3D)object).length();
            }
            catch (Exception exception) {
                IJ.error((String)("" + exception));
            }
        }
        object = new double[n4 + 2][n2 + 1][3];
        int n5 = 1;
        for (int i = 0; i < n2 + 1; ++i) {
            object[0][i][0] = dArray[0];
            object[0][i][1] = dArray2[0];
            object[0][i][2] = dArray3[0];
            object[((Object)object).length - 1][i][0] = dArray[n4 - 1];
            object[((Object)object).length - 1][i][1] = dArray2[n4 - 1];
            object[((Object)object).length - 1][i][2] = dArray3[n4 - 1];
        }
        double d = Math.PI * 2 / (double)n2;
        Vector3[] vector3Array = new Vector3[n2 + 1];
        int n6 = n2 / 2;
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            double d2;
            double d3;
            int n7;
            Vector3 vector3;
            Vector3 vector32 = new Vector3(dArray[n3 + 1] - dArray[n3], dArray2[n3 + 1] - dArray2[n3], dArray3[n3 + 1] - dArray3[n3]);
            if (vector32.y < 0.0) {
                vector3 = new Vector3(vector32.y, -vector32.x, 0.0);
                vector3 = vector3.normalize(vector3);
                vector3Array[n6] = vector3 = vector3.scale(dArray4[n3], vector3);
                for (n7 = n6 + 1; n7 < n2 + 1; ++n7) {
                    d3 = Math.sin(d * (double)(n7 - n6));
                    d2 = Math.cos(d * (double)(n7 - n6));
                    vector3Array[n7] = Pipe.rotate_v_around_axis(vector3, vector32, d3, d2);
                }
                vector3Array[0] = vector3Array[n2];
                for (n7 = 1; n7 < n6; ++n7) {
                    d3 = Math.sin(d * (double)(n7 + n6));
                    d2 = Math.cos(d * (double)(n7 + n6));
                    vector3Array[n7] = Pipe.rotate_v_around_axis(vector3, vector32, d3, d2);
                }
            } else {
                vector3 = new Vector3(-vector32.y, vector32.x, 0.0);
                if (null == (vector3 = vector3.normalize(vector3))) {
                    System.out.println("vp_3r is null: most likely a point was repeated in the list, and thus the vector has length zero.");
                    return null;
                }
                vector3Array[0] = vector3 = vector3.scale(dArray4[n3], vector3);
                for (n7 = 1; n7 < n2; ++n7) {
                    d3 = Math.sin(d * (double)n7);
                    d2 = Math.cos(d * (double)n7);
                    vector3Array[n7] = Pipe.rotate_v_around_axis(vector3, vector32, d3, d2);
                }
                vector3Array[n2] = vector3;
            }
            for (n7 = 0; n7 < n2 + 1; ++n7) {
                object[n3 + n5][n7][0] = dArray[n3] + vector3Array[n7].x;
                object[n3 + n5][n7][1] = dArray2[n3] + vector3Array[n7].y;
                object[n3 + n5][n7][2] = dArray3[n3] + vector3Array[n7].z;
            }
        }
        for (n3 = 0; n3 < n2 + 1; ++n3) {
            object[n4 - 1 + n5][n3][0] = dArray[n4 - 1] + vector3Array[n3].x;
            object[n4 - 1 + n5][n3][1] = dArray2[n4 - 1] + vector3Array[n3].y;
            object[n4 - 1 + n5][n3][2] = dArray3[n4 - 1] + vector3Array[n3].z;
        }
        return object;
    }

    private static Vector3 rotate_v_around_axis(Vector3 vector3, Vector3 vector32, double d, double d2) {
        Vector3 vector33 = new Vector3();
        Vector3 vector34 = vector32.normalize(vector32);
        vector33.set((d2 + (1.0 - d2) * vector34.x * vector34.x) * vector3.x + ((1.0 - d2) * vector34.x * vector34.y - vector34.z * d) * vector3.y + ((1.0 - d2) * vector34.x * vector34.z + vector34.y * d) * vector3.z, ((1.0 - d2) * vector34.x * vector34.y + vector34.z * d) * vector3.x + (d2 + (1.0 - d2) * vector34.y * vector34.y) * vector3.y + ((1.0 - d2) * vector34.y * vector34.z - vector34.x * d) * vector3.z, ((1.0 - d2) * vector34.y * vector34.z - vector34.y * d) * vector3.x + ((1.0 - d2) * vector34.y * vector34.z + vector34.x * d) * vector3.y + (d2 + (1.0 - d2) * vector34.z * vector34.z) * vector3.z);
        return vector33;
    }
}

