/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.UniverseListener;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import vib.BenesNamedPoint;
import vib.FastMatrix;
import vib.PointList;

public class RegistrationMenubar
extends MenuBar
implements ActionListener,
UniverseListener {
    private Image3DUniverse univ;
    private Menu register;
    private MenuItem exit;
    private MenuItem adjustSlices;
    private List openDialogs = new ArrayList();
    private Content templ;
    private Content model;

    public RegistrationMenubar(Image3DUniverse image3DUniverse) {
        this.univ = image3DUniverse;
        image3DUniverse.addUniverseListener(this);
        this.register = new Menu("Register");
        this.exit = new MenuItem("Exit registration");
        this.exit.addActionListener(this);
        this.register.add(this.exit);
        this.adjustSlices = new MenuItem("Adjust slices");
        this.adjustSlices.addActionListener(this);
        this.register.add(this.adjustSlices);
        this.add(this.register);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.exit) {
            this.exitRegistration();
        } else if (actionEvent.getSource() == this.adjustSlices) {
            Content content = this.univ.getSelected();
            if (content != null) {
                this.univ.getExecuter().changeSlices(content);
            }
        } else if (actionEvent.getActionCommand().equals("LS_TEMPLATE")) {
            this.selectLandmarkSet(this.templ, "LS_MODEL");
        } else if (actionEvent.getActionCommand().equals("LS_MODEL")) {
            this.selectLandmarkSet(this.model, "REGISTER");
        } else if (actionEvent.getActionCommand().equals("REGISTER")) {
            this.doRegistration(this.templ, this.model);
        }
    }

    public void register() {
        new Thread(new Runnable(){

            public void run() {
                RegistrationMenubar.this.initRegistration();
            }
        }).start();
    }

    public void exitRegistration() {
        this.templ.showPointList(false);
        this.model.showPointList(false);
        MenuBar menuBar = this.univ.getMenuBar();
        this.univ.setMenubar(menuBar);
        this.univ.clearSelection();
        this.univ.setStatus("");
        this.univ.getPointListDialog().removeExtraPanel();
        Toolbar.getInstance().setTool(12);
    }

    private void hideAll() {
        Iterator iterator = this.univ.contents();
        while (iterator.hasNext()) {
            ((Content)iterator.next()).setVisible(false);
        }
    }

    private void selectLandmarkSet(Content content, String string) {
        this.hideAll();
        content.setVisible(true);
        content.displayAs(1);
        content.showPointList(true);
        Toolbar.getInstance().setTool(7);
        this.univ.select(content);
        this.univ.setStatus("Select landmarks in " + content.getName() + " and click OK");
        Panel panel = new Panel(new FlowLayout());
        Button button = new Button("OK");
        button.setActionCommand(string);
        button.addActionListener(this);
        panel.add(button);
        if (string.equals("REGISTER")) {
            button = new Button("Back to template");
            button.setActionCommand("LS_TEMPLATE");
            button.addActionListener(this);
            panel.add(button);
        }
        this.univ.getPointListDialog().addPanel(panel);
    }

    public void initRegistration() {
        Collection collection = this.univ.getContents();
        if (collection.size() < 2) {
            IJ.error((String)"At least two bodies are required for  registration");
            return;
        }
        String[] stringArray = new String[collection.size()];
        int n = 0;
        GenericDialog genericDialog = collection.iterator();
        while (genericDialog.hasNext()) {
            stringArray[n++] = ((Content)genericDialog.next()).getName();
        }
        genericDialog = new GenericDialog("Registration");
        genericDialog.addChoice("template", stringArray, stringArray[0]);
        genericDialog.addChoice("model", stringArray, stringArray[1]);
        genericDialog.addCheckbox("allow scaling", true);
        this.openDialogs.add(genericDialog);
        genericDialog.showDialog();
        this.openDialogs.remove(genericDialog);
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.templ = this.univ.getContent(genericDialog.getNextChoice());
        this.model = this.univ.getContent(genericDialog.getNextChoice());
        boolean bl = genericDialog.getNextBoolean();
        this.selectLandmarkSet(this.templ, "LS_MODEL");
    }

    public void doRegistration(Content content, Content content2) {
        BenesNamedPoint[] benesNamedPointArray;
        int n;
        Object object;
        this.univ.setStatus("");
        PointList pointList = content.getPointList();
        PointList pointList2 = content2.getPointList();
        if (pointList.size() < 2 || pointList2.size() < 2) {
            IJ.error((String)"At least two points are required in each of the point lists");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<BenesNamedPoint> arrayList2 = new ArrayList<BenesNamedPoint>();
        for (int i = 0; i < pointList.size(); ++i) {
            object = pointList.get(i);
            BenesNamedPoint benesNamedPoint = pointList2.get(((BenesNamedPoint)object).getName());
            if (benesNamedPoint == null) continue;
            arrayList.add(object);
            arrayList2.add(benesNamedPoint);
        }
        if (arrayList.size() < 2) {
            IJ.error((String)"At least two points with the same name must exist in both bodies");
            this.univ.setStatus("");
            return;
        }
        DecimalFormat decimalFormat = new DecimalFormat("00.000");
        object = "Points used for registration\n \n";
        for (n = 0; n < arrayList.size(); ++n) {
            benesNamedPointArray = (BenesNamedPoint[])arrayList.get(n);
            object = (String)object + benesNamedPointArray.getName() + "    " + decimalFormat.format(benesNamedPointArray.x) + "    " + decimalFormat.format(benesNamedPointArray.y) + "    " + decimalFormat.format(benesNamedPointArray.z) + "\n";
        }
        n = IJ.showMessageWithCancel((String)"Points used for registration", (String)object) ? 1 : 0;
        if (n == 0) {
            return;
        }
        benesNamedPointArray = new BenesNamedPoint[arrayList2.size()];
        BenesNamedPoint[] benesNamedPointArray2 = new BenesNamedPoint[arrayList.size()];
        FastMatrix fastMatrix = FastMatrix.bestRigid(arrayList2.toArray(benesNamedPointArray), arrayList.toArray(benesNamedPointArray2));
        Transform3D transform3D = new Transform3D(fastMatrix.rowwise16());
        content.setTransform(new Transform3D());
        content2.setTransform(transform3D);
        content.setVisible(true);
        content.setLocked(true);
        content2.setVisible(true);
        content2.setLocked(true);
        this.univ.clearSelection();
        Toolbar.getInstance().setTool(12);
        IJ.showMessage((String)"Contents are locked to prevent\naccidental transformations");
        this.exitRegistration();
    }

    public void closeAllDialogs() {
        while (this.openDialogs.size() > 0) {
            GenericDialog genericDialog = (GenericDialog)this.openDialogs.get(0);
            genericDialog.dispose();
            this.openDialogs.remove(genericDialog);
        }
    }

    public void transformationStarted(View view) {
    }

    public void transformationFinished(View view) {
    }

    public void canvasResized() {
    }

    public void transformationUpdated(View view) {
    }

    public void contentChanged(Content content) {
    }

    public void universeClosed() {
    }

    public void contentAdded(Content content) {
    }

    public void contentRemoved(Content content) {
    }

    public void contentSelected(Content content) {
    }
}

