/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.gui.GenericDialog;
import ij3d.Image3DUniverse;
import ij3d.ImageCanvas3D;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.vecmath.Color3f;

public class UniverseSettings {
    public static final File propsfile = new File(System.getProperty("user.home"), ".ImageJ_3D_Viewer.props");
    public static final int PERSPECTIVE = 1;
    public static final int PARALLEL = 0;
    public static int startupWidth = 512;
    public static int startupHeight = 512;
    public static int projection = 1;
    public static boolean showGlobalCoordinateSystem = false;
    public static boolean showLocalCoordinateSystemsByDefault = false;
    public static boolean showScalebar = false;
    public static Color3f defaultBackground = new Color3f();

    public static void save() {
        Properties properties = new Properties();
        properties.put("Startup_Width", UniverseSettings.str(startupWidth));
        properties.put("Startup_Height", UniverseSettings.str(startupHeight));
        properties.put("Projection", UniverseSettings.str(projection));
        properties.put("Show_Global_Coordinate_System", UniverseSettings.str(showGlobalCoordinateSystem));
        properties.put("Show_Local_Coordinate_System_When_Adding_Content", UniverseSettings.str(showLocalCoordinateSystemsByDefault));
        properties.put("Show_Scalebar", UniverseSettings.str(showScalebar));
        properties.put("Background", UniverseSettings.str(defaultBackground));
        try {
            properties.store(new FileOutputStream(propsfile), "ImageJ 3D Viewer properties");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public static void load() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(propsfile));
            startupWidth = UniverseSettings.integer(properties.getProperty("Startup_Width", UniverseSettings.str(startupWidth)));
            startupHeight = UniverseSettings.integer(properties.getProperty("Startup_Height", UniverseSettings.str(startupHeight)));
            projection = UniverseSettings.integer(properties.getProperty("Projection", UniverseSettings.str(projection)));
            showGlobalCoordinateSystem = UniverseSettings.bool(properties.getProperty("Show_Global_Coordinate_System", UniverseSettings.str(showGlobalCoordinateSystem)));
            showLocalCoordinateSystemsByDefault = UniverseSettings.bool(properties.getProperty("Show_Local_Coordinate_System_When_Adding_Content", UniverseSettings.str(showLocalCoordinateSystemsByDefault)));
            showScalebar = UniverseSettings.bool(properties.getProperty("Show_Scalebar", UniverseSettings.str(showScalebar)));
            defaultBackground = UniverseSettings.col(properties.getProperty("Background", UniverseSettings.str(defaultBackground)));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public static void initFromDialog(Image3DUniverse image3DUniverse) {
        GenericDialog genericDialog = new GenericDialog("View Preferences", (Frame)((Object)image3DUniverse.getWindow()));
        genericDialog.addMessage("The following options are startup options\nThey are not applied, unless you activate\n'Apply changes now' below.");
        genericDialog.addNumericField("Width", (double)startupWidth, 0);
        genericDialog.addNumericField("Height", (double)startupHeight, 0);
        String[] stringArray = new String[]{"PARALLEL", "PERSPECTIVE"};
        int[] nArray = new int[]{0, 1};
        String string = projection == nArray[0] ? stringArray[0] : stringArray[1];
        genericDialog.addChoice("Projection", stringArray, string);
        genericDialog.addCheckbox("Show global coordinate system", showGlobalCoordinateSystem);
        genericDialog.addCheckbox("Use current color as default backround", false);
        genericDialog.addCheckbox("Show scalebar", showScalebar);
        genericDialog.addCheckbox("Apply changes now", true);
        genericDialog.addMessage("The following options are applied immediately:");
        genericDialog.addCheckbox("Show local coordinate system by default", showLocalCoordinateSystemsByDefault);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        startupWidth = (int)genericDialog.getNextNumber();
        startupHeight = (int)genericDialog.getNextNumber();
        projection = nArray[genericDialog.getNextChoiceIndex()];
        showGlobalCoordinateSystem = genericDialog.getNextBoolean();
        if (genericDialog.getNextBoolean() && image3DUniverse != null) {
            ((ImageCanvas3D)image3DUniverse.getCanvas()).getBG().getColor(defaultBackground);
        }
        showScalebar = genericDialog.getNextBoolean();
        boolean bl = genericDialog.getNextBoolean();
        showLocalCoordinateSystemsByDefault = genericDialog.getNextBoolean();
        UniverseSettings.save();
        if (bl) {
            UniverseSettings.apply(image3DUniverse);
        }
    }

    public static void apply(Image3DUniverse image3DUniverse) {
        if (image3DUniverse == null) {
            return;
        }
        image3DUniverse.setSize(startupWidth, startupHeight);
        image3DUniverse.getViewer().getView().setProjectionPolicy(projection);
        image3DUniverse.showAttribute(1, showGlobalCoordinateSystem);
        image3DUniverse.showAttribute(0, showScalebar);
    }

    private static final String str(int n) {
        return Integer.toString(n);
    }

    private static final String str(boolean bl) {
        return Boolean.toString(bl);
    }

    private static final String str(Color3f color3f) {
        return "[" + color3f.x + "," + color3f.y + "," + color3f.z + "]";
    }

    private static final Color3f col(String string) {
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        return new Color3f(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
    }

    private static final boolean bool(String string) {
        return Boolean.parseBoolean(string);
    }

    private static final int integer(String string) {
        return Integer.parseInt(string);
    }
}

