/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import Jama.Matrix;
import ij3d.Utils;

class VectorString3D {
    private double[] x;
    private double[] y;
    private double[] z;
    private double[] vx;
    private double[] vy;
    private double[] vz;
    private double[] rvx;
    private double[] rvy;
    private double[] rvz;
    private int length = 0;
    private double delta = 0.0;
    private double[][] dep;

    public VectorString3D(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new RuntimeException("x,y,z must have the same length.");
        }
        this.length = dArray.length;
        this.x = dArray;
        this.y = dArray2;
        this.z = dArray3;
    }

    public void addDependent(double[] dArray) throws Exception {
        if (dArray.length != this.length) {
            throw new Exception("Dependent array must be of the same size as thevalue returned by length()");
        }
        if (null == this.dep) {
            this.dep = new double[1][];
            this.dep[0] = dArray;
        } else {
            double[][] dArrayArray = new double[this.dep.length + 1][];
            for (int i = 0; i < this.dep.length; ++i) {
                dArrayArray[i] = this.dep[i];
            }
            dArrayArray[this.dep.length] = dArray;
            this.dep = dArrayArray;
        }
    }

    public double[] getDependent(int n) {
        return this.dep[n];
    }

    public double getAverageDelta() {
        double d = 0.0;
        for (int i = this.length - 1; i > 0; --i) {
            d += Math.sqrt(Math.pow(this.x[i] - this.x[i - 1], 2.0) + Math.pow(this.y[i] - this.y[i - 1], 2.0) + Math.pow(this.z[i] - this.z[i - 1], 2.0));
        }
        return d / (double)this.length;
    }

    public void resample(double d) {
        if (Math.abs(d - this.delta) < 1.0E-7) {
            return;
        }
        this.delta = d;
        this.resample();
    }

    public final int length() {
        return this.length;
    }

    public double[] getPoints(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return null;
    }

    private boolean isClosed() {
        return false;
    }

    private final void recalculate(double[] dArray, int n, double d) {
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray[i] / d;
            d2 += dArray[i];
        }
        double d3 = 1.0 - d2;
        if (d3 < 0.0) {
            d3 = -d3;
        }
        if (d3 < 0.005) {
            dArray[0] = dArray[0] + (1.0 - d2);
        } else if (d2 > 1.0) {
            this.recalculate(dArray, n, d2);
        }
    }

    private void resample() {
        int n;
        double d;
        int n2;
        double d2 = 2.5 * this.delta;
        ResamplingData resamplingData = new ResamplingData(this.length, this.dep);
        Vector vector = new Vector();
        resamplingData.setDeps(0, this.dep, new int[]{0}, new double[]{1.0}, 1);
        resamplingData.setP(0, this.x[0], this.y[0], this.z[0]);
        int n3 = 1;
        int n4 = 1;
        int n5 = n3;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        Vector[] vectorArray = new Vector[6];
        for (n2 = 0; n2 < 6; ++n2) {
            vectorArray[n2] = new Vector();
        }
        int[] nArray = new int[6];
        try {
            while (n5 <= n3 && n5 <= n3 && (this.isClosed() || n3 != this.length - 1)) {
                int n6;
                n2 = 0;
                for (int i = 0; i < 6; ++i) {
                    int n7 = n3 + i;
                    if (n7 >= this.length) {
                        if (!this.isClosed()) break;
                        n7 -= this.length;
                    }
                    if (!((d = resamplingData.distance(n4 - 1, this.x[n7], this.y[n7], this.z[n7])) < d2)) continue;
                    nArray[n2] = n7;
                    dArray2[n2] = d;
                    ++n2;
                }
                if (0 == n2) {
                    vector.set(this.x[n3] - resamplingData.x(n4 - 1), this.y[n3] - resamplingData.y(n4 - 1), this.z[n3] - resamplingData.z(n4 - 1));
                    double d3 = vector.length();
                    vector.setLength(this.delta);
                    vector.put(n4, resamplingData);
                    if (null != this.dep) {
                        resamplingData.setDeps(n4, this.dep, new int[]{n3}, new double[]{1.0}, 1);
                    }
                    if (d3 <= this.delta) {
                        for (n6 = n3; n6 < this.length; ++n6) {
                            double d4 = Math.sqrt(Math.pow(this.x[n6] - resamplingData.x(n4 - 1), 2.0) + Math.pow(this.y[n6] - resamplingData.y(n4 - 1), 2.0) + Math.pow(this.z[n6] - resamplingData.z(n4 - 1), 2.0));
                            if (!(d4 > this.delta)) continue;
                            n5 = n3;
                            n3 = n6;
                            break;
                        }
                    }
                } else {
                    dArray[0] = dArray2[0] / d2;
                    double d5 = dArray[0];
                    for (n6 = 1; n6 < n2; ++n6) {
                        dArray[n6] = 1.0 - dArray2[n6] / d2;
                        if (!(dArray[n6] > d5)) continue;
                        d5 = dArray[n6];
                    }
                    double d6 = 0.0;
                    for (n6 = 0; n6 < n2; ++n6) {
                        dArray[n6] = dArray[n6] / d5;
                        d6 += dArray[n6];
                    }
                    if (d6 < 1.0) {
                        dArray[0] = dArray[0] + (1.0 - d6);
                    } else {
                        this.recalculate(dArray, n2, d6);
                    }
                    vector.set(0.0, 0.0, 0.0);
                    for (n6 = 0; n6 < n2; ++n6) {
                        int n8 = n3 + n6;
                        if (n8 >= this.length) {
                            n8 -= this.length;
                        }
                        vectorArray[n6].set(this.x[n8] - resamplingData.x(n4 - 1), this.y[n8] - resamplingData.y(n4 - 1), this.z[n8] - resamplingData.z(n4 - 1));
                        vectorArray[n6].setLength(dArray[n6] * this.delta);
                        vector.add(vectorArray[n6], n6 == n2 - 1);
                    }
                    if (Math.abs(vector.length() - this.delta) > 1.0E-8) {
                        vector.setLength(this.delta);
                    }
                    vector.put(n4, resamplingData);
                    if (null != this.dep) {
                        resamplingData.setDeps(n4, this.dep, nArray, dArray, n2);
                    }
                    int n9 = n3;
                    for (int i = 0; i < n2; ++i) {
                        if (!(dArray2[i] > this.delta)) continue;
                        n9 = nArray[i];
                        break;
                    }
                    n5 = n3;
                    if (n3 == n9) {
                        n3 = nArray[n2 - 1] + 1;
                        if (n3 >= this.length) {
                            n3 = this.isClosed() ? (n3 -= this.length) : this.length - 1;
                        }
                    } else {
                        n3 = n9;
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Some data: x,y,z .length = " + this.x.length + "," + this.y.length + "," + this.z.length + "\nj=" + n4 + ", i=" + n3 + ", prev_i=" + n5);
        }
        d = resamplingData.distance(n4 - 1, this.x[this.length - 1], this.y[this.length - 1], this.z[this.length - 1]);
        int n10 = n = this.isClosed() ? 0 : this.length - 1;
        if (d > this.delta * 1.2) {
            while (d > this.delta * 1.2) {
                vector.set(this.x[n] - resamplingData.x(n4 - 1), this.y[n] - resamplingData.y(n4 - 1), this.z[n] - resamplingData.z(n4 - 1));
                vector.setLength(this.delta);
                vector.put(n4, resamplingData);
                d = resamplingData.distance(++n4 - 1, this.x[n], this.y[n], this.z[n]);
            }
        }
        resamplingData.put(this, n4);
    }

    static /* synthetic */ double[] access$002(VectorString3D vectorString3D, double[] dArray) {
        vectorString3D.x = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$102(VectorString3D vectorString3D, double[] dArray) {
        vectorString3D.y = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$202(VectorString3D vectorString3D, double[] dArray) {
        vectorString3D.z = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$302(VectorString3D vectorString3D, double[] dArray) {
        vectorString3D.vx = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$402(VectorString3D vectorString3D, double[] dArray) {
        vectorString3D.vy = dArray;
        return dArray;
    }

    static /* synthetic */ double[] access$502(VectorString3D vectorString3D, double[] dArray) {
        vectorString3D.vz = dArray;
        return dArray;
    }

    static /* synthetic */ double[][] access$702(VectorString3D vectorString3D, double[][] dArray) {
        vectorString3D.dep = dArray;
        return dArray;
    }

    private static class Vector {
        private double x;
        private double y;
        private double z;
        private double length;

        Vector() {
        }

        Vector(double d, double d2, double d3) {
            this.set(d, d2, d3);
        }

        Vector(Vector vector) {
            this.x = vector.x;
            this.y = vector.y;
            this.z = vector.z;
            this.length = vector.length;
        }

        public final Object clone() {
            return new Vector(this);
        }

        final void set(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
            this.length = this.computeLength();
        }

        final void normalize() {
            if (0.0 == this.length) {
                return;
            }
            if (Math.abs(1.0 - this.length) < 1.0E-8) {
                return;
            }
            this.x /= this.length;
            this.y /= this.length;
            this.z /= this.length;
            this.length = this.computeLength();
        }

        final double computeLength() {
            return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        final double length() {
            return this.length;
        }

        final void scale(double d) {
            this.x *= d;
            this.y *= d;
            this.z *= d;
            this.length = this.computeLength();
        }

        final void add(Vector vector, boolean bl) {
            this.x += vector.x;
            this.y += vector.y;
            this.z += vector.z;
            if (bl) {
                this.length = this.computeLength();
            }
        }

        final void setLength(double d) {
            this.normalize();
            this.scale(d);
        }

        final void put(int n, ResamplingData resamplingData) {
            resamplingData.setPV(n, resamplingData.x(n - 1) + this.x, resamplingData.y(n - 1) + this.y, resamplingData.z(n - 1) + this.z, this.x, this.y, this.z);
        }

        final void put(double[] dArray) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            dArray[2] = this.z;
        }

        final void put(double[][] dArray, int n) {
            dArray[0][n] = this.x;
            dArray[1][n] = this.y;
            dArray[2][n] = this.z;
        }

        final void put(int n, double[] dArray, double[] dArray2, double[] dArray3) {
            dArray[n] = this.x;
            dArray2[n] = this.y;
            dArray3[n] = this.z;
        }

        final Vector getCrossProduct(Vector vector) {
            return new Vector(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
        }

        final void setCrossProduct(Vector vector, Vector vector2) {
            this.x = vector.y * vector2.z - vector.z * vector2.y;
            this.y = vector.z * vector2.x - vector.x * vector2.z;
            this.z = vector.x * vector2.y - vector.y * vector2.x;
        }

        final void changeRef(Vector vector, Vector vector2, Vector vector3) {
            Vector vector4 = new Vector(vector3);
            vector4.normalize();
            Vector vector5 = vector4.getCrossProduct(vector2);
            vector5.normalize();
            Vector vector6 = vector4.getCrossProduct(vector5);
            double[][] dArray = new double[3][3];
            vector5.put(dArray, 0);
            vector4.put(dArray, 1);
            vector6.put(dArray, 2);
            Matrix matrix = new Matrix(dArray);
            Vector vector7 = new Vector(vector);
            vector7.normalize();
            Vector vector8 = vector5.getCrossProduct(vector7);
            double[][] dArray2 = new double[3][3];
            vector5.put(dArray2, 0);
            vector7.put(dArray2, 1);
            vector8.put(dArray2, 2);
            Matrix matrix2 = new Matrix(dArray2).transpose();
            Matrix matrix3 = matrix.times(matrix2);
            Matrix matrix4 = new Matrix(new double[]{this.x, this.y, this.z}, 1);
            Matrix matrix5 = matrix3.transpose().times(matrix4.transpose());
            double[][] dArray3 = matrix5.getArray();
            this.x = dArray3[0][0];
            this.y = dArray3[1][0];
            this.z = dArray3[2][0];
        }
    }

    private static class ResamplingData {
        private double[] rx;
        private double[] ry;
        private double[] rz;
        private double[] vx;
        private double[] vy;
        private double[] vz;
        private double[][] dep;

        ResamplingData(int n, double[][] dArray) {
            this.rx = new double[n];
            this.ry = new double[n];
            this.rz = new double[n];
            this.vx = new double[n];
            this.vy = new double[n];
            this.vz = new double[n];
            if (null != dArray) {
                this.dep = new double[dArray.length][n];
            }
        }

        final void setP(int n, double d, double d2, double d3) {
            if (n >= this.rx.length) {
                this.resize(n + 10);
            }
            this.rx[n] = d;
            this.ry[n] = d2;
            this.rz[n] = d3;
        }

        final void setV(int n, double d, double d2, double d3) {
            if (n >= this.rx.length) {
                this.resize(n + 10);
            }
            this.vx[n] = d;
            this.vy[n] = d2;
            this.vz[n] = d3;
        }

        final void setPV(int n, double d, double d2, double d3, double d4, double d5, double d6) {
            if (n >= this.rx.length) {
                this.resize(n + 10);
            }
            this.rx[n] = d;
            this.ry[n] = d2;
            this.rz[n] = d3;
            this.vx[n] = d4;
            this.vy[n] = d5;
            this.vz[n] = d6;
        }

        final void resize(int n) {
            this.rx = Utils.copy(this.rx, n);
            this.ry = Utils.copy(this.ry, n);
            this.rz = Utils.copy(this.rz, n);
            this.vx = Utils.copy(this.vx, n);
            this.vy = Utils.copy(this.vy, n);
            this.vz = Utils.copy(this.vz, n);
            if (null != this.dep) {
                double[][] dArrayArray = new double[this.dep.length][];
                for (int i = 0; i < this.dep.length; ++i) {
                    dArrayArray[i] = Utils.copy(this.dep[i], n);
                }
                this.dep = dArrayArray;
            }
        }

        final double x(int n) {
            return this.rx[n];
        }

        final double y(int n) {
            return this.ry[n];
        }

        final double z(int n) {
            return this.rz[n];
        }

        final double distance(int n, double d, double d2, double d3) {
            return Math.sqrt(Math.pow(d - this.rx[n], 2.0) + Math.pow(d2 - this.ry[n], 2.0) + Math.pow(d3 - this.rz[n], 2.0));
        }

        final void put(VectorString3D vectorString3D, int n) {
            VectorString3D.access$002(vectorString3D, Utils.copy(this.rx, n));
            VectorString3D.access$102(vectorString3D, Utils.copy(this.ry, n));
            VectorString3D.access$202(vectorString3D, Utils.copy(this.rz, n));
            VectorString3D.access$302(vectorString3D, Utils.copy(this.vx, n));
            VectorString3D.access$402(vectorString3D, Utils.copy(this.vy, n));
            VectorString3D.access$502(vectorString3D, Utils.copy(this.vz, n));
            vectorString3D.length = n;
            if (null != this.dep) {
                VectorString3D.access$702(vectorString3D, new double[this.dep.length][]);
                for (int i = 0; i < this.dep.length; ++i) {
                    ((VectorString3D)vectorString3D).dep[i] = Utils.copy(this.dep[i], n);
                }
            }
        }

        final void setDeps(int n, double[][] dArray, int[] nArray, double[] dArray2, int n2) {
            if (null == this.dep) {
                return;
            }
            if (n >= this.rx.length) {
                this.resize(n + 10);
            }
            for (int i = 0; i < this.dep.length; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double[] dArray3 = this.dep[i];
                    int n3 = n;
                    dArray3[n3] = dArray3[n3] + dArray[i][nArray[j]] * dArray2[j];
                }
            }
        }
    }
}

