/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import javax.vecmath.Point3d;

public class Volume {
    public static final int INT_DATA = 0;
    public static final int BYTE_DATA = 1;
    protected final ImagePlus imp;
    protected Loader loader;
    protected int dataType;
    protected boolean average = false;
    protected boolean[] channels = new boolean[]{true, true, true};
    public final int xDim;
    public final int yDim;
    public final int zDim;
    public final double pw;
    public final double ph;
    public final double pd;
    public final Point3d minCoord = new Point3d();
    public final Point3d maxCoord = new Point3d();

    public Volume(ImagePlus imagePlus) {
        this(imagePlus, new boolean[]{true, true, true});
    }

    public Volume(ImagePlus imagePlus, boolean[] blArray) {
        this.channels = blArray;
        this.imp = imagePlus;
        this.xDim = imagePlus.getWidth();
        this.yDim = imagePlus.getHeight();
        this.zDim = imagePlus.getStackSize();
        Calibration calibration = imagePlus.getCalibration();
        this.pw = calibration.pixelWidth;
        this.ph = calibration.pixelHeight;
        this.pd = calibration.pixelDepth;
        float f = (float)this.pw;
        float f2 = (float)this.ph;
        float f3 = (float)this.pd;
        this.minCoord.x = calibration.xOrigin;
        this.minCoord.y = calibration.yOrigin;
        this.minCoord.z = calibration.zOrigin;
        this.maxCoord.x = this.minCoord.x + (double)((float)this.xDim * f);
        this.maxCoord.y = this.minCoord.y + (double)((float)this.yDim * f2);
        this.maxCoord.z = this.minCoord.z + (double)((float)this.zDim * f3);
        this.initLoader();
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean setAverage(boolean bl) {
        if (this.average != bl) {
            this.average = bl;
            this.initLoader();
            return true;
        }
        return false;
    }

    public boolean isAverage() {
        return this.average;
    }

    public boolean setChannels(boolean[] blArray) {
        if (blArray[0] == this.channels[0] && blArray[1] == this.channels[1] && blArray[2] == this.channels[2]) {
            return false;
        }
        this.channels = blArray;
        this.initLoader();
        return true;
    }

    protected void initLoader() {
        boolean[] blArray = this.channels;
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.channels[i]) continue;
            ++n;
        }
        switch (this.imp.getType()) {
            case 0: {
                this.loader = new ByteLoader(this.imp);
                this.dataType = 1;
                break;
            }
            case 4: {
                if (n == 1) {
                    this.loader = new ByteFromIntLoader(this.imp, blArray);
                    this.dataType = 1;
                    break;
                }
                if (n == 2) {
                    if (this.average) {
                        this.loader = new ByteFromIntLoader(this.imp, blArray);
                        this.dataType = 1;
                        break;
                    }
                    this.loader = new IntFromIntLoader(this.imp, blArray);
                    this.dataType = 0;
                    break;
                }
                if (this.average) {
                    this.loader = new ByteFromIntLoader(this.imp, blArray);
                    this.dataType = 1;
                    break;
                }
                this.loader = new IntLoader(this.imp);
                this.dataType = 0;
                break;
            }
            default: {
                IJ.error((String)"image format not supported");
            }
        }
    }

    public void setNoCheck(int n, int n2, int n3, int n4) {
        this.loader.setNoCheck(n, n2, n3, n4);
    }

    public void set(int n, int n2, int n3, int n4) {
        this.loader.set(n, n2, n3, n4);
    }

    public int load(int n, int n2, int n3) {
        return this.loader.load(n, n2, n3);
    }

    protected class ByteFromIntLoader
    implements Loader {
        protected int[][] fdata;
        protected int w;
        protected boolean[] channels = new boolean[]{true, true, true};
        protected int usedCh = 3;

        protected ByteFromIntLoader(ImagePlus imagePlus, boolean[] blArray) {
            int n;
            this.channels = blArray;
            ImageStack imageStack = imagePlus.getStack();
            int n2 = imagePlus.getStackSize();
            this.w = imagePlus.getWidth();
            this.fdata = new int[n2][];
            for (n = 0; n < n2; ++n) {
                this.fdata[n] = (int[])imageStack.getPixels(n + 1);
            }
            this.usedCh = 0;
            for (n = 0; n < 3; ++n) {
                if (!blArray[n]) continue;
                ++this.usedCh;
            }
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            this.fdata[n3][n2 * this.w + n] = n4;
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < Volume.this.xDim && n2 >= 0 && n2 < Volume.this.yDim && n3 > 0 && n3 < Volume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }

        public final int load(int n, int n2, int n3) {
            int n4 = this.fdata[n3][n2 * this.w + n];
            int n5 = 0;
            if (this.channels[0]) {
                n5 += (n4 & 0xFF0000) >> 16;
            }
            if (this.channels[1]) {
                n5 += (n4 & 0xFF00) >> 8;
            }
            if (this.channels[2]) {
                n5 += n4 & 0xFF;
            }
            return n5 /= this.usedCh;
        }
    }

    protected class IntFromIntLoader
    implements Loader {
        protected int[][] fData;
        protected int w;
        protected int mask = 0xFFFFFF;
        protected boolean[] ch = new boolean[]{true, true, true};
        protected int usedCh = 3;

        protected IntFromIntLoader(ImagePlus imagePlus, boolean[] blArray) {
            ImageStack imageStack = imagePlus.getStack();
            int n = imagePlus.getStackSize();
            this.fData = new int[n][];
            for (int i = 0; i < n; ++i) {
                this.fData[i] = (int[])imageStack.getPixels(i + 1);
            }
            this.ch = blArray;
            this.usedCh = 0;
            this.mask = -16777216;
            if (this.ch[0]) {
                ++this.usedCh;
                this.mask |= 0xFF0000;
            }
            if (this.ch[1]) {
                ++this.usedCh;
                this.mask |= 0xFF00;
            }
            if (this.ch[2]) {
                ++this.usedCh;
                this.mask |= 0xFF;
            }
            this.adjustAlphaChannel();
        }

        protected final void adjustAlphaChannel() {
            for (int i = 0; i < this.fData.length; ++i) {
                for (int j = 0; j < this.fData[i].length; ++j) {
                    int n = this.fData[i][j];
                    int n2 = 0;
                    if (this.ch[0]) {
                        n2 += (n & 0xFF0000) >> 16;
                    }
                    if (this.ch[1]) {
                        n2 += (n & 0xFF00) >> 8;
                    }
                    if (this.ch[2]) {
                        n2 += n & 0xFF;
                    }
                    int n3 = n2 / this.usedCh << 24;
                    this.fData[i][j] = (n & 0xFFFFFF) + n3;
                }
            }
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < Volume.this.xDim && n2 >= 0 && n2 < Volume.this.yDim && n3 > 0 && n3 < Volume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }

        public final int load(int n, int n2, int n3) {
            return this.fData[n3][n2 * this.w + n] & this.mask;
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            this.fData[n3][n2 * this.w + n] = n4;
        }
    }

    protected class IntLoader
    implements Loader {
        protected int[][] fData;
        protected int w;

        protected IntLoader(ImagePlus imagePlus) {
            ImageStack imageStack = imagePlus.getStack();
            int n = imagePlus.getStackSize();
            this.w = imagePlus.getWidth();
            this.fData = new int[n][];
            for (int i = 0; i < n; ++i) {
                this.fData[i] = (int[])imageStack.getPixels(i + 1);
            }
            this.adjustAlphaChannel();
        }

        protected final void adjustAlphaChannel() {
            for (int i = 0; i < this.fData.length; ++i) {
                for (int j = 0; j < this.fData[i].length; ++j) {
                    int n = this.fData[i][j];
                    int n2 = (n & 0xFF0000) >> 16;
                    int n3 = (n & 0xFF00) >> 8;
                    int n4 = n & 0xFF;
                    int n5 = (n2 + n3 + n4) / 3 << 24;
                    this.fData[i][j] = (n & 0xFFFFFF) + n5;
                }
            }
        }

        public final int load(int n, int n2, int n3) {
            return this.fData[n3][n2 * this.w + n];
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            this.fData[n3][n2 * this.w + n] = n4;
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < Volume.this.xDim && n2 >= 0 && n2 < Volume.this.yDim && n3 > 0 && n3 < Volume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }
    }

    protected class ByteLoader
    implements Loader {
        protected byte[][] fData;
        protected int w;

        protected ByteLoader(ImagePlus imagePlus) {
            ImageStack imageStack = imagePlus.getStack();
            int n = imagePlus.getStackSize();
            this.w = imagePlus.getWidth();
            this.fData = new byte[n][];
            for (int i = 0; i < n; ++i) {
                this.fData[i] = (byte[])imageStack.getPixels(i + 1);
            }
        }

        public final int load(int n, int n2, int n3) {
            return this.fData[n3][n2 * this.w + n] & 0xFF;
        }

        public void setNoCheck(int n, int n2, int n3, int n4) {
            this.fData[n3][n2 * this.w + n] = (byte)n4;
        }

        public void set(int n, int n2, int n3, int n4) {
            if (n >= 0 && n < Volume.this.xDim && n2 >= 0 && n2 < Volume.this.yDim && n3 > 0 && n3 < Volume.this.zDim) {
                this.setNoCheck(n, n2, n3, n4);
            }
        }
    }

    protected static interface Loader {
        public int load(int var1, int var2, int var3);

        public void set(int var1, int var2, int var3, int var4);

        public void setNoCheck(int var1, int var2, int var3, int var4);
    }
}

