/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij.gui.Toolbar;
import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.ImageCanvas3D;
import ij3d.behaviors.ContentTransformer;
import ij3d.behaviors.InteractiveViewPlatformTransformer;
import ij3d.behaviors.Picker;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import orthoslice.OrthoGroup;

public class InteractiveBehavior
extends Behavior {
    private DefaultUniverse univ;
    private ImageCanvas3D canvas;
    private WakeupOnAWTEvent[] mouseEvents;
    private WakeupCondition wakeupCriterion;
    private int toolID;
    private ContentTransformer contentTransformer;
    private Picker picker;
    private InteractiveViewPlatformTransformer viewTransformer;
    private static final int B1 = 1024;
    private static final int B2 = 2048;
    private static final int B3 = 4096;
    private static final int SHIFT = 64;
    private static final int CTRL = 128;
    private static final int PICK_POINT_MASK = 1024;
    private static final int DELETE_POINT_MASK = 1088;
    public static final double TWO_RAD = Math.PI / 90;

    public InteractiveBehavior(DefaultUniverse defaultUniverse) {
        this.univ = defaultUniverse;
        this.canvas = (ImageCanvas3D)defaultUniverse.getCanvas();
        this.contentTransformer = defaultUniverse.getContentTransformer();
        this.picker = defaultUniverse.getPicker();
        this.viewTransformer = defaultUniverse.getViewPlatformTransformer();
        this.mouseEvents = new WakeupOnAWTEvent[5];
    }

    public void initialize() {
        this.mouseEvents[0] = new WakeupOnAWTEvent(506);
        this.mouseEvents[1] = new WakeupOnAWTEvent(501);
        this.mouseEvents[2] = new WakeupOnAWTEvent(502);
        this.mouseEvents[3] = new WakeupOnAWTEvent(507);
        this.mouseEvents[4] = new WakeupOnAWTEvent(8L);
        this.wakeupCriterion = new WakeupOr((WakeupCriterion[])this.mouseEvents);
        this.wakeupOn(this.wakeupCriterion);
    }

    public void processStimulus(Enumeration enumeration) {
        this.toolID = Toolbar.getToolId();
        if (this.toolID != 12 && this.toolID != 11 && this.toolID != 7) {
            this.wakeupOn(this.wakeupCriterion);
            return;
        }
        while (enumeration.hasMoreElements()) {
            WakeupOnAWTEvent wakeupOnAWTEvent = (WakeupOnAWTEvent)enumeration.nextElement();
            AWTEvent[] aWTEventArray = wakeupOnAWTEvent.getAWTEvent();
            if (aWTEventArray.length <= 0) continue;
            AWTEvent aWTEvent = aWTEventArray[aWTEventArray.length - 1];
            if (aWTEvent instanceof MouseEvent) {
                this.doProcess((MouseEvent)aWTEvent);
            }
            if (!(aWTEvent instanceof KeyEvent)) continue;
            this.doProcess((KeyEvent)aWTEvent);
        }
        this.wakeupOn(this.wakeupCriterion);
    }

    private boolean shouldRotate(int n, int n2) {
        int n3 = 2048;
        int n4 = 1024;
        int n5 = 192;
        boolean bl = (n & (n3 | n5)) == n3;
        boolean bl2 = n2 == 12 && (n & (n4 | n5)) == n4;
        return bl || bl2;
    }

    private boolean shouldTranslate(int n, int n2) {
        int n3 = 2112;
        int n4 = 1088;
        int n5 = 128;
        return (n & (n3 | n5)) == n3 || n2 == 12 && (n & (n4 | n5)) == n4;
    }

    private boolean shouldZoom(int n, int n2) {
        if (n2 != 11) {
            return false;
        }
        int n3 = 1024;
        int n4 = 192;
        return (n & (n3 | n4)) == n3;
    }

    private boolean shouldMovePoint(int n, int n2) {
        if (n2 != 7) {
            return false;
        }
        int n3 = 1024;
        int n4 = 192;
        return (n & (n3 | n4)) == n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        if (n == 402 || n == 400) {
            return;
        }
        Content content = this.univ.getSelected();
        int n2 = keyEvent.getKeyCode();
        int n3 = -1;
        if (this.canvas.isKeyDown(88)) {
            n3 = 0;
        } else if (this.canvas.isKeyDown(89)) {
            n3 = 1;
        } else if (this.canvas.isKeyDown(90)) {
            n3 = 2;
        }
        boolean bl = true;
        try {
            if (keyEvent.isShiftDown()) {
                switch (n2) {
                    case 39: {
                        this.viewTransformer.translateXY(2, 0);
                        return;
                    }
                    case 37: {
                        this.viewTransformer.translateXY(-2, 0);
                        return;
                    }
                    case 38: {
                        this.viewTransformer.translateXY(0, -2);
                        return;
                    }
                    case 40: {
                        this.viewTransformer.translateXY(0, 2);
                        return;
                    }
                }
            } else if (keyEvent.isAltDown()) {
                switch (n2) {
                    case 38: {
                        this.viewTransformer.zoom(1);
                        return;
                    }
                    case 40: {
                        this.viewTransformer.zoom(-1);
                        return;
                    }
                }
            } else if (content != null && content.getType() == 1 && n3 != -1) {
                OrthoGroup orthoGroup = (OrthoGroup)content.getContent();
                switch (n2) {
                    case 38: 
                    case 39: {
                        orthoGroup.increase(n3);
                        return;
                    }
                    case 37: 
                    case 40: {
                        orthoGroup.decrease(n3);
                        return;
                    }
                    case 32: {
                        orthoGroup.setVisible(n3, !orthoGroup.isVisible(n3));
                        return;
                    }
                }
            } else {
                switch (n2) {
                    case 39: {
                        this.viewTransformer.rotateY(-Math.PI / 90);
                        return;
                    }
                    case 37: {
                        this.viewTransformer.rotateY(Math.PI / 90);
                        return;
                    }
                    case 38: {
                        this.viewTransformer.rotateX(Math.PI / 90);
                        return;
                    }
                    case 40: {
                        this.viewTransformer.rotateX(-Math.PI / 90);
                        return;
                    }
                    case 33: {
                        this.viewTransformer.zoom(1);
                        return;
                    }
                    case 34: {
                        this.viewTransformer.zoom(-1);
                        return;
                    }
                }
            }
            bl = false;
        }
        finally {
            if (bl) {
                keyEvent.consume();
            }
        }
    }

    private void doProcess(MouseEvent mouseEvent) {
        int n = mouseEvent.getID();
        int n2 = mouseEvent.getModifiersEx();
        Content content = this.univ.getSelected();
        if (n == 501) {
            if (content != null && !content.isLocked()) {
                this.contentTransformer.init(content, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.viewTransformer.init(mouseEvent);
            }
            if (this.toolID == 7) {
                if (content != null) {
                    content.showPointList(true);
                }
                if (n2 == 1024) {
                    this.picker.addPoint(content, mouseEvent);
                } else if (n2 == 1088) {
                    this.picker.deletePoint(content, mouseEvent);
                }
            }
        } else if (n == 506) {
            if (this.shouldTranslate(n2, this.toolID)) {
                if (content != null && !content.isLocked()) {
                    this.contentTransformer.translate(mouseEvent);
                } else {
                    this.viewTransformer.translate(mouseEvent);
                }
            } else if (this.shouldRotate(n2, this.toolID)) {
                if (content != null && !content.isLocked()) {
                    this.contentTransformer.rotate(mouseEvent);
                } else {
                    this.viewTransformer.rotate(mouseEvent);
                }
            } else if (this.shouldZoom(n2, this.toolID)) {
                this.viewTransformer.zoom(mouseEvent);
            } else if (this.shouldMovePoint(n2, this.toolID)) {
                this.picker.movePoint(content, mouseEvent);
            }
        } else if (n == 502 && this.toolID == 7) {
            this.picker.stopMoving();
        }
        if (n == 507) {
            int n3 = -1;
            if (this.canvas.isKeyDown(88)) {
                n3 = 0;
            } else if (this.canvas.isKeyDown(89)) {
                n3 = 1;
            } else if (this.canvas.isKeyDown(90)) {
                n3 = 2;
            }
            if (content != null && content.getType() == 1 && n3 != -1) {
                OrthoGroup orthoGroup = (OrthoGroup)content.getContent();
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
                int n4 = 0;
                if (mouseWheelEvent.getScrollType() == 0) {
                    n4 = mouseWheelEvent.getUnitsToScroll();
                }
                if (n4 > 0) {
                    orthoGroup.increase(n3);
                } else if (n4 < 0) {
                    orthoGroup.decrease(n3);
                }
            } else {
                this.viewTransformer.wheel_zoom(mouseEvent);
            }
        }
    }
}

