/*
 * Decompiled with CFR 0.152.
 */
package ij3d.behaviors;

import ij3d.DefaultUniverse;
import ij3d.behaviors.BehaviorCallback;
import ij3d.behaviors.ViewPlatformTransformer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class InteractiveViewPlatformTransformer
extends ViewPlatformTransformer {
    private static final double ONE_RAD = Math.PI / 180;
    private int xLast;
    private int yLast;

    public InteractiveViewPlatformTransformer(DefaultUniverse defaultUniverse, BehaviorCallback behaviorCallback) {
        super(defaultUniverse, behaviorCallback);
    }

    public void init(MouseEvent mouseEvent) {
        this.xLast = mouseEvent.getX();
        this.yLast = mouseEvent.getY();
    }

    public void translate(MouseEvent mouseEvent) {
        int n = this.xLast - mouseEvent.getX();
        int n2 = this.yLast - mouseEvent.getY();
        this.translateXY(-n, n2);
        this.xLast = mouseEvent.getX();
        this.yLast = mouseEvent.getY();
    }

    public void rotate(MouseEvent mouseEvent) {
        int n = this.xLast - mouseEvent.getX();
        int n2 = this.yLast - mouseEvent.getY();
        this.rotateXY((double)n2 * (Math.PI / 180), (double)n * (Math.PI / 180));
        this.xLast = mouseEvent.getX();
        this.yLast = mouseEvent.getY();
    }

    public void wheel_zoom(MouseEvent mouseEvent) {
        MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
        int n = 0;
        if (mouseWheelEvent.getScrollType() == 0) {
            n = mouseWheelEvent.getUnitsToScroll();
        }
        this.zoom(n);
    }

    public void zoom(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        int n2 = n - this.yLast;
        this.zoom(n2);
        this.xLast = mouseEvent.getX();
        this.yLast = n;
    }
}

