/*
 * Decompiled with CFR 0.152.
 */
package ij3d.pointlist;

import ij.gui.GenericDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import vib.BenesNamedPoint;
import vib.PointList;

public class PointListPanel
extends Panel
implements ActionListener,
PointList.PointListListener {
    private PointList points;
    private GridBagConstraints c;
    private final PopupMenu popup = this.createPopup();
    private BenesNamedPoint current;
    private DecimalFormat df = new DecimalFormat("00.000");
    private String header;
    private Color grey = Color.LIGHT_GRAY;

    public PointListPanel(String string, PointList pointList) {
        this.header = string;
        this.add(this.popup);
        this.points = pointList;
        pointList.addPointListListener(this);
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.c = new GridBagConstraints();
        this.recreatePointsPanel();
    }

    public void setPointList(PointList pointList) {
        this.points.removePointListListener(this);
        this.points = pointList;
        this.points.addPointListListener(this);
        this.recreatePointsPanel();
    }

    private PopupMenu createPopup() {
        PopupMenu popupMenu = new PopupMenu();
        MenuItem menuItem = new MenuItem("Up");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        menuItem = new MenuItem("Down");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        menuItem = new MenuItem("Rename");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        menuItem = new MenuItem("Remove");
        menuItem.addActionListener(this);
        popupMenu.add(menuItem);
        return popupMenu;
    }

    private void recreatePointsPanel() {
        this.removeAll();
        this.c = new GridBagConstraints();
        this.addHeader();
        int n = 0;
        if (this.points.size() == 0) {
            this.addEmptyRow();
        }
        for (BenesNamedPoint benesNamedPoint : this.points) {
            this.addRow(benesNamedPoint, n++);
        }
        this.validate();
    }

    private void addHeader() {
        Label label = new Label(this.header);
        label.setFont(new Font("Verdana", 1, 12));
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        this.c.gridx = 0;
        this.add((Component)label, this.c);
        this.c.gridwidth = 1;
    }

    private void addEmptyRow() {
        Label label = new Label("     No points set       ");
        this.c.gridx = 0;
        this.c.gridy = -1;
        this.c.anchor = 21;
        this.add((Component)label, this.c);
    }

    private void addRow(final BenesNamedPoint benesNamedPoint, int n) {
        if (!benesNamedPoint.isSet()) {
            return;
        }
        this.c.gridx = 0;
        this.c.gridy = -1;
        this.c.fill = 1;
        this.c.anchor = 21;
        final Label label = new Label(benesNamedPoint.getName() + "   ");
        label.setName(benesNamedPoint.getName());
        label.setFont(new Font("Verdana", 1, 12));
        label.setForeground(Color.BLUE);
        if (n % 2 == 1) {
            label.setBackground(this.grey);
        }
        label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PointListPanel.this.current = benesNamedPoint;
                    PointListPanel.this.popup.show(label, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    PointListPanel.this.points.highlight(benesNamedPoint);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    PointListPanel.this.current = benesNamedPoint;
                    PointListPanel.this.popup.show(label, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.add((Component)label, this.c);
        this.c.anchor = 21;
        this.c.gridx = 1;
        this.c.fill = 1;
        Label label2 = new Label(this.df.format(benesNamedPoint.x) + "    " + this.df.format(benesNamedPoint.y) + "    " + this.df.format(benesNamedPoint.z));
        label2.setFont(new Font("Verdana", 0, 12));
        if (n % 2 == 1) {
            label2.setBackground(this.grey);
        }
        this.add((Component)label2, this.c);
    }

    public void renamePoint(BenesNamedPoint benesNamedPoint) {
        GenericDialog genericDialog = new GenericDialog("Rename point");
        genericDialog.addStringField("New name ", benesNamedPoint.getName());
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.points.rename(benesNamedPoint, genericDialog.getNextString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Rename")) {
            this.renamePoint(this.current);
        } else if (string.equals("Remove")) {
            this.points.remove(this.current);
        } else if (string.equals("Up")) {
            this.points.up(this.current);
        } else if (string.equals("Down")) {
            this.points.down(this.current);
        }
    }

    public void added(BenesNamedPoint benesNamedPoint) {
        int n = this.points.size();
        if (n == 1) {
            this.recreatePointsPanel();
        } else {
            this.addRow(benesNamedPoint, this.points.size());
            Container container = this.getParent();
            while (container.getParent() != null) {
                container = container.getParent();
            }
            container.validate();
        }
    }

    public void removed(BenesNamedPoint benesNamedPoint) {
        this.recreatePointsPanel();
    }

    public void renamed(BenesNamedPoint benesNamedPoint) {
        this.recreatePointsPanel();
    }

    public void highlighted(BenesNamedPoint benesNamedPoint) {
    }

    public void reordered() {
        this.recreatePointsPanel();
    }

    public void moved(BenesNamedPoint benesNamedPoint) {
        Component[] componentArray = this.getComponents();
        boolean bl = false;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].getName().equals(benesNamedPoint.getName()) || i >= componentArray.length - 1) continue;
            Label label = (Label)componentArray[i + 1];
            label.setText(this.df.format(benesNamedPoint.x) + "    " + this.df.format(benesNamedPoint.y) + "    " + this.df.format(benesNamedPoint.z));
            bl = true;
        }
        if (!bl) {
            this.recreatePointsPanel();
        }
    }
}

