/*
 * Decompiled with CFR 0.152.
 */
package ij3d.pointlist;

import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.ScaleInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import vib.BenesNamedPoint;
import vib.PointList;

public class PointListShape
extends BranchGroup
implements PointList.PointListListener {
    private PointList points;
    private Color3f color = new Color3f(1.0f, 1.0f, 0.0f);
    private Appearance appearance;
    private float radius = 10.0f;
    private Transform3D t3d = new Transform3D();
    private Vector3f v3f = new Vector3f();

    public PointListShape(PointList pointList) {
        this.setCapability(14);
        this.setCapability(13);
        this.setCapability(17);
        this.points = pointList;
        pointList.addPointListListener(this);
        this.initAppearance(this.color);
        this.recreate();
    }

    public void setPointList(PointList pointList) {
        this.points.removePointListListener(this);
        this.points = pointList;
        this.points.addPointListListener(this);
        this.recreate();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
        Transform3D transform3D = new Transform3D();
        transform3D.set((double)this.radius);
        for (int i = 0; i < this.numChildren(); ++i) {
            BranchGroup branchGroup = (BranchGroup)this.getChild(i);
            TransformGroup transformGroup = (TransformGroup)branchGroup.getChild(0);
            ScaleInterpolator scaleInterpolator = (ScaleInterpolator)transformGroup.getChild(1);
            scaleInterpolator.setMaximumScale(5.0f * this.radius);
            scaleInterpolator.setMinimumScale(this.radius);
            TransformGroup transformGroup2 = (TransformGroup)transformGroup.getChild(0);
            transformGroup2.setTransform(transform3D);
        }
    }

    public void setColor(Color3f color3f) {
        this.color = color3f == null ? new Color3f(1.0f, 1.0f, 0.0f) : color3f;
        this.initAppearance(this.color);
        for (int i = 0; i < this.numChildren(); ++i) {
            BranchGroup branchGroup = (BranchGroup)this.getChild(i);
            TransformGroup transformGroup = (TransformGroup)((Group)branchGroup.getChild(0)).getChild(0);
            Sphere sphere = (Sphere)transformGroup.getChild(0);
            sphere.setAppearance(this.appearance);
        }
    }

    public void added(BenesNamedPoint benesNamedPoint) {
        Point3f point3f = new Point3f((float)benesNamedPoint.x, (float)benesNamedPoint.y, (float)benesNamedPoint.z);
        this.addPointToGeometry(point3f, benesNamedPoint.getName());
    }

    public void removed(BenesNamedPoint benesNamedPoint) {
        this.deletePointFromGeometry(benesNamedPoint.getName());
    }

    public void renamed(BenesNamedPoint benesNamedPoint) {
        int n = this.points.indexOf(benesNamedPoint);
        this.getChild(n).setName(this.points.get(n).getName());
    }

    public void moved(BenesNamedPoint benesNamedPoint) {
        int n = this.points.indexOf(benesNamedPoint);
        if (n >= 0 && n < this.points.size()) {
            this.updatePositionInGeometry(n, new Point3d(benesNamedPoint.x, benesNamedPoint.y, benesNamedPoint.z));
        }
    }

    public void reordered() {
        this.recreate();
    }

    public void highlighted(BenesNamedPoint benesNamedPoint) {
        int n = this.points.indexOf(benesNamedPoint);
        BranchGroup branchGroup = (BranchGroup)this.getChild(n);
        TransformGroup transformGroup = (TransformGroup)branchGroup.getChild(0);
        ScaleInterpolator scaleInterpolator = (ScaleInterpolator)transformGroup.getChild(1);
        Alpha alpha = scaleInterpolator.getAlpha();
        scaleInterpolator.setEnable(true);
        alpha.resume();
        try {
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        alpha.pause();
        scaleInterpolator.setEnable(false);
    }

    private void deletePointFromGeometry(String string) {
        for (int i = 0; i < this.numChildren(); ++i) {
            BranchGroup branchGroup = (BranchGroup)this.getChild(i);
            if (!branchGroup.getName().equals(string)) continue;
            branchGroup.detach();
            return;
        }
    }

    private void addPointToGeometry(Point3f point3f, String string) {
        this.v3f.x = point3f.x;
        this.v3f.y = point3f.y;
        this.v3f.z = point3f.z;
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setName(string);
        branchGroup.setCapability(17);
        this.t3d.set(this.v3f);
        TransformGroup transformGroup = new TransformGroup(this.t3d);
        transformGroup.setCapability(18);
        branchGroup.addChild((Node)transformGroup);
        TransformGroup transformGroup2 = new TransformGroup();
        transformGroup2.setCapability(18);
        transformGroup.addChild((Node)transformGroup2);
        Alpha alpha = new Alpha();
        alpha.setStartTime(System.currentTimeMillis());
        alpha.setMode(3);
        alpha.setIncreasingAlphaDuration(300L);
        alpha.setDecreasingAlphaDuration(300L);
        alpha.pause();
        ScaleInterpolator scaleInterpolator = new ScaleInterpolator(alpha, transformGroup2);
        scaleInterpolator.setMaximumScale(5.0f * this.radius);
        scaleInterpolator.setMinimumScale(this.radius);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        scaleInterpolator.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)scaleInterpolator);
        Sphere sphere = new Sphere();
        sphere.getShape().setCapability(15);
        sphere.setCapability(64);
        sphere.setAppearance(this.appearance);
        transformGroup2.addChild((Node)sphere);
        this.addChild((Node)branchGroup);
        scaleInterpolator.setEnable(true);
    }

    private void updatePositionInGeometry(int n, Point3d point3d) {
        BranchGroup branchGroup = (BranchGroup)this.getChild(n);
        TransformGroup transformGroup = (TransformGroup)branchGroup.getChild(0);
        this.v3f.x = (float)point3d.x;
        this.v3f.y = (float)point3d.y;
        this.v3f.z = (float)point3d.z;
        this.t3d.set(this.v3f);
        transformGroup.setTransform(this.t3d);
    }

    private void recreate() {
        this.removeAllChildren();
        for (int i = 0; i < this.points.size(); ++i) {
            BenesNamedPoint benesNamedPoint = this.points.get(i);
            Point3f point3f = new Point3f((float)benesNamedPoint.x, (float)benesNamedPoint.y, (float)benesNamedPoint.z);
            this.addPointToGeometry(point3f, benesNamedPoint.getName());
        }
    }

    private void initAppearance(Color3f color3f) {
        this.appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setShadeModel(3);
        coloringAttributes.setColor(color3f);
        this.appearance.setColoringAttributes(coloringAttributes);
        Material material = new Material();
        material.setDiffuseColor(color3f);
        this.appearance.setMaterial(material);
    }

    public String toString() {
        return this.points.toString();
    }
}

