/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shapes;

import com.sun.j3d.utils.geometry.Sphere;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class BoundingSphere
extends BranchGroup {
    private Point3f center;
    private float radius;
    private Color3f color;
    private float transparency;
    private TransformGroup scaleTG;
    private Transform3D scale = new Transform3D();
    private TransformGroup translateTG;
    private Transform3D translate = new Transform3D();
    private TransparencyAttributes ta;
    private PolygonAttributes pa;
    private ColoringAttributes ca;
    private Appearance appearance;

    public BoundingSphere(Point3f point3f, float f) {
        this(point3f, f, new Color3f(1.0f, 0.0f, 0.0f));
    }

    public BoundingSphere(Point3f point3f, float f, Color3f color3f) {
        this(point3f, f, color3f, 0.0f);
    }

    public BoundingSphere(Point3f point3f, float f, Color3f color3f, float f2) {
        this.setCapability(17);
        this.center = new Point3f(point3f);
        this.radius = f;
        this.color = color3f;
        this.transparency = f2;
        this.appearance = new Appearance();
        this.pa = new PolygonAttributes();
        this.pa.setPolygonMode(1);
        this.pa.setCullFace(0);
        this.appearance.setPolygonAttributes(this.pa);
        this.ta = new TransparencyAttributes();
        this.ta.setTransparency(f2);
        this.ta.setTransparencyMode(0);
        this.appearance.setTransparencyAttributes(this.ta);
        this.ca = new ColoringAttributes();
        this.ca.setColor(color3f);
        this.appearance.setColoringAttributes(this.ca);
        Sphere sphere = new Sphere(1.0f, this.appearance);
        sphere.setName("BS");
        Vector3f vector3f = new Vector3f((Tuple3f)point3f);
        this.translate.set(vector3f);
        this.translateTG = new TransformGroup(this.translate);
        this.translateTG.setCapability(18);
        this.scale.set((double)f);
        this.scaleTG = new TransformGroup(this.scale);
        this.scaleTG.setCapability(18);
        this.scaleTG.addChild((Node)sphere);
        this.translateTG.addChild((Node)this.scaleTG);
        this.addChild((Node)this.translateTG);
    }

    public void setRadius(float f) {
        this.radius = f;
        this.scale.set((double)f);
        this.scaleTG.setTransform(this.scale);
    }

    public void setCenter(Point3f point3f) {
        this.center.set((Tuple3f)point3f);
        Vector3f vector3f = new Vector3f((Tuple3f)point3f);
        this.translate.set(vector3f);
        this.translateTG.setTransform(this.translate);
    }

    public void getTransform(Transform3D transform3D) {
        transform3D.set(new Vector3f((Tuple3f)this.center));
        transform3D.mul(this.scale);
    }

    public void getTransformInverse(Transform3D transform3D) {
        this.getTransform(transform3D);
        transform3D.invert();
    }

    public String toString() {
        return "[BoundingSphere center: " + this.center + " radius: " + this.radius + "] " + ((Object)((Object)this)).hashCode();
    }
}

