/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shapes;

import java.awt.Font;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class CoordinateSystem
extends BranchGroup {
    private float length;
    private Color3f color;

    public CoordinateSystem(float f, Color3f color3f) {
        this.length = f;
        this.color = color3f;
        this.setCapability(17);
        Shape3D shape3D = new Shape3D();
        shape3D.setGeometry(this.createGeometry());
        this.addChild((Node)shape3D);
        Appearance appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setColor(color3f);
        appearance.setColoringAttributes(coloringAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polygonAttributes);
        try {
            Transform3D transform3D = new Transform3D();
            transform3D.setTranslation(new Vector3f(f, -f / 4.0f, 0.0f));
            this.addText("x", transform3D, appearance);
            transform3D.setTranslation(new Vector3f(-f / 4.0f, f, 0.0f));
            this.addText("y", transform3D, appearance);
            transform3D.setTranslation(new Vector3f(-f / 4.0f, -f / 4.0f, f));
            this.addText("z", transform3D, appearance);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addText(String string, Transform3D transform3D, Appearance appearance) {
        TransformGroup transformGroup = new TransformGroup(transform3D);
        this.addChild((Node)transformGroup);
        Font3D font3D = new Font3D(new Font("Helvetica", 0, (int)this.length / 3), new FontExtrusion());
        Text3D text3D = new Text3D(font3D, string);
        text3D.setAlignment(0);
        OrientedShape3D orientedShape3D = new OrientedShape3D();
        orientedShape3D.setGeometry((Geometry)text3D);
        orientedShape3D.setAppearance(appearance);
        orientedShape3D.setAlignmentAxis(0.0f, 1.0f, 0.0f);
        transformGroup.addChild((Node)orientedShape3D);
    }

    public Geometry createGeometry() {
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f(this.length, 0.0f, 0.0f);
        Point3f point3f3 = new Point3f(0.0f, this.length, 0.0f);
        Point3f point3f4 = new Point3f(0.0f, 0.0f, this.length);
        Point3f[] point3fArray = new Point3f[]{point3f, point3f2, point3f, point3f3, point3f, point3f4};
        int n = point3fArray.length;
        Color3f[] color3fArray = new Color3f[n];
        for (int i = 0; i < n; ++i) {
            color3fArray[i] = this.color;
        }
        LineArray lineArray = new LineArray(n, 5);
        lineArray.setCoordinates(0, point3fArray);
        lineArray.setColors(0, color3fArray);
        return lineArray;
    }
}

