/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shapes;

import java.awt.Font;
import java.text.DecimalFormat;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Scalebar
extends BranchGroup {
    private DecimalFormat df = new DecimalFormat("###0.00");
    private float length = 1.0f;
    private Color3f color = new Color3f(1.0f, 1.0f, 1.0f);
    private float x = 2.0f;
    private float y = 2.0f;
    private String unit = "";
    private TransformGroup positionTG;
    private TransformGroup textTG;
    private Shape3D lineShape;
    private OrientedShape3D textShape;

    public Scalebar() {
        this(1.0f);
    }

    public Scalebar(float f) {
        Transform3D transform3D = new Transform3D();
        this.positionTG = new TransformGroup(transform3D);
        this.positionTG.setCapability(17);
        this.positionTG.setCapability(18);
        this.addChild((Node)this.positionTG);
        this.lineShape = new Shape3D();
        this.lineShape.setGeometry(this.createLineGeometry());
        this.lineShape.setCapability(13);
        this.positionTG.addChild((Node)this.lineShape);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setTranslation(new Vector3f(f / 2.0f, -f / 2.0f, 0.0f));
        this.textTG = new TransformGroup(transform3D2);
        this.textTG.setCapability(18);
        this.positionTG.addChild((Node)this.textTG);
        this.textShape = new OrientedShape3D();
        this.textShape.setCapability(13);
        this.textShape.setCapability(15);
        this.textShape.setGeometry(this.createTextGeometry());
        this.textShape.setAppearance(this.createTextAppearance());
        this.textShape.setAlignmentAxis(0.0f, 1.0f, 0.0f);
        this.textTG.addChild((Node)this.textShape);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getLength() {
        return this.length;
    }

    public String getUnit() {
        return this.unit;
    }

    public Color3f getColor() {
        return this.color;
    }

    public void setUnit(String string) {
        this.unit = string;
        this.textShape.setGeometry(this.createTextGeometry());
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(f, f2, 0.0f));
        this.positionTG.setTransform(transform3D);
    }

    public void setLength(float f) {
        this.length = f;
        this.lineShape.setGeometry(this.createLineGeometry());
        this.textShape.setGeometry(this.createTextGeometry());
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(this.length / 2.0f, -this.length / 2.0f, 0.0f));
        this.textTG.setTransform(transform3D);
    }

    public void setColor(Color3f color3f) {
        this.color = color3f;
        this.lineShape.setGeometry(this.createLineGeometry());
        this.textShape.setAppearance(this.createTextAppearance());
    }

    public Appearance createTextAppearance() {
        Appearance appearance = new Appearance();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setColor(this.color);
        appearance.setColoringAttributes(coloringAttributes);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        appearance.setPolygonAttributes(polygonAttributes);
        return appearance;
    }

    public Geometry createTextGeometry() {
        String string = this.df.format(this.length) + " " + this.unit;
        Font3D font3D = new Font3D(new Font("Helvetica", 0, (int)this.length / 3), new FontExtrusion());
        try {
            Text3D text3D = new Text3D(font3D, string);
            text3D.setAlignment(0);
            return text3D;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Geometry createLineGeometry() {
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f(this.length, 0.0f, 0.0f);
        Point3f[] point3fArray = new Point3f[]{point3f, point3f2};
        int n = point3fArray.length;
        Color3f[] color3fArray = new Color3f[n];
        for (int i = 0; i < n; ++i) {
            color3fArray[i] = this.color;
        }
        LineArray lineArray = new LineArray(n, 5);
        lineArray.setCoordinates(0, point3fArray);
        lineArray.setColors(0, color3fArray);
        return lineArray;
    }
}

