/*
 * Decompiled with CFR 0.152.
 */
package inference;

public class LogFuncs {
    private static final LogFuncs _theInstance = new LogFuncs();
    private static final int maxFactorial = 10000;
    private double[] factorials = new double[10000];
    public static final double pi = Math.PI;
    static final double[] p = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};

    private LogFuncs() {
        this.factorials[0] = 0.0;
        for (int i = 1; i < 10000; ++i) {
            this.factorials[i] = this.factorials[i - 1] + Math.log(i);
        }
    }

    public static double LogFactorial(int n) {
        if (n >= 0 && n < 10000) {
            return LogFuncs._theInstance.factorials[n];
        }
        return LogFuncs.LogGamma(n - 1);
    }

    public static double LogPow(double d, double d2) {
        return d2 * Math.log(d);
    }

    public static double LogAddLogLog(double d, double d2) {
        if (d > d2) {
            return d + Math.log(1.0 + Math.exp(d2 - d));
        }
        return d2 + Math.log(1.0 + Math.exp(d - d2));
    }

    public static double LogGamma(double d) {
        double d2 = p[0];
        for (int i = 1; i < 7; ++i) {
            d2 += p[i] / (d + (double)i);
        }
        return 0.5 * Math.log(Math.PI * 2) - Math.log(d) + Math.log(d2) + (d + 0.5) * Math.log(d + 5.5) - (d + 5.5);
    }

    public static double LogPoisson(double d, double d2) {
        return -d + d2 * Math.log(d) - LogFuncs.LogGamma(d2 + 1.0);
    }
}

