/*
 * Decompiled with CFR 0.152.
 */
package inference;

import inference.LogFuncs;
import java.util.Vector;

public class MAPInference {
    public int[] data;
    public int[] count;
    public short[][] maxpos;
    public short[] boundaries;
    public int Mmax;
    public double[] subEvidences;
    double[] logA;
    double[] logEvidences;

    public void setData(int[] nArray) {
        this.data = nArray;
        this.initCount();
    }

    public void setData(Vector vector) {
        int n = vector.size();
        this.data = new int[n];
        for (int i = 0; i < n; ++i) {
            this.data[i] = (Integer)vector.get(i);
        }
        this.initCount();
    }

    public void initCount() {
        int n;
        this.count = new int[this.K() + 1];
        this.subEvidences = new double[this.K() * this.K()];
        this.count[0] = 0;
        for (n = 1; n <= this.K(); ++n) {
            this.count[n] = this.count[n - 1] + this.data[n - 1];
        }
        for (n = -1; n < this.K() - 1; ++n) {
            for (int i = n + 1; i < this.K(); ++i) {
                int n2 = this.getCount(n, i);
                this.subEvidences[i + (n + 1) * this.K()] = LogFuncs.LogFactorial(n2) - LogFuncs.LogPow(i - n, n2);
            }
        }
    }

    public int getCount(int n, int n2) {
        return this.count[n2 + 1] - this.count[n + 1];
    }

    public int K() {
        return this.data.length;
    }

    public int N() {
        return this.count[this.K()];
    }

    private void init(int n) {
        this.logA = new double[this.K()];
        this.logEvidences = new double[n + 1];
        this.maxpos = new short[n][this.K()];
        this.boundaries = new short[n];
        for (int i = 0; i < this.K(); ++i) {
            this.logA[i] = this.subEvidences[i];
        }
        this.logEvidences[0] = this.substep4b(0);
    }

    private double substep4aii(int n, int n2) {
        double d = -1.0E300;
        double d2 = -1.0E300;
        for (int i = n2; i < n; ++i) {
            double d3 = this.logA[i] + this.subEvidences[n + (i + 1) * this.K()];
            d = LogFuncs.LogAddLogLog(d, d3);
            if (!(d3 > d2)) continue;
            d2 = d3;
            this.maxpos[n2][n] = (short)i;
        }
        return d;
    }

    private double substep4b(int n) {
        return this.logA[this.K() - 1] + this.defaultLogPrior(n);
    }

    private int step4(int n, boolean bl) {
        for (int i = 1; i < n; ++i) {
            for (int j = this.K() - 1; j >= i; --j) {
                this.logA[j] = this.substep4aii(j, i - 1);
            }
            this.logEvidences[i] = this.substep4b(i);
            if (!bl || !(this.logEvidences[i] - this.logEvidences[i - 1] < 0.0)) continue;
            return i - 1;
        }
        return n;
    }

    void step6(int n) {
        this.logA[this.K() - 1] = this.substep4aii(this.K() - 1, n - 1);
        this.logEvidences[n] = this.substep4b(n);
    }

    public void doit(int n, boolean bl) {
        this.init(n);
        this.Mmax = this.step4(n, bl);
        if (n == this.Mmax) {
            this.step6(this.Mmax);
        }
        this.computeBoundaries(this.Mmax);
    }

    public double defaultLogPrior(int n) {
        return LogFuncs.LogFactorial(this.K() - 1 - n) + 2.0 * LogFuncs.LogFactorial(n) - LogFuncs.LogFactorial(this.K() - 1) - LogFuncs.LogFactorial(this.N() + n);
    }

    private void computeBoundaries(int n) {
        this.boundaries[n - 1] = this.maxpos[n - 1][this.K() - 1];
        System.err.println("MAPBB " + (n - 1) + ": " + this.boundaries[n - 1]);
        for (int i = n - 2; i >= 0; --i) {
            this.boundaries[i] = this.maxpos[i][this.boundaries[i + 1]];
            System.err.println("MAPBB " + i + ": " + this.boundaries[i]);
        }
    }

    public double getPosteriorProb() {
        int n = this.getCount(-1, this.boundaries[0]);
        double d = this.defaultLogPrior(this.Mmax);
        d += LogFuncs.LogFactorial(n) - LogFuncs.LogPow(this.boundaries[0] + 1, n);
        for (int i = 1; i < this.Mmax; ++i) {
            n = this.getCount(this.boundaries[i - 1], this.boundaries[i]);
            d += LogFuncs.LogFactorial(n) - LogFuncs.LogPow(this.boundaries[i] - this.boundaries[i - 1], n);
        }
        n = this.getCount(this.boundaries[this.Mmax - 1], this.K() - 1);
        d += LogFuncs.LogFactorial(n) - LogFuncs.LogPow(this.K() - 1 - this.boundaries[this.Mmax - 1], n);
        return Math.exp(d -= this.logEvidences[this.Mmax]);
    }

    public short getBoundary(int n) {
        if (n >= 0 && n < this.boundaries.length) {
            return this.boundaries[n];
        }
        return -1;
    }

    public int rebin(int n) {
        int n2;
        for (n2 = 0; n2 < this.boundaries.length && this.boundaries[n2] < n; ++n2) {
        }
        return n2;
    }

    public static void main(String[] stringArray) {
        MAPInference mAPInference = new MAPInference();
        for (int i = 1; i < 10000; i *= 10) {
            int[] nArray = new int[]{i, i, 3 * i, i, 10 * i, 10 * i, 10 * i, 8 * i};
            mAPInference.setData(nArray);
            mAPInference.doit(7, true);
            System.err.println("N: " + 44 * i);
            System.err.println("MAP Prob " + mAPInference.getPosteriorProb());
            System.err.println();
        }
    }
}

