/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import amira.AmiraParameters;
import ij.IJ;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij3d.Image3DUniverse;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

public class AmiraSurface
implements PlugIn {
    public void run(String string) {
        Image3DUniverse image3DUniverse;
        if (string.equals("")) {
            image3DUniverse = new OpenDialog("AmiraFile", null);
            if (image3DUniverse.getDirectory() == null) {
                return;
            }
            string = image3DUniverse.getDirectory() + image3DUniverse.getFileName();
        }
        image3DUniverse = new Image3DUniverse();
        try {
            AmiraSurface.addMeshes(image3DUniverse, string);
        }
        catch (IOException iOException) {
            IJ.error((String)("Could not read '" + string + "': " + iOException));
            return;
        }
        image3DUniverse.show();
    }

    public static void addMeshes(Image3DUniverse image3DUniverse, String string) throws IOException {
        Object object;
        Point3f point3f;
        int n;
        String string2;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        if (!dataInputStream.readLine().startsWith("# HyperSurface 0.1 BINARY")) {
            throw new RuntimeException("No Amira surface");
        }
        String string3 = "";
        while ((string2 = dataInputStream.readLine()) != null && !string2.startsWith("Vertices")) {
            string3 = string3 + string2 + "\n";
        }
        AmiraParameters amiraParameters = new AmiraParameters(string3);
        int n2 = Integer.parseInt(string2.substring(9));
        Point3f[] point3fArray = new Point3f[n2];
        for (int i = 0; i < n2; ++i) {
            float f = dataInputStream.readFloat();
            float f2 = dataInputStream.readFloat();
            float f3 = dataInputStream.readFloat();
            point3fArray[i] = new Point3f(f, f2, f3);
        }
        while ((string2 = dataInputStream.readLine()) != null && !string2.trim().startsWith("Patches")) {
        }
        HashMap hashMap = new HashMap();
        int n3 = Integer.parseInt(string2.substring(8));
        for (int i = 0; i < n3; ++i) {
            List<Point3f> list = null;
            Object object2 = null;
            while ((string2 = dataInputStream.readLine()) != null && !string2.trim().startsWith("Triangles")) {
                if (string2.startsWith("InnerRegion")) {
                    list = AmiraSurface.getMesh(hashMap, string2.substring(12));
                    continue;
                }
                if (!string2.startsWith("OuterRegion")) continue;
                object2 = AmiraSurface.getMesh(hashMap, string2.substring(12));
            }
            if (list == null) {
                IJ.error((String)"Funny mesh encountered");
                list = new ArrayList();
            }
            n = Integer.parseInt(string2.trim().substring(10));
            for (int j = 0; j < n; ++j) {
                point3f = point3fArray[dataInputStream.readInt() - 1];
                object = point3fArray[dataInputStream.readInt() - 1];
                Point3f point3f2 = point3fArray[dataInputStream.readInt() - 1];
                list.add(point3f);
                list.add((Point3f)object);
                list.add(point3f2);
                if (object2 == null) continue;
                object2.add(point3f2);
                object2.add(object);
                object2.add(point3f);
            }
        }
        Color3f color3f = new Color3f(0.5f, 0.5f, 0.5f);
        for (Object object2 : hashMap.keySet()) {
            n = amiraParameters.getMaterialID((String)object2);
            double[] dArray = amiraParameters.getMaterialColor(n);
            point3f = dArray[0] == 0.0 && dArray[1] == 0.0 && dArray[2] == 0.0 ? color3f : new Color3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
            object = (List)hashMap.get(object2);
            if (object.size() == 0) continue;
            image3DUniverse.addMesh((List<Point3f>)object, (Color3f)point3f, (String)object2, 0);
        }
    }

    private static List getMesh(Map map, String string) {
        if (string.equals("Exterior")) {
            return null;
        }
        if (!map.containsKey(string)) {
            map.put(string, new ArrayList());
        }
        return (List)map.get(string);
    }
}

